function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _wrapRegExp() { _wrapRegExp = function (e, r) { return new BabelRegExp(e, void 0, r); }; var e = RegExp.prototype, r = new WeakMap(); function BabelRegExp(e, t, p) { var o = RegExp(e, t); return r.set(o, p || r.get(e)), _setPrototypeOf(o, BabelRegExp.prototype); } function buildGroups(e, t) { var p = r.get(t); return Object.keys(p).reduce(function (r, t) { var o = p[t]; if ("number" == typeof o) r[t] = e[o];else { for (var i = 0; void 0 === e[o[i]] && i + 1 < o.length;) i++; r[t] = e[o[i]]; } return r; }, Object.create(null)); } return _inherits(BabelRegExp, RegExp), BabelRegExp.prototype.exec = function (r) { var t = e.exec.call(this, r); if (t) { t.groups = buildGroups(t, this); var p = t.indices; p && (p.groups = buildGroups(p, this)); } return t; }, BabelRegExp.prototype[Symbol.replace] = function (t, p) { if ("string" == typeof p) { var o = r.get(this); return e[Symbol.replace].call(this, t, p.replace(/\$<([^>]+)(>|$)/g, function (e, r, t) { if ("" === t) return e; var p = o[r]; return Array.isArray(p) ? "$" + p.join("$") : "number" == typeof p ? "$" + p : ""; })); } if ("function" == typeof p) { var i = this; return e[Symbol.replace].call(this, t, function () { var e = arguments; return "object" != typeof e[e.length - 1] && (e = [].slice.call(e)).push(buildGroups(e, i)), p.apply(this, e); }); } return e[Symbol.replace].call(this, t, p); }, _wrapRegExp.apply(this, arguments); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import memoizeIntlConstructor from 'intl-format-cache';
import IntlMessageFormat from 'intl-messageformat';
import IntlRelativeFormat from 'intl-relativeformat';
import { formats as EN_FORMATS } from './formats';
import { hasValues, isObject, isString, mergeAll } from './helper';
import { isPseudoLocale, translateUsingPseudoLocale } from './pseudo_locale';

// Add all locale data to `IntlMessageFormat`.
import './locales.js';
const EN_LOCALE = 'en';
const translationsForLocale = {};
const getMessageFormat = memoizeIntlConstructor(IntlMessageFormat);

/* A locale code is made of several components:
 *    * lang: The two- and three-letter lower-case language code follows the ISO 639-1 and ISO 639-2/3 standards, respectively.
 *    * script: The optional four-letter title-case code follows the ISO 15924 standard for representing writing systems.
 *    * region: The two-letter upper-case region code follows the ISO 3166-1 alpha-2 standard.
 *
 * Ref: https://www.rfc-editor.org/rfc/rfc5646.txt
 * Note: While case carries no distinction with locale codes, proper formatting is recommended.
 */
const localeParser = /*#__PURE__*/_wrapRegExp(/^([a-z]{2,3})(?:\x2D([a-z]{4}))?(?:\x2D([a-z]{2}|[0-9]{3}))?(?:[_@\-].*)?$/i, {
  lang: 1,
  script: 2,
  region: 3
});
let defaultLocale = EN_LOCALE;
let currentLocale = EN_LOCALE;
let formats = EN_FORMATS;
IntlMessageFormat.defaultLocale = defaultLocale;
IntlRelativeFormat.defaultLocale = defaultLocale;

/**
 * Returns message by the given message id.
 * @param id - path to the message
 */
function getMessageById(id) {
  const translation = getTranslation();
  return translation.messages ? translation.messages[id] : undefined;
}

/**
 * Normalizes locale to make it consistent with IntlMessageFormat locales
 * @param locale
 */
export function normalizeLocale(locale) {
  var _localeParser$exec;
  const {
    lang,
    script,
    region
  } = ((_localeParser$exec = localeParser.exec(locale)) === null || _localeParser$exec === void 0 ? void 0 : _localeParser$exec.groups) || {};
  // If parsing failed or the language code was not extracted, return the locale
  if (!lang) return locale;
  const parts = [lang.toLowerCase()];
  if (script) parts.push(script[0].toUpperCase() + script.slice(1).toLowerCase());
  if (region) parts.push(region.toUpperCase());
  return parts.join('-');
}

/**
 * Provides a way to register translations with the engine
 * @param newTranslation
 * @param [locale = messages.locale]
 */
export function addTranslation(newTranslation) {
  let locale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : newTranslation.locale;
  if (!locale || !isString(locale)) {
    throw new Error('[I18n] A `locale` must be a non-empty string to add messages.');
  }
  if (newTranslation.locale && newTranslation.locale !== locale) {
    throw new Error('[I18n] A `locale` in the translation object is different from the one provided as a second argument.');
  }
  const normalizedLocale = normalizeLocale(locale);
  const existingTranslation = translationsForLocale[normalizedLocale] || {
    messages: {}
  };
  translationsForLocale[normalizedLocale] = {
    formats: newTranslation.formats || existingTranslation.formats,
    locale: newTranslation.locale || existingTranslation.locale,
    messages: _objectSpread(_objectSpread({}, existingTranslation.messages), newTranslation.messages)
  };
}

/**
 * Returns messages for the current language
 */
export function getTranslation() {
  return translationsForLocale[currentLocale] || {
    messages: {}
  };
}

/**
 * Tells the engine which language to use by given language key
 * @param locale
 */
export function setLocale(locale) {
  if (!locale || !isString(locale)) {
    throw new Error('[I18n] A `locale` must be a non-empty string.');
  }
  currentLocale = normalizeLocale(locale);
}

/**
 * Returns the current locale
 */
export function getLocale() {
  return currentLocale;
}

/**
 * Tells the library which language to fallback when missing translations
 * @param locale
 */
export function setDefaultLocale(locale) {
  if (!locale || !isString(locale)) {
    throw new Error('[I18n] A `locale` must be a non-empty string.');
  }
  defaultLocale = normalizeLocale(locale);
  IntlMessageFormat.defaultLocale = defaultLocale;
  IntlRelativeFormat.defaultLocale = defaultLocale;
}
export function getDefaultLocale() {
  return defaultLocale;
}

/**
 * Supplies a set of options to the underlying formatter
 * [Default format options used as the prototype of the formats]
 * {@link https://github.com/yahoo/intl-messageformat/blob/master/src/core.js#L62}
 * These are used when constructing the internal Intl.NumberFormat
 * and Intl.DateTimeFormat instances.
 * @param newFormats
 * @param [newFormats.number]
 * @param [newFormats.date]
 * @param [newFormats.time]
 */
export function setFormats(newFormats) {
  if (!isObject(newFormats) || !hasValues(newFormats)) {
    throw new Error('[I18n] A `formats` must be a non-empty object.');
  }
  formats = mergeAll(formats, newFormats);
}

/**
 * Returns current formats
 */
export function getFormats() {
  return formats;
}

/**
 * Returns array of locales having translations
 */
export function getRegisteredLocales() {
  return Object.keys(translationsForLocale);
}
/**
 * Translate message by id
 * @param id - translation id to be translated
 * @param [options]
 * @param [options.values] - values to pass into translation
 * @param [options.defaultMessage] - will be used unless translation was successful
 */
export function translate(id, _ref) {
  let {
    values = {},
    defaultMessage
  } = _ref;
  const shouldUsePseudoLocale = isPseudoLocale(currentLocale);
  if (!id || !isString(id)) {
    throw new Error('[I18n] An `id` must be a non-empty string to translate a message.');
  }
  const message = shouldUsePseudoLocale ? defaultMessage : getMessageById(id);
  if (!message && !defaultMessage) {
    throw new Error("[I18n] Cannot format message: \"".concat(id, "\". Default message must be provided."));
  }
  if (message) {
    try {
      // We should call `format` even for messages without any value references
      // to let it handle escaped curly braces `\\{` that are the part of the text itself
      // and not value reference boundaries.
      const formattedMessage = getMessageFormat(message, getLocale(), getFormats()).format(values);
      return shouldUsePseudoLocale ? translateUsingPseudoLocale(formattedMessage) : formattedMessage;
    } catch (e) {
      throw new Error("[I18n] Error formatting message: \"".concat(id, "\" for locale: \"").concat(getLocale(), "\".\n").concat(e));
    }
  }
  try {
    const msg = getMessageFormat(defaultMessage, getDefaultLocale(), getFormats());
    return msg.format(values);
  } catch (e) {
    throw new Error("[I18n] Error formatting the default message for: \"".concat(id, "\".\n").concat(e));
  }
}

/**
 * Initializes the engine
 * @param newTranslation
 */
export function init(newTranslation) {
  if (!newTranslation) {
    return;
  }
  addTranslation(newTranslation);
  if (newTranslation.locale) {
    setLocale(newTranslation.locale);
  }
  if (newTranslation.formats) {
    setFormats(newTranslation.formats);
  }
}

/**
 * Loads JSON with translations from the specified URL and initializes i18n engine with them.
 * @param translationsUrl URL pointing to the JSON bundle with translations.
 */
export async function load(translationsUrl) {
  // Once this package is integrated into core OpenSearch Dashboards we should switch to an abstraction
  // around `fetch` provided by the platform, e.g. `kfetch`.
  const response = await fetch(translationsUrl, {
    credentials: 'same-origin'
  });
  if (response.status >= 300) {
    throw new Error("Translations request failed with status code: ".concat(response.status));
  }
  const data = await response.json();
  if (data.warning) {
    // Store the warning to be displayed after core system setup
    window.__i18nWarning = data.warning;
  }
  init(data.translations);
}