"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.traceUiSettings = void 0;
var _i18n = require("@osd/i18n");
var _configSchema = require("@osd/config-schema");
var _common = require("../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const traceUiSettings = exports.traceUiSettings = {
  [_common.DEFAULT_TRACE_COLUMNS_SETTING]: {
    name: _i18n.i18n.translate('explore.advancedSettings.defaultTraceColumnsTitle', {
      defaultMessage: 'Default trace columns'
    }),
    value: ['spanId', 'status.code', 'attributes.http.status_code', 'attributes.service.name', 'resource.attributes.service.name', 'serviceName', 'name', 'durationNano', 'durationInNanos'],
    description: _i18n.i18n.translate('explore.advancedSettings.defaultTraceColumnsText', {
      defaultMessage: 'Experimental: Columns displayed by default in the Explore traces tab'
    }),
    category: ['explore'],
    schema: _configSchema.schema.arrayOf(_configSchema.schema.string())
  }
};