/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.time.Clock;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.common.exception.ValidationException;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.function.ExecutorFunction;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.ConfigValidationIssue;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.ValidationAspect;
import org.opensearch.timeseries.model.ValidationIssueType;
import org.opensearch.timeseries.rest.handler.Processor;
import org.opensearch.timeseries.transport.ValidateConfigRequest;
import org.opensearch.timeseries.transport.ValidateConfigResponse;
import org.opensearch.timeseries.util.ParseUtils;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public abstract class BaseValidateConfigTransportAction<IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>>
extends HandledTransportAction<ValidateConfigRequest, ValidateConfigResponse> {
    public static final Logger logger = LogManager.getLogger(BaseValidateConfigTransportAction.class);
    protected final Client client;
    protected final SecurityClientUtil clientUtil;
    protected final ClusterService clusterService;
    protected final NamedXContentRegistry xContentRegistry;
    protected final IndexManagementType indexManagement;
    protected final SearchFeatureDao searchFeatureDao;
    protected volatile Boolean filterByEnabled;
    protected Clock clock;
    protected Settings settings;
    protected ValidationAspect validationAspect;

    public BaseValidateConfigTransportAction(String actionName, Client client, SecurityClientUtil clientUtil, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Settings settings, IndexManagementType indexManagement, ActionFilters actionFilters, TransportService transportService, SearchFeatureDao searchFeatureDao, Setting<Boolean> filterByBackendRoleSetting, ValidationAspect validationAspect) {
        super(actionName, transportService, actionFilters, ValidateConfigRequest::new);
        this.client = client;
        this.clientUtil = clientUtil;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.indexManagement = indexManagement;
        this.filterByEnabled = (Boolean)filterByBackendRoleSetting.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(filterByBackendRoleSetting, it -> {
            this.filterByEnabled = it;
        });
        this.searchFeatureDao = searchFeatureDao;
        this.clock = Clock.systemUTC();
        this.settings = settings;
        this.validationAspect = validationAspect;
    }

    protected void doExecute(Task task, ValidateConfigRequest request, ActionListener<ValidateConfigResponse> listener) {
        User user = ParseUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ParseUtils.verifyResourceAccessAndProcessRequest(() -> this.validateExecute(request, user, context, listener), () -> this.resolveUserAndExecute(user, listener, () -> this.validateExecute(request, user, context, listener)));
        }
        catch (Exception e) {
            logger.error((Object)e);
            listener.onFailure(e);
        }
    }

    public void resolveUserAndExecute(User requestedUser, ActionListener<ValidateConfigResponse> listener, ExecutorFunction function) {
        try {
            String error;
            if (this.filterByEnabled.booleanValue() && (error = ParseUtils.checkFilterByBackendRoles(requestedUser)) != null) {
                listener.onFailure((Exception)new TimeSeriesException(error));
                return;
            }
            function.execute();
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    protected void checkIndicesAndExecute(List<String> indices, ExecutorFunction function, ActionListener<ValidateConfigResponse> listener) {
        SearchRequest searchRequest = new SearchRequest().indices(indices.toArray(new String[0])).source(new SearchSourceBuilder().size(1).query((QueryBuilder)QueryBuilders.matchAllQuery()));
        this.client.search(searchRequest, ActionListener.wrap(r -> function.execute(), e -> {
            if (e instanceof IndexNotFoundException) {
                ConfigValidationIssue issue = this.parseValidationException(new ValidationException("index does not exist", ValidationIssueType.INDICES, this.validationAspect));
                listener.onResponse((Object)new ValidateConfigResponse(issue));
                return;
            }
            logger.error(e);
            listener.onFailure(e);
        }));
    }

    protected Map<String, String> getFeatureSubIssuesFromErrorMessage(String errorMessage) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] subIssueMessagesSuffix = errorMessage.split(", ");
        for (int i = 0; i < subIssueMessagesSuffix.length; ++i) {
            String[] subIssueMsgs = subIssueMessagesSuffix[i].split(": ");
            result.put(subIssueMsgs[1], subIssueMsgs[0]);
        }
        return result;
    }

    public ConfigValidationIssue parseValidationException(ValidationException exception) {
        String originalErrorMessage = exception.getMessage();
        String errorMessage = "";
        Map<String, String> subIssues = null;
        IntervalTimeConfiguration intervalSuggestion = exception.getIntervalSuggestion();
        switch (exception.getType()) {
            case FEATURE_ATTRIBUTES: {
                int firstLeftBracketIndex = originalErrorMessage.indexOf("[");
                int lastRightBracketIndex = originalErrorMessage.lastIndexOf("]");
                if (firstLeftBracketIndex != -1) {
                    errorMessage = originalErrorMessage.substring(firstLeftBracketIndex + 1, lastRightBracketIndex);
                    subIssues = this.getFeatureSubIssuesFromErrorMessage(errorMessage);
                    break;
                }
                errorMessage = originalErrorMessage;
                break;
            }
            case NAME: 
            case CATEGORY: 
            case DETECTION_INTERVAL: 
            case FILTER_QUERY: 
            case TIMEFIELD_FIELD: 
            case SHINGLE_SIZE_FIELD: 
            case WINDOW_DELAY: 
            case RESULT_INDEX: 
            case GENERAL_SETTINGS: 
            case AGGREGATION: 
            case TIMEOUT: 
            case INDICES: 
            case FORECAST_INTERVAL: 
            case IMPUTATION: 
            case HORIZON_SIZE: 
            case RECENCY_EMPHASIS: {
                errorMessage = originalErrorMessage;
            }
        }
        return new ConfigValidationIssue(exception.getAspect(), exception.getType(), errorMessage, subIssues, intervalSuggestion);
    }

    public void validateExecute(ValidateConfigRequest request, User user, ThreadContext.StoredContext storedContext, ActionListener<ValidateConfigResponse> listener) {
        storedContext.restore();
        Config config = request.getConfig();
        ActionListener validateListener = ActionListener.wrap(response -> listener.onResponse((Object)new ValidateConfigResponse((ConfigValidationIssue)null)), exception -> {
            if (exception instanceof ValidationException) {
                ConfigValidationIssue issue = this.parseValidationException((ValidationException)exception);
                listener.onResponse((Object)new ValidateConfigResponse(issue));
                return;
            }
            logger.error(exception);
            listener.onFailure(exception);
        });
        this.checkIndicesAndExecute(config.getIndices(), () -> {
            try {
                this.createProcessor(config, request, user).start((ActionListener<ValidateConfigResponse>)validateListener);
            }
            catch (Exception exception) {
                String errorMessage = String.format(Locale.ROOT, "Unknown exception caught while validating config %s", request.getConfig());
                logger.error(errorMessage, (Throwable)exception);
                listener.onFailure(exception);
            }
        }, listener);
    }

    protected abstract Processor<ValidateConfigResponse> createProcessor(Config var1, ValidateConfigRequest var2, User var3);
}

