/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.javaagent;

import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StackCallerProtectionDomainChainExtractor
implements Function<Stream<StackWalker.StackFrame>, Collection<ProtectionDomain>> {
    public static final StackCallerProtectionDomainChainExtractor INSTANCE = new StackCallerProtectionDomainChainExtractor();
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private static final Set<String> ACCESS_CONTROLLER_CLASSES = Set.of("java.security.AccessController", "org.opensearch.secure_sm.AccessController");
    private static final Set<String> DO_PRIVILEGED_METHODS = Set.of("doPrivileged", "doPrivilegedChecked");

    private StackCallerProtectionDomainChainExtractor() {
    }

    @Override
    public Collection<ProtectionDomain> apply(Stream<StackWalker.StackFrame> frames) {
        return frames.takeWhile(frame -> !ACCESS_CONTROLLER_CLASSES.contains(frame.getClassName()) || !DO_PRIVILEGED_METHODS.contains(frame.getMethodName())).map(StackWalker.StackFrame::getDeclaringClass).map(Class::getProtectionDomain).filter(pd -> pd.getCodeSource() != null).collect(Collectors.toSet());
    }
}

