/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.opensearch.rule.MatchLabel;
import org.opensearch.rule.storage.AttributeValueStore;

public class DefaultAttributeValueStore<K extends String, V>
implements AttributeValueStore<K, V> {
    private final PatriciaTrie<Set<V>> trie;
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.ReadLock readLock = lock.readLock();
    private static final ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();

    public DefaultAttributeValueStore() {
        this(new PatriciaTrie());
    }

    public DefaultAttributeValueStore(PatriciaTrie<Set<V>> trie) {
        this.trie = trie;
    }

    @Override
    public void put(K key, V value) {
        writeLock.lock();
        try {
            ((Set)this.trie.computeIfAbsent(key, k -> new HashSet())).add(value);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void remove(K key, V value) {
        writeLock.lock();
        try {
            this.trie.computeIfPresent(key, (k, values) -> {
                values.remove(value);
                return values.isEmpty() ? null : values;
            });
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void remove(K key) {
        throw new UnsupportedOperationException("This remove(K key) function is not supported within DefaultAttributeValueStore.");
    }

    @Override
    public Optional<V> get(K key) {
        throw new UnsupportedOperationException("This get(K key) function is not supported within DefaultAttributeValueStore.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<V> getExactMatch(K key) {
        readLock.lock();
        try {
            HashSet results = new HashSet();
            results.addAll((Collection)this.trie.getOrDefault(key, Collections.emptySet()));
            results.addAll((Collection)this.trie.getOrDefault((Object)"", Collections.emptySet()));
            HashSet hashSet = results;
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MatchLabel<V>> getMatches(String key) {
        readLock.lock();
        try {
            ArrayList<MatchLabel<V>> results = new ArrayList<MatchLabel<V>>();
            StringBuilder prefixBuilder = new StringBuilder(key);
            for (int i = key.length(); i >= 0; --i) {
                String prefix = prefixBuilder.toString();
                Set value = (Set)this.trie.get((Object)prefix);
                if (value != null && !value.isEmpty()) {
                    float matchScore = (float)prefixBuilder.length() / (float)key.length();
                    for (Object label : value) {
                        results.add(new MatchLabel(label, matchScore));
                    }
                }
                if (prefixBuilder.isEmpty()) continue;
                prefixBuilder.deleteCharAt(prefixBuilder.length() - 1);
            }
            ArrayList<MatchLabel<V>> arrayList = results;
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void clear() {
        writeLock.lock();
        try {
            this.trie.clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public int size() {
        return this.trie.size();
    }
}

