/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIaqm;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4Ctoh;
import oracle.jdbc.internal.OracleConnection;

final class T4CTTIosaga
extends T4CTTIfun {
    T4CTTIaqm aqm;
    T4Ctoh toh;
    private String sender;
    private byte[] senderBytes = null;
    private String recipient;
    private byte[] recipientBytes = null;
    private String coordinator;
    private byte[] coordinatorBytes = null;
    private String currentUser;
    private byte[] currentUserBytes = null;
    private String spareText;
    private byte[] spareTextBytes = null;
    private int opcode;
    private int flags = 0;
    private int timeout = 86400;
    private int sagaVersion = 1;
    private byte[] sagaId;
    private int spareNumeric = 0;
    private int version = 1;
    private byte[] response = null;

    T4CTTIosaga(T4CConnection _connection) {
        super(_connection, (byte)3);
        this.setFunCode((short)195);
        this.toh = new T4Ctoh(_connection);
        this.aqm = new T4CTTIaqm(this.connection, this.toh);
    }

    public byte[] doOSAGA(int opcode, int flags, int timeout, int sagaVersion, byte[] sagaId, String sender, String recipient, String coordinator, String currentUser, int spareNumeric, String spareText) throws SQLException, IOException {
        this.opcode = opcode;
        this.flags = flags;
        this.timeout = timeout;
        this.sagaId = sagaId;
        this.sender = sender;
        this.recipient = recipient;
        this.coordinator = coordinator;
        this.currentUser = currentUser;
        this.spareNumeric = spareNumeric;
        this.spareText = spareText;
        this.senderBytes = (byte[])(sender != null && sender.length() != 0 ? this.meg.conv.StringToCharBytes(sender) : null);
        this.recipientBytes = (byte[])(recipient != null && recipient.length() != 0 ? this.meg.conv.StringToCharBytes(recipient) : null);
        this.coordinatorBytes = (byte[])(coordinator != null && coordinator.length() != 0 ? this.meg.conv.StringToCharBytes(coordinator) : null);
        this.currentUserBytes = (byte[])(currentUser != null && currentUser.length() != 0 ? this.meg.conv.StringToCharBytes(currentUser) : null);
        this.spareTextBytes = (byte[])(spareText != null && spareText.length() != 0 ? this.meg.conv.StringToCharBytes(spareText) : null);
        this.doRPC();
        return this.response;
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalUB4(this.opcode);
        this.meg.marshalUB4(this.flags);
        this.meg.marshalUB4(this.timeout);
        this.meg.marshalUB4(this.sagaVersion);
        boolean sendSagaId = false;
        if (this.sagaId != null && this.sagaId.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.sagaId.length);
            sendSagaId = true;
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        if (this.senderBytes != null && this.senderBytes.length != 0) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.senderBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        if (this.recipientBytes != null && this.recipientBytes.length != 0) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.recipientBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        if (this.coordinatorBytes != null && this.coordinatorBytes.length != 0) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.coordinatorBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        if (this.currentUserBytes != null && this.currentUserBytes.length != 0) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.currentUserBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalUB4(this.spareNumeric);
        if (this.spareTextBytes != null && this.spareTextBytes.length != 0) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.spareTextBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalUB4(this.version);
        if (sendSagaId) {
            this.meg.marshalB1Array(this.sagaId);
        }
        if (this.senderBytes != null && this.senderBytes.length != 0) {
            this.meg.marshalCHR(this.senderBytes);
        }
        if (this.recipientBytes != null && this.recipientBytes.length != 0) {
            this.meg.marshalCHR(this.recipientBytes);
        }
        if (this.coordinatorBytes != null && this.coordinatorBytes.length != 0) {
            this.meg.marshalCHR(this.coordinatorBytes);
        }
        if (this.currentUserBytes != null && this.currentUserBytes.length != 0) {
            this.meg.marshalCHR(this.currentUserBytes);
        }
        if (this.spareTextBytes != null && this.spareTextBytes.length != 0) {
            this.meg.marshalCHR(this.spareTextBytes);
        }
    }

    @Override
    void readRPA() throws SQLException, IOException {
        int returnLen = (int)this.meg.unmarshalUB4();
        if (returnLen > 0) {
            this.response = this.meg.unmarshalNBytes(returnLen);
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

