/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;

public class RoundButton
extends JButton {
    private BufferedImage mForegroundImage;
    private BufferedImage mBackgroundImage;
    private float mRotate = 0.0f;

    public RoundButton() {
        this.setModel(new DefaultButtonModel());
        this.init(null, null);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setBackground(Color.BLACK);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setFocusable(false);
        this.setAlignmentY(0.0f);
        this.setUI(new RoundImageButtonUI());
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getUI().getPreferredSize(this);
    }

    public void setForegroundIcon(BufferedImage pForegroundImage) {
        this.mForegroundImage = pForegroundImage;
    }

    public void setBackgroundIcon(BufferedImage pBackgroundImage) {
        this.mBackgroundImage = pBackgroundImage;
    }

    public int getZoomedCircleRadius() {
        return 40;
    }

    public void dispose() {
    }

    public void setRotate(float pCachedRotate) {
        this.mRotate = pCachedRotate;
    }

    class RoundImageButtonUI
    extends BasicButtonUI {
        protected Shape shape;
        protected Shape base;

        RoundImageButtonUI() {
        }

        @Override
        protected void installDefaults(AbstractButton b) {
            super.installDefaults(b);
            this.clearTextShiftOffset();
            this.defaultTextShiftOffset = 0;
            b.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            b.setContentAreaFilled(false);
            b.setFocusPainted(false);
            b.setOpaque(false);
            b.setBackground(Color.BLACK);
            b.setAlignmentY(0.0f);
            this.initShape(b);
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            Graphics2D g2 = (Graphics2D)g.create();
            this.initShape(c);
            Rectangle bounds = this.shape.getBounds();
            int width = (int)bounds.getMaxX();
            int height = (int)bounds.getMaxY();
            g2.setColor(RoundButton.this.getBackground());
            g2.fillOval(bounds.x, bounds.y, width, height);
            if (RoundButton.this.mBackgroundImage != null) {
                g2.drawImage(RoundButton.this.mBackgroundImage, bounds.x, bounds.y, width, height, 0, 0, RoundButton.this.mBackgroundImage.getWidth(), RoundButton.this.mBackgroundImage.getHeight(), null);
            }
            if (RoundButton.this.mForegroundImage != null) {
                g2.rotate(Math.toRadians(RoundButton.this.mRotate), bounds.getCenterX(), bounds.getCenterY());
                g2.drawImage(RoundButton.this.mForegroundImage, bounds.x, bounds.y, width, height, 0, 0, RoundButton.this.mForegroundImage.getWidth(), RoundButton.this.mForegroundImage.getHeight(), null);
            }
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            JButton b = (JButton)c;
            Insets i = b.getInsets();
            int iw = RoundButton.this.getZoomedCircleRadius();
            return new Dimension(iw + i.right + i.left, iw + i.top + i.bottom);
        }

        private void initShape(JComponent c) {
            if (!c.getBounds().equals(this.base)) {
                Dimension s = c.getPreferredSize();
                this.base = c.getBounds();
                this.shape = new Ellipse2D.Float(0.0f, 0.0f, s.width - 1, s.height - 1);
            }
        }
    }
}

