/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.routing;

import net.osmand.Location;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.data.LocationPoint;
import net.osmand.data.PointDescription;
import net.sourceforge.offroad.OsmWindow;

public class AlarmInfo
implements LocationPoint {
    private AlarmInfoType type;
    protected final int locationIndex;
    private int intValue;
    private double latitude;
    private double longitude;

    public AlarmInfo(AlarmInfoType type, int locationIndex) {
        this.type = type;
        this.locationIndex = locationIndex;
    }

    public AlarmInfoType getType() {
        return this.type;
    }

    @Override
    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public double getLongitude() {
        return this.longitude;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public int getLocationIndex() {
        return this.locationIndex;
    }

    public void setIntValue(int intValue) {
        this.intValue = intValue;
    }

    public static AlarmInfo createSpeedLimit(int speed, Location loc) {
        AlarmInfo info = new AlarmInfo(AlarmInfoType.SPEED_LIMIT, 0);
        info.setLatLon(loc.getLatitude(), loc.getLongitude());
        info.setIntValue(speed);
        return info;
    }

    public void setLatLon(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public static AlarmInfo createAlarmInfo(BinaryMapRouteReaderAdapter.RouteTypeRule ruleType, int locInd, Location loc) {
        AlarmInfo alarmInfo = null;
        if ("highway".equals(ruleType.getTag())) {
            if ("speed_camera".equals(ruleType.getValue())) {
                alarmInfo = new AlarmInfo(AlarmInfoType.SPEED_CAMERA, locInd);
            } else if ("stop".equals(ruleType.getValue())) {
                alarmInfo = new AlarmInfo(AlarmInfoType.STOP, locInd);
            }
        } else if ("barrier".equals(ruleType.getTag())) {
            if ("toll_booth".equals(ruleType.getValue())) {
                alarmInfo = new AlarmInfo(AlarmInfoType.TOLL_BOOTH, locInd);
            } else if ("border_control".equals(ruleType.getValue())) {
                alarmInfo = new AlarmInfo(AlarmInfoType.BORDER_CONTROL, locInd);
            }
        } else if ("traffic_calming".equals(ruleType.getTag())) {
            alarmInfo = new AlarmInfo(AlarmInfoType.TRAFFIC_CALMING, locInd);
        } else if ("hazard".equals(ruleType.getTag())) {
            alarmInfo = new AlarmInfo(AlarmInfoType.HAZARD, locInd);
        } else if ("railway".equals(ruleType.getTag()) && "level_crossing".equals(ruleType.getValue())) {
            alarmInfo = new AlarmInfo(AlarmInfoType.RAILWAY, locInd);
        } else if ("crossing".equals(ruleType.getTag()) && "uncontrolled".equals(ruleType.getValue())) {
            alarmInfo = new AlarmInfo(AlarmInfoType.PEDESTRIAN, locInd);
        }
        if (alarmInfo != null) {
            alarmInfo.setLatLon(loc.getLatitude(), loc.getLongitude());
        }
        return alarmInfo;
    }

    public int updateDistanceAndGetPriority(float time, float distance) {
        if (distance > 1500.0f) {
            return Integer.MAX_VALUE;
        }
        if (time < 6.0f || distance < 75.0f || this.type == AlarmInfoType.SPEED_LIMIT) {
            return this.type.getPriority();
        }
        if (this.type == AlarmInfoType.SPEED_CAMERA && (time < 15.0f || distance < 150.0f)) {
            return this.type.getPriority();
        }
        if (time < 7.0f || distance < 100.0f) {
            return this.type.getPriority() + AlarmInfoType.MAXIMUM.getPriority();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public PointDescription getPointDescription(OsmWindow ctx) {
        return new PointDescription("alarm", this.type.getVisualName(ctx));
    }

    @Override
    public int getColor() {
        return 0;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    public static enum AlarmInfoType {
        SPEED_CAMERA(1, 72),
        SPEED_LIMIT(2, 67),
        BORDER_CONTROL(3, 68),
        RAILWAY(4, 1615),
        TRAFFIC_CALMING(5, 71),
        TOLL_BOOTH(6, 69),
        STOP(7, 70),
        PEDESTRIAN(8, 1616),
        HAZARD(9, 1840),
        MAXIMUM(10, 73);

        private int priority;
        private int string;

        private AlarmInfoType(int p, int string3) {
            this.priority = p;
            this.string = string3;
        }

        public int getPriority() {
            return this.priority;
        }

        public String getVisualName(OsmWindow ctx) {
            return ctx.getString(this.string);
        }
    }
}

