from typing import Optional
from datetime import datetime

from pydantic import BaseModel
from sqlalchemy import Column, Integer, String, func, TIMESTAMP

from ..base import Base


class DqSummary(Base):
    __tablename__ = 'dq_summary'
    id = Column(Integer, primary_key=True, index=True, autoincrement=False)
    created_at = Column(TIMESTAMP(timezone=True), server_default=func.now())
    updated_at = Column(TIMESTAMP(timezone=True), onupdate=func.now())
    summary = Column(String)


class DqSummaryInDB(BaseModel):
    summary: str
    created_at: datetime
    updated_at: Optional[datetime]

    class Config:
        from_attributes = True


class DqSummaryCreate(BaseModel):
    summary: str

    class Config:
        from_attributes = True
