/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.dynamic;

import java.util.Locale;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.results.internal.DomainResultCreationStateImpl;
import org.hibernate.query.results.internal.ResultSetMappingSqlSelection;
import org.hibernate.query.results.internal.ResultsHelper;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilder;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class DynamicResultBuilderAttribute
implements DynamicResultBuilder,
NativeQuery.ReturnProperty {
    private final BasicAttributeMapping attributeMapping;
    private final String columnAlias;
    private final String entityName;
    private final String attributePath;

    public DynamicResultBuilderAttribute(SingularAttributeMapping attributeMapping, String columnAlias, String entityName, String attributePath) {
        boolean allowable = attributeMapping instanceof BasicAttributeMapping;
        if (!allowable) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Specified attribute [%s.%s] must be basic: %s", entityName, attributePath, attributeMapping));
        }
        this.attributeMapping = (BasicAttributeMapping)attributeMapping;
        this.columnAlias = columnAlias;
        this.entityName = entityName;
        this.attributePath = attributePath;
    }

    @Override
    public Class<?> getJavaType() {
        return this.attributeMapping.getExpressibleJavaType().getJavaTypeClass();
    }

    @Override
    public NativeQuery.ReturnProperty addColumnAlias(String columnAlias) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DynamicResultBuilderAttribute cacheKeyInstance() {
        return this;
    }

    @Override
    public DomainResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, DomainResultCreationState domainResultCreationState) {
        SqlSelection sqlSelection = this.sqlSelection(jdbcResultsMetadata, domainResultCreationState, ResultsHelper.impl(domainResultCreationState));
        return new BasicResult(sqlSelection.getValuesArrayPosition(), this.columnAlias, this.attributeMapping.getJdbcMapping(), null, false, !sqlSelection.isVirtual());
    }

    private SqlSelection sqlSelection(JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState, DomainResultCreationStateImpl domainResultCreationStateImpl) {
        return domainResultCreationStateImpl.resolveSqlSelection(domainResultCreationStateImpl.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(this.columnAlias), processingState -> {
            int jdbcPosition = jdbcResultsMetadata.resolveColumnPosition(this.columnAlias);
            int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
            return new ResultSetMappingSqlSelection(valuesArrayPosition, this.attributeMapping);
        }), this.attributeMapping.getJdbcMapping().getJdbcJavaType(), null, domainResultCreationState.getSqlAstCreationState().getCreationContext().getTypeConfiguration());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicResultBuilderAttribute that = (DynamicResultBuilderAttribute)o;
        return this.attributeMapping.equals(that.attributeMapping) && this.columnAlias.equals(that.columnAlias) && this.entityName.equals(that.entityName) && this.attributePath.equals(that.attributePath);
    }

    public int hashCode() {
        int result = this.attributeMapping.hashCode();
        result = 31 * result + this.columnAlias.hashCode();
        result = 31 * result + this.entityName.hashCode();
        result = 31 * result + this.attributePath.hashCode();
        return result;
    }
}

