/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import twitter4j.APIResourceBase;
import twitter4j.Authorization;
import twitter4j.HttpClient;
import twitter4j.HttpParameter;
import twitter4j.ObjectFactory;
import twitter4j.RateLimitStatusEvent;
import twitter4j.TwitterException;
import twitter4j.v1.GeoQuery;
import twitter4j.v1.Place;
import twitter4j.v1.PlacesGeoResources;
import twitter4j.v1.ResponseList;

class PlacesGeoResourcesImpl
extends APIResourceBase
implements PlacesGeoResources {
    PlacesGeoResourcesImpl(HttpClient http, ObjectFactory factory, String restBaseURL, Authorization auth, boolean mbeanEnabled, HttpParameter[] IMPLICIT_PARAMS, String IMPLICIT_PARAMS_STR, List<Consumer<RateLimitStatusEvent>> rateLimitStatusListeners, List<Consumer<RateLimitStatusEvent>> rateLimitReachedListeners) {
        super(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
    }

    @Override
    public Place getGeoDetails(String placeId) throws TwitterException {
        return this.factory.createPlace(this.get(this.restBaseURL + "geo/id/" + placeId + ".json"));
    }

    @Override
    public ResponseList<Place> reverseGeoCode(GeoQuery query) throws TwitterException {
        try {
            return this.factory.createPlaceList(this.get(this.restBaseURL + "geo/reverse_geocode.json", PlacesGeoResourcesImpl.asHttpParameterArray(query)));
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return this.factory.createEmptyResponseList();
            }
            throw te;
        }
    }

    @Override
    public ResponseList<Place> searchPlaces(GeoQuery query) throws TwitterException {
        return this.factory.createPlaceList(this.get(this.restBaseURL + "geo/search.json", PlacesGeoResourcesImpl.asHttpParameterArray(query)));
    }

    private static HttpParameter[] asHttpParameterArray(GeoQuery query) {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (query.location != null) {
            PlacesGeoResourcesImpl.appendParameter("lat", query.location.latitude, params);
            PlacesGeoResourcesImpl.appendParameter("long", query.location.longitude, params);
        }
        if (query.ip != null) {
            PlacesGeoResourcesImpl.appendParameter("ip", query.ip, params);
        }
        PlacesGeoResourcesImpl.appendParameter("accuracy", query.accuracy, params);
        PlacesGeoResourcesImpl.appendParameter("query", query.query, params);
        PlacesGeoResourcesImpl.appendParameter("granularity", query.granularity, params);
        PlacesGeoResourcesImpl.appendParameter("max_results", query.maxResults, params);
        HttpParameter[] paramArray = new HttpParameter[params.size()];
        return params.toArray(paramArray);
    }

    private static void appendParameter(String name, String value, List<HttpParameter> params) {
        if (value != null) {
            params.add(new HttpParameter(name, value));
        }
    }

    private static void appendParameter(String name, int value, List<HttpParameter> params) {
        if (0 < value) {
            params.add(new HttpParameter(name, String.valueOf(value)));
        }
    }

    private static void appendParameter(String name, double value, List<HttpParameter> params) {
        params.add(new HttpParameter(name, String.valueOf(value)));
    }
}

