/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot;

import jakarta.persistence.criteria.Nulls;
import java.util.function.Supplier;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EntityNameResolver;
import org.hibernate.Incubating;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.annotations.CacheLayout;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.cache.spi.TimestampsCacheFactory;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.context.spi.TenantSchemaMapper;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.type.format.FormatMapper;

public interface SessionFactoryBuilder {
    public SessionFactoryBuilder applyValidatorFactory(Object var1);

    public SessionFactoryBuilder applyBeanManager(Object var1);

    public SessionFactoryBuilder applyName(String var1);

    public SessionFactoryBuilder applyNameAsJndiName(boolean var1);

    public SessionFactoryBuilder applyAutoClosing(boolean var1);

    public SessionFactoryBuilder applyAutoFlushing(boolean var1);

    public SessionFactoryBuilder applyStatisticsSupport(boolean var1);

    public SessionFactoryBuilder applyInterceptor(Interceptor var1);

    public SessionFactoryBuilder applyStatelessInterceptor(Class<? extends Interceptor> var1);

    public SessionFactoryBuilder applyStatelessInterceptor(Supplier<? extends Interceptor> var1);

    public SessionFactoryBuilder applyStatementInspector(StatementInspector var1);

    public SessionFactoryBuilder addSessionFactoryObservers(SessionFactoryObserver ... var1);

    public SessionFactoryBuilder applyCustomEntityDirtinessStrategy(CustomEntityDirtinessStrategy var1);

    public SessionFactoryBuilder addEntityNameResolver(EntityNameResolver ... var1);

    public SessionFactoryBuilder applyEntityNotFoundDelegate(EntityNotFoundDelegate var1);

    public SessionFactoryBuilder applyIdentifierRollbackSupport(boolean var1);

    public SessionFactoryBuilder applyNullabilityChecking(boolean var1);

    public SessionFactoryBuilder applyLazyInitializationOutsideTransaction(boolean var1);

    @Deprecated(since="7.0", forRemoval=true)
    public SessionFactoryBuilder applyTempTableDdlTransactionHandling(TempTableDdlTransactionHandling var1);

    public SessionFactoryBuilder applyDelayedEntityLoaderCreations(boolean var1);

    public SessionFactoryBuilder applyDefaultBatchFetchSize(int var1);

    public SessionFactoryBuilder applyMaximumFetchDepth(int var1);

    public SessionFactoryBuilder applySubselectFetchEnabled(boolean var1);

    public SessionFactoryBuilder applyDefaultNullPrecedence(Nulls var1);

    public SessionFactoryBuilder applyOrderingOfInserts(boolean var1);

    public SessionFactoryBuilder applyOrderingOfUpdates(boolean var1);

    public SessionFactoryBuilder applyMultiTenancy(boolean var1);

    public SessionFactoryBuilder applyCurrentTenantIdentifierResolver(CurrentTenantIdentifierResolver<?> var1);

    public SessionFactoryBuilder applyTenantSchemaMapper(TenantSchemaMapper<?> var1);

    public SessionFactoryBuilder applyJtaTrackingByThread(boolean var1);

    public SessionFactoryBuilder applyPreferUserTransactions(boolean var1);

    public SessionFactoryBuilder applyNamedQueryCheckingOnStartup(boolean var1);

    public SessionFactoryBuilder applySecondLevelCacheSupport(boolean var1);

    public SessionFactoryBuilder applyQueryCacheSupport(boolean var1);

    @Incubating
    public SessionFactoryBuilder applyQueryCacheLayout(CacheLayout var1);

    public SessionFactoryBuilder applyTimestampsCacheFactory(TimestampsCacheFactory var1);

    public SessionFactoryBuilder applyCacheRegionPrefix(String var1);

    public SessionFactoryBuilder applyMinimalPutsForCaching(boolean var1);

    public SessionFactoryBuilder applyStructuredCacheEntries(boolean var1);

    public SessionFactoryBuilder applyDirectReferenceCaching(boolean var1);

    public SessionFactoryBuilder applyAutomaticEvictionOfCollectionCaches(boolean var1);

    public SessionFactoryBuilder applyJdbcBatchSize(int var1);

    public SessionFactoryBuilder applyScrollableResultsSupport(boolean var1);

    public SessionFactoryBuilder applyGetGeneratedKeysSupport(boolean var1);

    public SessionFactoryBuilder applyJdbcFetchSize(int var1);

    public SessionFactoryBuilder applyConnectionHandlingMode(PhysicalConnectionHandlingMode var1);

    public SessionFactoryBuilder applyConnectionProviderDisablesAutoCommit(boolean var1);

    public SessionFactoryBuilder applySqlComments(boolean var1);

    public SessionFactoryBuilder applySqlFunction(String var1, SqmFunctionDescriptor var2);

    public SessionFactoryBuilder applyCollectionsInDefaultFetchGroup(boolean var1);

    public SessionFactoryBuilder allowOutOfTransactionUpdateOperations(boolean var1);

    @Deprecated(since="7.0", forRemoval=true)
    public SessionFactoryBuilder enableReleaseResourcesOnCloseEnabled(boolean var1);

    public SessionFactoryBuilder enableJpaQueryCompliance(boolean var1);

    public SessionFactoryBuilder enableJpaOrderByMappingCompliance(boolean var1);

    public SessionFactoryBuilder enableJpaTransactionCompliance(boolean var1);

    @Deprecated(since="7.0", forRemoval=true)
    public SessionFactoryBuilder enableJpaCascadeCompliance(boolean var1);

    public SessionFactoryBuilder enableJpaClosedCompliance(boolean var1);

    @Incubating
    public SessionFactoryBuilder applyJsonFormatMapper(FormatMapper var1);

    @Incubating
    public SessionFactoryBuilder applyXmlFormatMapper(FormatMapper var1);

    public SessionFactory build();
}

