/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.AbstractResponseHandler;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.EnvUtil;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.connections.httpclient.HttpClientBuilder;
import org.keycloak.connections.httpclient.HttpClientFactory;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.connections.httpclient.ProxyMappings;
import org.keycloak.connections.httpclient.SafeBasicResponseHandler;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.truststore.TruststoreProvider;
import org.keycloak.utils.StringUtil;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private static final Logger logger = Logger.getLogger(DefaultHttpClientFactory.class);
    private static final String configScope = "keycloak.connectionsHttpClient.default.";
    private static final String HTTPS_PROXY = "https_proxy";
    private static final String HTTP_PROXY = "http_proxy";
    private static final String NO_PROXY = "no_proxy";
    public static final String MAX_CONSUMED_RESPONSE_SIZE = "max-consumed-response-size";
    private volatile CloseableHttpClient httpClient;
    private Config.Scope config;
    private BasicResponseHandler stringResponseHandler;
    private final InputStreamResponseHandler inputStreamResponseHandler = new InputStreamResponseHandler();
    private long maxConsumedResponseSize;

    public HttpClientProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new HttpClientProvider(){

            public CloseableHttpClient getHttpClient() {
                return DefaultHttpClientFactory.this.httpClient;
            }

            public void close() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive exception aggregation
             */
            public int postText(String uri, String text) throws IOException {
                HttpPost request = new HttpPost(uri);
                request.setEntity(EntityBuilder.create().setText(text).setContentType(ContentType.TEXT_PLAIN).build());
                try (CloseableHttpResponse response = DefaultHttpClientFactory.this.httpClient.execute((HttpUriRequest)request);){
                    int n;
                    try {
                        n = response.getStatusLine().getStatusCode();
                    }
                    catch (Throwable throwable) {
                        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                        throw throwable;
                    }
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                    return n;
                }
                catch (Throwable t) {
                    logger.warn((Object)t.getMessage(), t);
                    throw t;
                }
            }

            public String getString(String uri) throws IOException {
                HttpGet request = new HttpGet(uri);
                CloseableHttpResponse response = DefaultHttpClientFactory.this.httpClient.execute((HttpUriRequest)request);
                String body = DefaultHttpClientFactory.this.stringResponseHandler.handleResponse((HttpResponse)response);
                if (body == null) {
                    throw new IOException("No content returned from HTTP call");
                }
                return body;
            }

            public InputStream getInputStream(String uri) throws IOException {
                HttpGet request = new HttpGet(uri);
                CloseableHttpResponse response = DefaultHttpClientFactory.this.httpClient.execute((HttpUriRequest)request);
                InputStream body = DefaultHttpClientFactory.this.inputStreamResponseHandler.handleResponse((HttpResponse)response);
                if (body == null) {
                    throw new IOException("No content returned from HTTP call");
                }
                return body;
            }

            public long getMaxConsumedResponseSize() {
                return DefaultHttpClientFactory.this.maxConsumedResponseSize;
            }
        };
    }

    public void close() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getId() {
        return "default";
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.httpClient == null) {
            DefaultHttpClientFactory defaultHttpClientFactory = this;
            synchronized (defaultHttpClientFactory) {
                if (this.httpClient == null) {
                    boolean disableTruststoreProvider;
                    long socketTimeout = this.config.getLong("socket-timeout-millis", Long.valueOf(5000L));
                    long establishConnectionTimeout = this.config.getLong("establish-connection-timeout-millis", Long.valueOf(-1L));
                    long connectionRequestTimeout = this.config.getLong("connection-request-timeout-millis", Long.valueOf(HttpClientBuilder.DEFAULT_CONNECTION_REQUEST_TIMEOUT_MILLIS));
                    int maxPooledPerRoute = this.config.getInt("max-pooled-per-route", Integer.valueOf(64));
                    int connectionPoolSize = this.config.getInt("connection-pool-size", Integer.valueOf(128));
                    long connectionTTL = this.config.getLong("connection-ttl-millis", Long.valueOf(-1L));
                    long maxConnectionIdleTime = this.config.getLong("max-connection-idle-time-millis", Long.valueOf(900000L));
                    boolean disableCookies = this.config.getBoolean("disable-cookies", Boolean.valueOf(true));
                    String clientKeystore = this.config.get("client-keystore");
                    String clientKeystorePassword = this.config.get("client-keystore-password");
                    String clientPrivateKeyPassword = this.config.get("client-key-password");
                    boolean disableTrustManager = this.config.getBoolean("disable-trust-manager", Boolean.valueOf(false));
                    boolean expectContinueEnabled = this.getBooleanConfigWithSysPropFallback("expect-continue-enabled", false);
                    boolean reuseConnections = this.getBooleanConfigWithSysPropFallback("reuse-connections", true);
                    ProxyMappings proxyMappings = ProxyMappings.valueOf(this.config.getArray("proxy-mappings"));
                    if (proxyMappings == null || proxyMappings.isEmpty()) {
                        logger.debug((Object)"Trying to use proxy mapping from env vars");
                        String httpProxy = this.getEnvVarValue(HTTPS_PROXY);
                        if (StringUtil.isBlank((String)httpProxy)) {
                            httpProxy = this.getEnvVarValue(HTTP_PROXY);
                        }
                        String noProxy = this.getEnvVarValue(NO_PROXY);
                        logger.debugf("httpProxy: %s, noProxy: %s", (Object)httpProxy, (Object)noProxy);
                        proxyMappings = ProxyMappings.withFixedProxyMapping(httpProxy, noProxy);
                    }
                    HttpClientBuilder builder = this.newHttpClientBuilder();
                    builder.socketTimeout(socketTimeout, TimeUnit.MILLISECONDS).establishConnectionTimeout(establishConnectionTimeout, TimeUnit.MILLISECONDS).connectionRequestTimeout(connectionRequestTimeout, TimeUnit.MILLISECONDS).maxPooledPerRoute(maxPooledPerRoute).connectionPoolSize(connectionPoolSize).connectionTTL(connectionTTL, TimeUnit.MILLISECONDS).maxConnectionIdleTime(maxConnectionIdleTime, TimeUnit.MILLISECONDS).disableCookies(disableCookies).proxyMappings(proxyMappings).expectContinueEnabled(expectContinueEnabled).reuseConnections(reuseConnections);
                    TruststoreProvider truststoreProvider = (TruststoreProvider)session.getProvider(TruststoreProvider.class);
                    boolean bl = disableTruststoreProvider = truststoreProvider == null || truststoreProvider.getTruststore() == null;
                    if (disableTruststoreProvider) {
                        logger.warn((Object)"TruststoreProvider is disabled");
                    } else {
                        builder.hostnameVerification(truststoreProvider.getPolicy());
                        try {
                            builder.trustStore(truststoreProvider.getTruststore());
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to load truststore", e);
                        }
                    }
                    if (disableTrustManager) {
                        logger.warn((Object)"TrustManager is disabled");
                        builder.disableTrustManager();
                    }
                    if (clientKeystore != null) {
                        clientKeystore = EnvUtil.replace((String)clientKeystore);
                        try {
                            KeyStore clientCertKeystore = KeystoreUtil.loadKeyStore((String)clientKeystore, (String)clientKeystorePassword);
                            builder.keyStore(clientCertKeystore, clientPrivateKeyPassword);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to load keystore", e);
                        }
                    }
                    this.configureRetries(builder);
                    this.httpClient = builder.build();
                }
            }
        }
    }

    private void configureRetries(HttpClientBuilder builder) {
        int maxRetries = this.config.getInt("max-retries", Integer.valueOf(0));
        if (maxRetries <= 0) {
            return;
        }
        final long initialBackoffMillis = this.config.getLong("initial-backoff-millis", Long.valueOf(1000L));
        String backoffMultiplierStr = this.config.get("backoff-multiplier", "2.0");
        final double backoffMultiplier = Double.parseDouble(backoffMultiplierStr);
        final boolean useJitter = this.config.getBoolean("use-jitter", Boolean.valueOf(true));
        String jitterFactorStr = this.config.get("jitter-factor", "0.5");
        final double jitterFactor = Double.parseDouble(jitterFactorStr);
        builder.getApacheHttpClientBuilder().setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(maxRetries, true){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                boolean shouldRetry = super.retryRequest(exception, executionCount, context);
                if (shouldRetry) {
                    try {
                        long baseDelay;
                        long delay = baseDelay = initialBackoffMillis * (long)Math.pow(backoffMultiplier, executionCount - 1);
                        if (useJitter) {
                            double jitter = 1.0 - jitterFactor + Math.random() * jitterFactor * 2.0;
                            delay = (long)((double)baseDelay * jitter);
                        }
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                return shouldRetry;
            }
        });
    }

    protected HttpClientBuilder newHttpClientBuilder() {
        return new HttpClientBuilder();
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.maxConsumedResponseSize = this.config.getLong(MAX_CONSUMED_RESPONSE_SIZE, Long.valueOf(10000000L));
        this.stringResponseHandler = new SafeBasicResponseHandler(this.maxConsumedResponseSize);
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("socket-timeout-millis").type("long").helpText("Socket inactivity timeout.").defaultValue((Object)5000L).add().property().name("establish-connection-timeout-millis").type("long").helpText("Timeout when making an initial socket connection. Only effective if less than the connection-request-timeout-millis.").defaultValue((Object)-1L).add().property().name("connection-request-timeout-millis").type("long").helpText("Timeout when trying to obtain any connection, new or pooled.").defaultValue((Object)HttpClientBuilder.DEFAULT_CONNECTION_REQUEST_TIMEOUT_MILLIS).add().property().name("max-pooled-per-route").type("int").helpText("Assigns maximum connection per route value.").defaultValue((Object)64).add().property().name("connection-pool-size").type("int").helpText("Assigns maximum total connection value.").add().property().name("connection-ttl-millis").type("long").helpText("Sets maximum time, in milliseconds, to live for persistent connections.").defaultValue((Object)-1L).add().property().name("reuse-connections").type("boolean").helpText("If connections should be reused.").defaultValue((Object)true).add().property().name("max-connection-idle-time-millis").type("long").helpText("Sets the time, in milliseconds, for evicting idle connections from the pool.").defaultValue((Object)900000).add().property().name("disable-cookies").type("boolean").helpText("Disables state (cookie) management.").defaultValue((Object)true).add().property().name("client-keystore").type("string").helpText("The file path of the key store from where the key material is going to be read from to set-up TLS connections.").add().property().name("client-keystore-password").type("string").helpText("The key store password.").add().property().name("client-key-password").type("string").helpText("The key password.").defaultValue((Object)-1L).add().property().name("disable-trust-manager").type("boolean").helpText("Disable trust management and hostname verification. NOTE this is a security hole, so only set this option if you cannot or do not want to verify the identity of the host you are communicating with.").defaultValue((Object)false).add().property().name("proxy-mappings").type("string").helpText("Denotes the combination of a regex based hostname pattern and a proxy-uri in the form of hostnamePattern;proxyUri.").add().property().name(MAX_CONSUMED_RESPONSE_SIZE).type("long").helpText("Maximum size of a response consumed by the client (to prevent denial of service)").defaultValue((Object)10000000L).add().property().name("max-retries").type("int").helpText("Maximum number of retry attempts for all outgoing HTTP requests. Set to 0 to disable retries (default).").defaultValue((Object)0).add().property().name("initial-backoff-millis").type("long").helpText("Initial backoff time in milliseconds before the first retry attempt.").defaultValue((Object)1000L).add().property().name("backoff-multiplier").type("string").helpText("Multiplier for exponential backoff between retry attempts. For example, with an initial backoff of 1000ms and a multiplier of 2.0, the retry delays would be: 1000ms, 2000ms, 4000ms, etc.").defaultValue((Object)"2.0").add().property().name("use-jitter").type("boolean").helpText("Whether to apply jitter to backoff times to prevent synchronized retry storms when multiple clients are retrying at the same time.").defaultValue((Object)true).add().property().name("jitter-factor").type("string").helpText("Jitter factor to apply to backoff times. A value of 0.5 means the actual backoff time will be between 50% and 150% of the calculated exponential backoff time.").defaultValue((Object)"0.5").add().build();
    }

    private boolean getBooleanConfigWithSysPropFallback(String key, boolean defaultValue) {
        String s;
        Boolean value = this.config.getBoolean(key);
        if (value == null && (s = System.getProperty(configScope + key)) != null) {
            value = Boolean.parseBoolean(s);
        }
        return value != null ? value : defaultValue;
    }

    private String getEnvVarValue(String name) {
        String value = System.getenv(name.toLowerCase());
        if (StringUtil.isBlank((String)value)) {
            value = System.getenv(name.toUpperCase());
        }
        return value;
    }

    public Config.Scope getConfig() {
        return this.config;
    }

    private static class InputStreamResponseHandler
    extends AbstractResponseHandler<InputStream> {
        private InputStreamResponseHandler() {
        }

        public InputStream handleEntity(HttpEntity entity) throws IOException {
            return entity.getContent();
        }

        public InputStream handleResponse(HttpResponse response) throws IOException {
            return (InputStream)super.handleResponse(response);
        }
    }
}

