/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.keycloak.Token;
import org.keycloak.TokenCategory;
import org.keycloak.common.util.Time;
import org.keycloak.json.StringOrArrayDeserializer;
import org.keycloak.json.StringOrArraySerializer;
import org.keycloak.util.JsonSerialization;

public class JsonWebToken
implements Serializable,
Token {
    public static final String AZP = "azp";
    public static final String AUD = "aud";
    public static final String SUBJECT = "sub";
    @JsonProperty(value="jti")
    protected String id;
    protected Long exp;
    protected Long nbf;
    protected Long iat;
    @JsonProperty(value="iss")
    protected String issuer;
    @JsonProperty(value="aud")
    @JsonSerialize(using=StringOrArraySerializer.class)
    @JsonDeserialize(using=StringOrArrayDeserializer.class)
    protected String[] audience;
    @JsonProperty(value="sub")
    protected String subject;
    @JsonProperty(value="typ")
    protected String type;
    @JsonProperty(value="azp")
    public String issuedFor;
    protected Map<String, Object> otherClaims = new HashMap<String, Object>();

    public String getId() {
        return this.id;
    }

    public JsonWebToken id(String id) {
        this.id = id;
        return this;
    }

    public Long getExp() {
        return this.exp;
    }

    public JsonWebToken exp(Long exp) {
        this.exp = exp;
        return this;
    }

    @JsonIgnore
    public boolean isExpired() {
        return this.exp != null && this.exp != 0L && (long)Time.currentTime() > this.exp;
    }

    public Long getNbf() {
        return this.nbf;
    }

    public JsonWebToken nbf(Long nbf) {
        this.nbf = nbf;
        return this;
    }

    @JsonIgnore
    public boolean isNotBefore(long allowedTimeSkew) {
        return this.nbf == null || (long)Time.currentTime() + allowedTimeSkew >= this.nbf;
    }

    @JsonIgnore
    public boolean isActive() {
        return this.isActive(0);
    }

    @JsonIgnore
    public boolean isActive(int allowedTimeSkew) {
        return !this.isExpired() && this.isNotBefore(allowedTimeSkew);
    }

    @JsonIgnore
    public boolean isIssuedBeforeSessionStart(long sessionStarted) {
        return this.getIat() + 1L < sessionStarted;
    }

    public Long getIat() {
        return this.iat;
    }

    @JsonIgnore
    public JsonWebToken issuedNow() {
        this.iat = Time.currentTime();
        return this;
    }

    public JsonWebToken iat(Long iat) {
        this.iat = iat;
        return this;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public JsonWebToken issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @JsonIgnore
    public String[] getAudience() {
        return this.audience;
    }

    public boolean hasAudience(String audience) {
        if (this.audience == null) {
            return false;
        }
        for (String a : this.audience) {
            if (!a.equals(audience)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyAudience(List<String> audiences) {
        String[] auds = this.getAudience();
        if (auds == null) {
            return false;
        }
        for (String aud : auds) {
            if (!audiences.contains(aud)) continue;
            return true;
        }
        return false;
    }

    public JsonWebToken audience(String ... audience) {
        this.audience = audience;
        return this;
    }

    public JsonWebToken addAudience(String audience) {
        if (this.audience == null) {
            this.audience = new String[]{audience};
        } else {
            for (String aud : this.audience) {
                if (!audience.equals(aud)) continue;
                return this;
            }
            String[] newAudience = Arrays.copyOf(this.audience, this.audience.length + 1);
            newAudience[this.audience.length] = audience;
            this.audience = newAudience;
        }
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public JsonWebToken subject(String subject) {
        this.subject = subject;
        return this;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getType() {
        return this.type;
    }

    public JsonWebToken type(String type) {
        this.type = type;
        return this;
    }

    public String getIssuedFor() {
        return this.issuedFor;
    }

    public JsonWebToken issuedFor(String issuedFor) {
        this.issuedFor = issuedFor;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getOtherClaims() {
        return this.otherClaims;
    }

    @JsonAnySetter
    public void setOtherClaims(String name, Object value) {
        this.otherClaims.put(name, value);
    }

    @Override
    public TokenCategory getCategory() {
        return TokenCategory.INTERNAL;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof JsonWebToken)) {
            return false;
        }
        JsonWebToken that = (JsonWebToken)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.exp, that.exp) && Objects.equals(this.nbf, that.nbf) && Objects.equals(this.iat, that.iat) && Objects.equals(this.issuer, that.issuer) && Arrays.equals(this.audience, that.audience) && Objects.equals(this.subject, that.subject) && Objects.equals(this.type, that.type) && Objects.equals(this.issuedFor, that.issuedFor) && Objects.equals(this.otherClaims, that.otherClaims);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.exp);
        result = 31 * result + Objects.hashCode(this.nbf);
        result = 31 * result + Objects.hashCode(this.iat);
        result = 31 * result + Objects.hashCode(this.issuer);
        result = 31 * result + Arrays.hashCode(this.audience);
        result = 31 * result + Objects.hashCode(this.subject);
        result = 31 * result + Objects.hashCode(this.type);
        result = 31 * result + Objects.hashCode(this.issuedFor);
        result = 31 * result + Objects.hashCode(this.otherClaims);
        return result;
    }

    public String toString() {
        try {
            return JsonSerialization.writeValueAsString(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

