/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.time.Instant;
import java.util.Collections;
import java.util.function.BiConsumer;
import org.hibernate.annotations.SoftDeleteType;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CurrentFunction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.SoftDeletable;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SoftDeletableModelPart;
import org.hibernate.metamodel.mapping.SoftDeleteMapping;
import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.ColumnWriteFragment;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;

public class SoftDeleteMappingImpl
implements SoftDeleteMapping {
    private final NavigableRole navigableRole;
    private final SoftDeletableModelPart softDeletable;
    private final SoftDeleteType strategy;
    private final String columnName;
    private final String tableName;
    private final JdbcMapping jdbcMapping;
    private final Object deletionIndicator;
    private final String currentTimestampFunctionName;
    private final SelfRenderingFunctionSqlAstExpression<?> currentTimestampFunctionExpression;
    private final Object deletedLiteralValue;
    private final String deletedLiteralText;
    private final Object nonDeletedLiteralValue;
    private final String nonDeletedLiteralText;

    public SoftDeleteMappingImpl(SoftDeletableModelPart softDeletable, SoftDeletable bootMapping, String tableName, MappingModelCreationProcess modelCreationProcess) {
        assert (bootMapping.getSoftDeleteColumn() != null);
        this.navigableRole = softDeletable.getNavigableRole().append("{soft-delete}");
        this.softDeletable = softDeletable;
        this.strategy = bootMapping.getSoftDeleteStrategy();
        Dialect dialect = modelCreationProcess.getCreationContext().getDialect();
        Column softDeleteColumn = bootMapping.getSoftDeleteColumn();
        BasicValue columnValue = (BasicValue)softDeleteColumn.getValue();
        BasicValue.Resolution<?> resolution = columnValue.resolve();
        this.columnName = softDeleteColumn.getName();
        this.tableName = tableName;
        this.jdbcMapping = resolution.getJdbcMapping();
        if (bootMapping.getSoftDeleteStrategy() == SoftDeleteType.TIMESTAMP) {
            this.currentTimestampFunctionName = dialect.currentTimestamp();
            BasicType<Instant> currentTimestampFunctionType = modelCreationProcess.getCreationContext().getTypeConfiguration().getBasicTypeForJavaType(Instant.class);
            CurrentFunction currentTimestampFunction = new CurrentFunction(this.currentTimestampFunctionName, this.currentTimestampFunctionName, currentTimestampFunctionType);
            this.currentTimestampFunctionExpression = new SelfRenderingFunctionSqlAstExpression<Instant>(this.currentTimestampFunctionName, currentTimestampFunction, Collections.emptyList(), currentTimestampFunctionType, softDeletable);
            this.deletionIndicator = this.currentTimestampFunctionName;
            this.deletedLiteralValue = null;
            this.deletedLiteralText = null;
            this.nonDeletedLiteralValue = null;
            this.nonDeletedLiteralText = null;
        } else {
            BasicValueConverter<?, ?> converter = resolution.getValueConverter();
            JdbcLiteralFormatter literalFormatter = resolution.getJdbcMapping().getJdbcLiteralFormatter();
            if (converter == null) {
                this.deletedLiteralValue = true;
                this.nonDeletedLiteralValue = false;
            } else {
                this.deletedLiteralValue = converter.toRelationalValue(true);
                this.nonDeletedLiteralValue = converter.toRelationalValue(false);
            }
            this.deletedLiteralText = literalFormatter.toJdbcLiteral(this.deletedLiteralValue, dialect, null);
            this.nonDeletedLiteralText = literalFormatter.toJdbcLiteral(this.nonDeletedLiteralValue, dialect, null);
            this.deletionIndicator = this.deletedLiteralValue;
            this.currentTimestampFunctionName = null;
            this.currentTimestampFunctionExpression = null;
        }
    }

    @Override
    public SoftDeleteType getSoftDeleteStrategy() {
        return this.strategy;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getWriteExpression() {
        return this.strategy == SoftDeleteType.TIMESTAMP ? null : this.nonDeletedLiteralText;
    }

    public Object getDeletionIndicator() {
        return this.deletionIndicator;
    }

    @Override
    public Assignment createSoftDeleteAssignment(TableReference tableReference) {
        ColumnReference columnReference = new ColumnReference(tableReference, (SelectableMapping)this);
        DomainResultProducer<Object> valueExpression = this.strategy == SoftDeleteType.TIMESTAMP ? this.currentTimestampFunctionExpression : new JdbcLiteral<Object>(this.deletedLiteralValue, this.jdbcMapping);
        return new Assignment(columnReference, (Expression)((Object)valueExpression));
    }

    @Override
    public Predicate createNonDeletedRestriction(TableReference tableReference) {
        ColumnReference softDeleteColumn = new ColumnReference(tableReference, (SelectableMapping)this);
        if (this.strategy == SoftDeleteType.TIMESTAMP) {
            return new NullnessPredicate(softDeleteColumn, false, this.jdbcMapping);
        }
        JdbcLiteral<Object> notDeletedLiteral = new JdbcLiteral<Object>(this.nonDeletedLiteralValue, this.jdbcMapping);
        return new ComparisonPredicate(softDeleteColumn, ComparisonOperator.EQUAL, notDeletedLiteral);
    }

    @Override
    public Predicate createNonDeletedRestriction(TableReference tableReference, SqlExpressionResolver expressionResolver) {
        Expression softDeleteColumn = expressionResolver.resolveSqlExpression(tableReference, this);
        if (this.strategy == SoftDeleteType.TIMESTAMP) {
            return new NullnessPredicate(softDeleteColumn, false, this.jdbcMapping);
        }
        return new ComparisonPredicate(softDeleteColumn, ComparisonOperator.EQUAL, new JdbcLiteral<Object>(this.nonDeletedLiteralValue, this.jdbcMapping));
    }

    @Override
    public ColumnValueBinding createNonDeletedValueBinding(ColumnReference softDeleteColumnReference) {
        ColumnWriteFragment nonDeletedFragment = this.strategy == SoftDeleteType.TIMESTAMP ? new ColumnWriteFragment(null, Collections.emptyList(), this.jdbcMapping) : new ColumnWriteFragment(this.nonDeletedLiteralText, Collections.emptyList(), this.jdbcMapping);
        return new ColumnValueBinding(softDeleteColumnReference, nonDeletedFragment);
    }

    @Override
    public ColumnValueBinding createDeletedValueBinding(ColumnReference softDeleteColumnReference) {
        ColumnWriteFragment deletedFragment = this.strategy == SoftDeleteType.TIMESTAMP ? new ColumnWriteFragment(this.currentTimestampFunctionName, Collections.emptyList(), this.getJdbcMapping()) : new ColumnWriteFragment(this.deletedLiteralText, Collections.emptyList(), this.jdbcMapping);
        return new ColumnValueBinding(softDeleteColumnReference, deletedFragment);
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public String getPartName() {
        return "{soft-delete}";
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.jdbcMapping);
        return 1;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return value;
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, x, y, value, this.getJdbcMapping());
        return 1;
    }

    @Override
    public MappingType getPartMappingType() {
        return this.jdbcMapping;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.jdbcMapping.getMappedJavaType();
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return false;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(navigablePath, tableGroup, creationState);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.getJdbcMapping(), navigablePath, false, !sqlSelection.isVirtual());
    }

    private SqlSelection resolveSqlSelection(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        TableDetails indicatorTable = this.softDeletable.getSoftDeleteTableDetails();
        TableReference tableReference = tableGroup.resolveTableReference(navigablePath.getRealParent(), indicatorTable.getTableName());
        SqlExpressionResolver expressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        return expressionResolver.resolveSqlSelection(expressionResolver.resolveSqlExpression(tableReference, this), this.getJavaType(), null, creationState.getSqlAstCreationState().getCreationContext().getMappingMetamodel().getTypeConfiguration());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        SqlSelection sqlSelection = this.resolveSqlSelection(navigablePath, tableGroup, creationState);
        selectionConsumer.accept(sqlSelection, this.getJdbcMapping());
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(offset, x, y, this.disassemble(domainValue, session), this);
        return 1;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.softDeletable.findContainingEntityMapping();
    }

    public String toString() {
        return "SoftDeleteMapping(" + this.tableName + "." + this.columnName + ")";
    }
}

