/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.encode;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.protocol.oidc.encode.AccessTokenContext;
import org.keycloak.protocol.oidc.encode.DefaultTokenContextEncoderProvider;
import org.keycloak.protocol.oidc.encode.TokenContextEncoderProvider;
import org.keycloak.protocol.oidc.encode.TokenContextEncoderProviderFactory;
import org.keycloak.protocol.oidc.grants.OAuth2GrantType;
import org.keycloak.protocol.oidc.grants.OAuth2GrantTypeFactory;
import org.keycloak.provider.ProviderFactory;

public class DefaultTokenContextEncoderProviderFactory
implements TokenContextEncoderProviderFactory {
    private KeycloakSessionFactory sessionFactory;
    private Map<String, AccessTokenContext.SessionType> sessionTypesByShortcut;
    private Map<String, AccessTokenContext.TokenType> tokenTypesByShortcut;
    Map<String, String> grantsByShortcuts;
    Map<String, String> grantsToShortcuts;

    public TokenContextEncoderProvider create(KeycloakSession session) {
        return new DefaultTokenContextEncoderProvider(session, this);
    }

    public void init(Config.Scope config) {
        this.sessionTypesByShortcut = new HashMap<String, AccessTokenContext.SessionType>();
        for (AccessTokenContext.SessionType sessionType : AccessTokenContext.SessionType.values()) {
            this.sessionTypesByShortcut.put(sessionType.getShortcut(), sessionType);
        }
        this.sessionTypesByShortcut = Collections.unmodifiableMap(this.sessionTypesByShortcut);
        this.tokenTypesByShortcut = new HashMap<String, AccessTokenContext.TokenType>();
        for (Enum enum_ : AccessTokenContext.TokenType.values()) {
            this.tokenTypesByShortcut.put(((AccessTokenContext.TokenType)enum_).getShortcut(), (AccessTokenContext.TokenType)enum_);
        }
        this.tokenTypesByShortcut = Collections.unmodifiableMap(this.tokenTypesByShortcut);
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.sessionFactory = factory;
        this.grantsByShortcuts = new ConcurrentHashMap<String, String>();
        this.grantsToShortcuts = new ConcurrentHashMap<String, String>();
        factory.getProviderFactoriesStream(OAuth2GrantType.class).forEach(factory1 -> {
            OAuth2GrantTypeFactory gtf = (OAuth2GrantTypeFactory)factory1;
            String grantName = gtf.getId();
            String grantShortcut = gtf.getShortcut();
            this.grantsByShortcuts.put(grantShortcut, grantName);
            this.grantsToShortcuts.put(grantName, grantShortcut);
        });
        this.grantsByShortcuts.put("na", "na");
        this.grantsToShortcuts.put("na", "na");
        if (this.grantsByShortcuts.size() != this.grantsToShortcuts.size()) {
            throw new IllegalStateException("Different lengths of maps. grantsByShortcuts.size=" + this.grantsByShortcuts.size() + ", grantsToShortcuts.size=" + this.grantsToShortcuts.size() + ". Make sure that there is no OAuth2GrantType implementation with same ID or shortcut like other grants");
        }
    }

    public void close() {
    }

    public String getId() {
        return "default";
    }

    protected AccessTokenContext.SessionType getSessionTypeByShortcut(String sessionTypeShortcut) {
        return this.sessionTypesByShortcut.get(sessionTypeShortcut);
    }

    protected AccessTokenContext.TokenType getTokenTypeByShortcut(String tokenTypeShortcut) {
        return this.tokenTypesByShortcut.get(tokenTypeShortcut);
    }

    protected String getShortcutByGrantType(String grantType) {
        String grantShortcut = this.grantsToShortcuts.get(grantType);
        if (grantShortcut == null) {
            OAuth2GrantTypeFactory factory = (OAuth2GrantTypeFactory)this.sessionFactory.getProviderFactory(OAuth2GrantType.class, grantType);
            if (factory != null) {
                String shortcut = factory.getShortcut();
                this.grantsByShortcuts.put(shortcut, grantType);
                this.grantsToShortcuts.put(grantType, shortcut);
            }
            grantShortcut = this.grantsToShortcuts.get(grantType);
        }
        return grantShortcut;
    }

    protected String getGrantTypeByShortcut(String shortcut) {
        String grantType = this.grantsByShortcuts.get(shortcut);
        if (grantType == null) {
            this.sessionFactory.getProviderFactoriesStream(OAuth2GrantType.class).map(fct -> (OAuth2GrantTypeFactory)fct).filter(fct -> shortcut.equals(fct.getShortcut())).map(ProviderFactory::getId).findFirst().ifPresent(newGrantType -> {
                this.grantsByShortcuts.put(shortcut, (String)newGrantType);
                this.grantsToShortcuts.put((String)newGrantType, shortcut);
            });
            grantType = this.grantsByShortcuts.get(shortcut);
        }
        return grantType;
    }
}

