/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.keybinding;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.OID4VCIssuerWellKnownProvider;
import org.keycloak.protocol.oid4vc.issuance.VCIssuanceContext;
import org.keycloak.protocol.oid4vc.issuance.VCIssuerException;
import org.keycloak.protocol.oid4vc.issuance.keybinding.AttestationKeyResolver;
import org.keycloak.protocol.oid4vc.issuance.keybinding.CNonceHandler;
import org.keycloak.protocol.oid4vc.model.ErrorType;
import org.keycloak.protocol.oid4vc.model.KeyAttestationJwtBody;
import org.keycloak.protocol.oid4vc.model.KeyAttestationsRequired;
import org.keycloak.protocol.oid4vc.model.SupportedProofTypeData;
import org.keycloak.services.clientpolicy.executor.FapiConstant;
import org.keycloak.util.JsonSerialization;

public class AttestationValidatorUtil {
    private static final Logger LOGGER = Logger.getLogger(AttestationValidatorUtil.class);
    public static final String ATTESTATION_JWT_TYP = "key-attestation+jwt";
    @Deprecated
    public static final String LEGACY_ATTESTATION_JWT_TYP = "keyattestation+jwt";
    private static final String CACERTS_PATH = System.getProperty("javax.net.ssl.trustStore", System.getProperty("java.home") + "/lib/security/cacerts");
    private static final char[] DEFAULT_TRUSTSTORE_PASSWORD = System.getProperty("javax.net.ssl.trustStorePassword", "changeit").toCharArray();

    public static KeyAttestationJwtBody validateAttestationJwt(String attestationJwt, KeycloakSession keycloakSession, VCIssuanceContext vcIssuanceContext, AttestationKeyResolver keyResolver) throws JWSInputException, VerificationException {
        SignatureVerifierContext verifier;
        KeyAttestationJwtBody attestationBody;
        if (attestationJwt == null || attestationJwt.split("\\.").length != 3) {
            throw new VCIssuerException("Invalid JWT format");
        }
        JWSInput jwsInput = new JWSInput(attestationJwt);
        String payloadString = new String(jwsInput.getContent(), StandardCharsets.UTF_8);
        try {
            JsonSerialization.mapper.readTree(payloadString);
        }
        catch (JsonProcessingException e) {
            throw new VCIssuerException("Invalid JSON in attestation payload: " + payloadString, e);
        }
        try {
            attestationBody = (KeyAttestationJwtBody)JsonSerialization.readValue((byte[])jwsInput.getContent(), KeyAttestationJwtBody.class);
        }
        catch (IOException e) {
            throw new VCIssuerException("Invalid attestation payload format", e);
        }
        JWSHeader header = jwsInput.getHeader();
        AttestationValidatorUtil.validateJwsHeader(header);
        Map rawHeader = (Map)JsonSerialization.mapper.convertValue((Object)jwsInput.getHeader(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (header.getX5c() != null && !header.getX5c().isEmpty()) {
            verifier = AttestationValidatorUtil.verifierFromX5CChain(header.getX5c(), header.getAlgorithm().name(), keycloakSession);
        } else if (header.getKeyId() != null) {
            JWK resolvedJwk = keyResolver.resolveKey(header.getKeyId(), rawHeader, (Map)JsonSerialization.mapper.convertValue((Object)attestationBody, Map.class));
            if (resolvedJwk == null) {
                throw new VCIssuerException("Key with kid '" + header.getKeyId() + "' not found in trusted key registry");
            }
            verifier = AttestationValidatorUtil.verifierFromResolvedJWK(resolvedJwk, header.getAlgorithm().name(), keycloakSession);
        } else {
            throw new VCIssuerException("Neither x5c nor kid present in attestation JWT header");
        }
        if (!verifier.verify(jwsInput.getEncodedSignatureInput().getBytes(StandardCharsets.UTF_8), jwsInput.getSignature())) {
            throw new VCIssuerException("Could not verify signature of attestation JWT");
        }
        AttestationValidatorUtil.validateAttestationPayload(keycloakSession, vcIssuanceContext, attestationBody);
        if (attestationBody.getAttestedKeys() == null) {
            throw new VCIssuerException("Missing required attested_keys claim in attestation");
        }
        return attestationBody;
    }

    private static void validateAttestationPayload(KeycloakSession keycloakSession, VCIssuanceContext vcIssuanceContext, KeyAttestationJwtBody attestationBody) throws VCIssuerException, VerificationException {
        boolean nonceRequired;
        if (attestationBody.getIat() == null) {
            throw new VCIssuerException("Missing 'iat' claim in attestation");
        }
        KeyAttestationsRequired attestationRequirements = AttestationValidatorUtil.getAttestationRequirements(vcIssuanceContext);
        AttestationValidatorUtil.validateResistanceLevel(attestationBody, attestationRequirements);
        KeycloakContext keycloakContext = keycloakSession.getContext();
        CNonceHandler cNonceHandler = (CNonceHandler)keycloakSession.getProvider(CNonceHandler.class);
        boolean bl = nonceRequired = cNonceHandler != null;
        if (nonceRequired && attestationBody.getNonce() == null) {
            throw new VCIssuerException("Missing 'nonce' in attestation");
        }
        if (attestationBody.getNonce() != null) {
            if (cNonceHandler == null) {
                throw new VCIssuerException("No CNonceHandler available");
            }
            try {
                cNonceHandler.verifyCNonce(attestationBody.getNonce(), List.of(OID4VCIssuerWellKnownProvider.getCredentialsEndpoint(keycloakContext)), Map.of("source_endpoint", OID4VCIssuerWellKnownProvider.getNonceEndpoint(keycloakContext)));
            }
            catch (VerificationException e) {
                throw new VCIssuerException(ErrorType.INVALID_NONCE, "The key attestation uses an invalid nonce", e);
            }
        }
        if (attestationBody.getAttestedKeys() != null) {
            vcIssuanceContext.setAttestedKeys(attestationBody.getAttestedKeys());
        }
    }

    private static KeyAttestationsRequired getAttestationRequirements(VCIssuanceContext vcIssuanceContext) {
        if (vcIssuanceContext.getCredentialConfig() == null || vcIssuanceContext.getCredentialConfig().getProofTypesSupported() == null || vcIssuanceContext.getCredentialConfig().getProofTypesSupported().getSupportedProofTypes() == null) {
            return null;
        }
        SupportedProofTypeData proofTypeData = vcIssuanceContext.getCredentialConfig().getProofTypesSupported().getSupportedProofTypes().get("jwt");
        return proofTypeData != null ? proofTypeData.getKeyAttestationsRequired() : null;
    }

    private static void validateResistanceLevel(KeyAttestationJwtBody attestationBody, KeyAttestationsRequired attestationRequirements) {
        if (attestationRequirements != null) {
            AttestationValidatorUtil.validateResistanceLevel(attestationBody.getKeyStorage(), attestationRequirements.getKeyStorage(), "key_storage");
            AttestationValidatorUtil.validateResistanceLevel(attestationBody.getUserAuthentication(), attestationRequirements.getUserAuthentication(), "user_authentication");
        }
    }

    private static void validateResistanceLevel(List<String> providedLevels, List<String> acceptedLevels, String levelType) throws VCIssuerException {
        if (acceptedLevels == null || acceptedLevels.isEmpty()) {
            return;
        }
        if (providedLevels == null || providedLevels.isEmpty()) {
            throw new VCIssuerException(levelType + " is required but was missing.");
        }
        boolean foundMatch = providedLevels.stream().anyMatch(acceptedLevels::contains);
        if (!foundMatch) {
            throw new VCIssuerException(levelType + " none of the provided levels from '" + String.valueOf(providedLevels) + "' did match any of the accepted levels: " + String.valueOf(acceptedLevels));
        }
    }

    private static void validateJwsHeader(JWSHeader header) {
        String alg = Optional.ofNullable(header.getAlgorithm()).map(Enum::name).orElseThrow(() -> new VCIssuerException("Missing algorithm in JWS header"));
        if ("none".equalsIgnoreCase(alg)) {
            throw new VCIssuerException("'none' algorithm is not allowed");
        }
        if (!FapiConstant.ALLOWED_ALGORITHMS.contains(alg)) {
            throw new VCIssuerException("Unsupported algorithm: " + alg + ". Allowed algorithms: " + String.valueOf(FapiConstant.ALLOWED_ALGORITHMS));
        }
        String typ = Optional.ofNullable(header.getType()).map(Object::toString).orElseThrow(() -> new VCIssuerException("Missing typ in JWS header"));
        if (!ATTESTATION_JWT_TYP.equals(typ)) {
            if (LEGACY_ATTESTATION_JWT_TYP.equals(typ)) {
                LOGGER.debugf("Accepting deprecated attestation JWT typ '%s' for backward compatibility", (Object)typ);
            } else {
                throw new VCIssuerException("Invalid JWT typ: expected key-attestation+jwt");
            }
        }
    }

    private static SignatureVerifierContext verifierFromX5CChain(List<String> x5cList, String alg, KeycloakSession keycloakSession) throws VCIssuerException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
            for (String certBase64 : x5cList) {
                byte[] certBytes = Base64.getDecoder().decode(certBase64);
                try (ByteArrayInputStream in = new ByteArrayInputStream(certBytes);){
                    certChain.add((X509Certificate)cf.generateCertificate(in));
                }
            }
            CertPath certPath = cf.generateCertPath(certChain);
            X509Certificate firstCert = (X509Certificate)certChain.get(0);
            boolean isSelfSigned = firstCert.getSubjectX500Principal().equals(firstCert.getIssuerX500Principal());
            if (!isSelfSigned) {
                CertPathValidator validator = CertPathValidator.getInstance("PKIX");
                PKIXParameters params = new PKIXParameters(AttestationValidatorUtil.getTrustAnchors());
                params.setRevocationEnabled(false);
                validator.validate(certPath, params);
            }
            PublicKey publicKey = ((X509Certificate)certChain.get(0)).getPublicKey();
            JWK certJwk = AttestationValidatorUtil.convertPublicKeyToJWK(publicKey, alg, certChain);
            return AttestationValidatorUtil.verifierFromResolvedJWK(certJwk, alg, keycloakSession);
        }
        catch (Exception e) {
            throw new VCIssuerException("Failed to validate x5c certificate chain", e);
        }
    }

    private static Set<TrustAnchor> getTrustAnchors() throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream in = new FileInputStream(CACERTS_PATH);){
            trustStore.load(in, DEFAULT_TRUSTSTORE_PASSWORD);
        }
        HashSet<TrustAnchor> anchors = new HashSet<TrustAnchor>();
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            Certificate cert = trustStore.getCertificate(aliases.nextElement());
            if (!(cert instanceof X509Certificate)) continue;
            anchors.add(new TrustAnchor((X509Certificate)cert, null));
        }
        return anchors;
    }

    private static SignatureVerifierContext verifierFromResolvedJWK(JWK jwk, String alg, KeycloakSession session) throws VerificationException {
        SignatureProvider provider = (SignatureProvider)session.getProvider(SignatureProvider.class, alg);
        KeyWrapper wrapper = new KeyWrapper();
        wrapper.setType(jwk.getKeyType());
        wrapper.setAlgorithm(alg);
        wrapper.setUse(KeyUse.SIG);
        if (jwk.getOtherClaims().get("crv") != null) {
            wrapper.setCurve((String)jwk.getOtherClaims().get("crv"));
        }
        wrapper.setPublicKey((Key)JWKParser.create((JWK)jwk).toPublicKey());
        return provider.verifier(wrapper);
    }

    private static JWK convertPublicKeyToJWK(PublicKey key, String alg, List<X509Certificate> certChain) {
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rsa = (RSAPublicKey)key;
            return JWKBuilder.create().algorithm(alg).rsa((Key)rsa, certChain);
        }
        if (key instanceof ECPublicKey) {
            ECPublicKey ec = (ECPublicKey)key;
            return JWKBuilder.create().algorithm(alg).ec((Key)ec, certChain, null);
        }
        throw new VCIssuerException("Unsupported public key type in certificate: " + key.getClass().getName());
    }
}

