/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.interfaces.EdECPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.crypto.KeyUse;
import org.keycloak.keys.AbstractEddsaKeyProviderFactory;
import org.keycloak.keys.GeneratedEddsaKeyProvider;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;

public class GeneratedEddsaKeyProviderFactory
extends AbstractEddsaKeyProviderFactory {
    private static final Logger logger = Logger.getLogger(GeneratedEddsaKeyProviderFactory.class);
    public static final String ID = "eddsa-generated";
    private static final String HELP_TEXT = "Generates EdDSA keys";
    public static final String DEFAULT_EDDSA_ELLIPTIC_CURVE = "Ed25519";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = AbstractEddsaKeyProviderFactory.configurationBuilder().property(EDDSA_ELLIPTIC_CURVE_PROPERTY).build();

    public KeyProvider create(KeycloakSession session, ComponentModel model) {
        return new GeneratedEddsaKeyProvider(session.getContext().getRealm(), model);
    }

    public boolean createFallbackKeys(KeycloakSession session, KeyUse keyUse, String algorithm) {
        if (keyUse.equals((Object)KeyUse.SIG) && algorithm.equals("EdDSA")) {
            RealmModel realm = session.getContext().getRealm();
            ComponentModel generated = new ComponentModel();
            generated.setName("fallback-" + algorithm);
            generated.setParentId(realm.getId());
            generated.setProviderId(ID);
            generated.setProviderType(KeyProvider.class.getName());
            MultivaluedHashMap config = new MultivaluedHashMap();
            config.putSingle((Object)"priority", (Object)"-100");
            config.putSingle((Object)"eddsaEllipticCurveKey", (Object)DEFAULT_EDDSA_ELLIPTIC_CURVE);
            generated.setConfig(config);
            realm.addComponentModel(generated);
            return true;
        }
        return false;
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return ID;
    }

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        super.validateConfiguration(session, realm, model);
        ConfigurationValidationHelper.check((ComponentModel)model).checkList(EDDSA_ELLIPTIC_CURVE_PROPERTY, false);
        String curveName = model.get("eddsaEllipticCurveKey");
        if (curveName == null) {
            curveName = DEFAULT_EDDSA_ELLIPTIC_CURVE;
        }
        if (!model.contains("eddsaPrivateKey") || !model.contains("eddsaPublicKey")) {
            this.generateKeys(model, curveName);
            logger.debugv("Generated keys for {0}", (Object)realm.getName());
        } else {
            String currentEdEc = this.getCurveFromPublicKey((String)model.getConfig().getFirst((Object)"eddsaPublicKey"));
            if (!curveName.equals(currentEdEc)) {
                this.generateKeys(model, curveName);
                logger.debugv("Twisted Edwards Curve changed, generating new keys for {0}", (Object)realm.getName());
            }
        }
    }

    private void generateKeys(ComponentModel model, String curveName) {
        try {
            KeyPair keyPair = KeyUtils.generateEddsaKeyPair((String)curveName);
            model.put("eddsaPrivateKey", Base64.getEncoder().encodeToString(keyPair.getPrivate().getEncoded()));
            model.put("eddsaPublicKey", Base64.getEncoder().encodeToString(keyPair.getPublic().getEncoded()));
            model.put("eddsaEllipticCurveKey", curveName);
        }
        catch (Throwable t) {
            throw new ComponentValidationException("Failed to generate EdDSA keys", t);
        }
    }

    private String getCurveFromPublicKey(String publicEddsaKeyBase64Encoded) {
        try {
            KeyFactory kf = KeyFactory.getInstance("EdDSA");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicEddsaKeyBase64Encoded));
            EdECPublicKey edEcKey = (EdECPublicKey)kf.generatePublic(publicKeySpec);
            return edEcKey.getParams().getName();
        }
        catch (Throwable t) {
            throw new ComponentValidationException("Failed to get Twisted Edwards Curve from its public key", t);
        }
    }
}

