/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.format.jackson;

import org.hibernate.type.format.FormatMapper;
import org.hibernate.type.format.jackson.JacksonJsonFormatMapper;
import org.hibernate.type.format.jackson.JacksonOsonFormatMapper;
import org.hibernate.type.format.jackson.JacksonXmlFormatMapper;

public final class JacksonIntegration {
    private static final boolean JACKSON_XML_AVAILABLE = JacksonIntegration.ableToLoadJacksonXMLMapper();
    private static final boolean JACKSON_JSON_AVAILABLE = JacksonIntegration.ableToLoadJacksonJSONMapper();
    private static final boolean JACKSON_OSON_AVAILABLE = JacksonIntegration.ableToLoadJacksonOSONFactory();
    private static final FormatMapper XML_FORMAT_MAPPER = JACKSON_XML_AVAILABLE ? new JacksonXmlFormatMapper() : null;
    private static final FormatMapper XML_FORMAT_MAPPER_PORTABLE = JACKSON_XML_AVAILABLE ? new JacksonXmlFormatMapper(false) : null;
    private static final FormatMapper JSON_FORMAT_MAPPER = JACKSON_JSON_AVAILABLE ? new JacksonJsonFormatMapper() : null;
    private static final FormatMapper OSON_FORMAT_MAPPER = JACKSON_OSON_AVAILABLE ? new JacksonOsonFormatMapper() : null;

    private JacksonIntegration() {
    }

    private static boolean ableToLoadJacksonJSONMapper() {
        return JacksonIntegration.canLoad("com.fasterxml.jackson.databind.ObjectMapper");
    }

    private static boolean ableToLoadJacksonXMLMapper() {
        return JacksonIntegration.canLoad("com.fasterxml.jackson.dataformat.xml.XmlMapper");
    }

    private static boolean ableToLoadJacksonOSONFactory() {
        return JacksonIntegration.ableToLoadJacksonJSONMapper() && JacksonIntegration.canLoad("oracle.jdbc.provider.oson.OsonFactory");
    }

    public static FormatMapper getXMLJacksonFormatMapperOrNull(boolean legacyFormat) {
        return legacyFormat ? XML_FORMAT_MAPPER : XML_FORMAT_MAPPER_PORTABLE;
    }

    public static FormatMapper getJsonJacksonFormatMapperOrNull() {
        return JSON_FORMAT_MAPPER;
    }

    public static FormatMapper getOsonJacksonFormatMapperOrNull() {
        return OSON_FORMAT_MAPPER;
    }

    public static boolean isJacksonOsonExtensionAvailable() {
        return JACKSON_OSON_AVAILABLE;
    }

    private static boolean canLoad(String name) {
        try {
            JacksonIntegration.class.getClassLoader().loadClass(name);
            return true;
        }
        catch (ClassNotFoundException | LinkageError e) {
            return false;
        }
    }
}

