/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree;

import jakarta.persistence.criteria.ParameterExpression;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.tree.AbstractSqmNode;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.jpa.ParameterCollector;

public abstract class AbstractSqmStatement<T>
extends AbstractSqmNode
implements SqmStatement<T>,
org.hibernate.query.sqm.internal.ParameterCollector {
    private final SqmQuerySource querySource;
    private Set<SqmParameter<?>> parameters;
    private int aliasCounter = 0;

    public AbstractSqmStatement(SqmQuerySource querySource, NodeBuilder builder) {
        super(builder);
        this.querySource = querySource;
    }

    protected AbstractSqmStatement(NodeBuilder builder, SqmQuerySource querySource, Set<SqmParameter<?>> parameters) {
        super(builder);
        this.querySource = querySource;
        this.parameters = parameters;
    }

    protected Set<SqmParameter<?>> copyParameters(SqmCopyContext context) {
        if (this.parameters == null) {
            return null;
        }
        HashSet parameters = new HashSet(this.parameters.size());
        for (SqmParameter<?> parameter : this.parameters) {
            parameters.add((SqmParameter<?>)parameter.copy(context));
        }
        return parameters;
    }

    @Override
    public SqmQuerySource getQuerySource() {
        return this.querySource;
    }

    @Override
    public void addParameter(SqmParameter<?> parameter) {
        if (this.parameters == null) {
            this.parameters = new HashSet();
        }
        this.parameters.add(parameter);
    }

    @Override
    public Set<SqmParameter<?>> getSqmParameters() {
        if (this.querySource == SqmQuerySource.CRITERIA) {
            assert (this.parameters == null) : "SqmSelectStatement (as Criteria) should not have collected parameters";
            return ParameterCollector.collectParameters(this);
        }
        return this.parameters == null ? Collections.emptySet() : Collections.unmodifiableSet(this.parameters);
    }

    @Override
    public SqmStatement.ParameterResolutions resolveParameters() {
        return SqmUtil.resolveParameters(this);
    }

    public Set<ParameterExpression<?>> getParameters() {
        assert (this.querySource == SqmQuerySource.CRITERIA);
        return SqmUtil.getParameters(this);
    }

    @Override
    public String generateAlias() {
        return "var_" + ++this.aliasCounter;
    }
}

