/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow.conditions;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.models.workflow.ResourceType;
import org.keycloak.models.workflow.WorkflowConditionProvider;
import org.keycloak.models.workflow.WorkflowEvent;
import org.keycloak.models.workflow.WorkflowInvalidStateException;

public class RoleWorkflowConditionProvider
implements WorkflowConditionProvider {
    private final List<String> expectedRoles;
    private final KeycloakSession session;

    public RoleWorkflowConditionProvider(KeycloakSession session, List<String> expectedRoles) {
        this.session = session;
        this.expectedRoles = expectedRoles;
    }

    public boolean evaluate(WorkflowEvent event) {
        if (!ResourceType.USERS.equals((Object)event.getResourceType())) {
            return false;
        }
        String userId = event.getResourceId();
        RealmModel realm = this.session.getContext().getRealm();
        UserModel user = this.session.users().getUserById(realm, userId);
        if (user == null) {
            return false;
        }
        Set roles = user.getRoleMappingsStream().collect(Collectors.toSet());
        for (String name : this.expectedRoles) {
            RoleModel expectedRole = this.getRole(name, realm);
            if (expectedRole != null && RoleUtils.hasRole(roles, (RoleModel)expectedRole)) continue;
            return false;
        }
        return true;
    }

    public void validate() throws WorkflowInvalidStateException {
        this.expectedRoles.forEach(id -> {
            if (this.session.roles().getRoleById(this.session.getContext().getRealm(), id) == null) {
                throw new WorkflowInvalidStateException(String.format("Role with id %s does not exist.", id));
            }
        });
    }

    private RoleModel getRole(String expectedRole, RealmModel realm) {
        boolean isClientRole;
        boolean bl = isClientRole = expectedRole.indexOf(47) != -1;
        if (isClientRole) {
            String[] parts = expectedRole.split("/");
            if (parts.length != 2) {
                return null;
            }
            String clientId = parts[0];
            String roleName = parts[1];
            ClientModel client = this.session.clients().getClientByClientId(realm, clientId);
            if (client == null) {
                return null;
            }
            return client.getRole(roleName);
        }
        return realm.getRole(expectedRole);
    }

    public void close() {
    }
}

