/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.message.AddRaftVoterResponseData;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.ReplicaKey;

public final class AddVoterHandlerState {
    private final ReplicaKey voterKey;
    private final Endpoints voterEndpoints;
    private final Timer timeout;
    private final CompletableFuture<AddRaftVoterResponseData> future = new CompletableFuture();
    private OptionalLong lastOffset = OptionalLong.empty();

    AddVoterHandlerState(ReplicaKey voterKey, Endpoints voterEndpoints, Timer timeout) {
        this.voterKey = voterKey;
        this.voterEndpoints = voterEndpoints;
        this.timeout = timeout;
    }

    public long timeUntilOperationExpiration(long currentTimeMs) {
        this.timeout.update(currentTimeMs);
        return this.timeout.remainingMs();
    }

    public boolean expectingApiResponse(int replicaId) {
        return this.lastOffset.isEmpty() && replicaId == this.voterKey.id();
    }

    public void setLastOffset(long lastOffset) {
        if (this.lastOffset.isPresent()) {
            throw new IllegalStateException(String.format("Cannot override last offset to %s for adding voter %s because it is already set to %s", lastOffset, this.voterKey, this.lastOffset));
        }
        this.lastOffset = OptionalLong.of(lastOffset);
    }

    public ReplicaKey voterKey() {
        return this.voterKey;
    }

    public Endpoints voterEndpoints() {
        return this.voterEndpoints;
    }

    public OptionalLong lastOffset() {
        return this.lastOffset;
    }

    public CompletableFuture<AddRaftVoterResponseData> future() {
        return this.future;
    }
}

