/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.clients.admin.ReplicaInfo;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.TerseException;

public class LogDirsCommand {
    public static void main(String ... args) {
        Exit.exit((int)LogDirsCommand.mainNoExit(args));
    }

    static int mainNoExit(String ... args) {
        try {
            LogDirsCommand.execute(args);
            return 0;
        }
        catch (TerseException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.err.println(Utils.stackTrace((Throwable)e));
            return 1;
        }
    }

    private static void execute(String ... args) throws Exception {
        LogDirsCommandOptions options = new LogDirsCommandOptions(args);
        try (Admin adminClient = LogDirsCommand.createAdminClient(options);){
            LogDirsCommand.execute(options, adminClient);
        }
    }

    static void execute(LogDirsCommandOptions options, Admin adminClient) throws Exception {
        Set<String> topics = options.topics();
        Set<Integer> clusterBrokers = ((Collection)adminClient.describeCluster().nodes().get()).stream().map(Node::id).collect(Collectors.toSet());
        Set<Integer> inputBrokers = options.brokers();
        HashSet<Integer> existingBrokers = inputBrokers.isEmpty() ? new HashSet<Integer>(clusterBrokers) : new HashSet<Integer>(inputBrokers);
        existingBrokers.retainAll(clusterBrokers);
        HashSet<Integer> nonExistingBrokers = new HashSet<Integer>(inputBrokers);
        nonExistingBrokers.removeAll(clusterBrokers);
        if (!nonExistingBrokers.isEmpty()) {
            throw new TerseException(String.format("ERROR: The given brokers do not exist from --broker-list: %s. Current existent brokers: %s", LogDirsCommand.commaDelimitedStringFromIntegerSet(nonExistingBrokers), LogDirsCommand.commaDelimitedStringFromIntegerSet(clusterBrokers)));
        }
        System.out.println("Querying brokers for log directories information");
        DescribeLogDirsResult describeLogDirsResult = adminClient.describeLogDirs(existingBrokers);
        Map logDirInfosByBroker = (Map)describeLogDirsResult.allDescriptions().get();
        System.out.printf("Received log directory information from brokers %s%n", LogDirsCommand.commaDelimitedStringFromIntegerSet(existingBrokers));
        System.out.println(LogDirsCommand.formatAsJson(logDirInfosByBroker, topics));
    }

    private static String commaDelimitedStringFromIntegerSet(Set<Integer> set) {
        return set.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    private static List<Map<String, Object>> fromReplicasInfoToPrintableRepresentation(Map<TopicPartition, ReplicaInfo> replicasInfo) {
        return replicasInfo.entrySet().stream().map(entry -> {
            final TopicPartition topicPartition = (TopicPartition)entry.getKey();
            return new HashMap<String, Object>(){
                {
                    this.put("partition", topicPartition.toString());
                    this.put("size", ((ReplicaInfo)entry.getValue()).size());
                    this.put("offsetLag", ((ReplicaInfo)entry.getValue()).offsetLag());
                    this.put("isFuture", ((ReplicaInfo)entry.getValue()).isFuture());
                }
            };
        }).collect(Collectors.toList());
    }

    private static List<Map<String, Object>> fromLogDirInfosToPrintableRepresentation(Map<String, LogDirDescription> logDirInfos, final Set<String> topicSet) {
        return logDirInfos.entrySet().stream().map(entry -> {
            final String logDir = (String)entry.getKey();
            return new HashMap<String, Object>(){
                {
                    this.put("logDir", logDir);
                    this.put("error", ((LogDirDescription)entry.getValue()).error() != null ? ((LogDirDescription)entry.getValue()).error().getClass().getName() : null);
                    this.put("partitions", LogDirsCommand.fromReplicasInfoToPrintableRepresentation(((LogDirDescription)entry.getValue()).replicaInfos().entrySet().stream().filter(entry -> {
                        TopicPartition topicPartition = (TopicPartition)entry.getKey();
                        return topicSet.isEmpty() || topicSet.contains(topicPartition.topic());
                    }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
                }
            };
        }).collect(Collectors.toList());
    }

    private static String formatAsJson(final Map<Integer, Map<String, LogDirDescription>> logDirInfosByBroker, final Set<String> topicSet) throws JsonProcessingException {
        return new ObjectMapper().writeValueAsString((Object)new HashMap<String, Object>(){
            {
                this.put("version", 1);
                this.put("brokers", logDirInfosByBroker.entrySet().stream().map(entry -> {
                    final int broker = (Integer)entry.getKey();
                    final Map logDirInfos = (Map)entry.getValue();
                    return new HashMap<String, Object>(){
                        {
                            this.put("broker", broker);
                            this.put("logDirs", LogDirsCommand.fromLogDirInfosToPrintableRepresentation(logDirInfos, topicSet));
                        }
                    };
                }).collect(Collectors.toList()));
            }
        });
    }

    private static Admin createAdminClient(LogDirsCommandOptions options) throws IOException {
        Properties props = new Properties();
        if (options.hasCommandConfig()) {
            props.putAll((Map<?, ?>)Utils.loadProps((String)options.commandConfig()));
        }
        props.put("bootstrap.servers", options.bootstrapServers());
        props.putIfAbsent("client.id", "log-dirs-tool");
        return Admin.create((Properties)props);
    }

    static class LogDirsCommandOptions
    extends CommandDefaultOptions {
        private final OptionSpec<String> bootstrapServerOpt;
        private final OptionSpec<String> commandConfigOpt;
        private final OptionSpecBuilder describeOpt;
        private final OptionSpec<String> topicListOpt;
        private final OptionSpec<String> brokerListOpt;

        public LogDirsCommandOptions(String ... args) {
            super(args);
            this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", "REQUIRED: the server(s) to use for bootstrapping").withRequiredArg().describedAs("The server(s) to use for bootstrapping").ofType(String.class);
            this.commandConfigOpt = this.parser.accepts("command-config", "Property file containing configs to be passed to Admin Client.").withRequiredArg().describedAs("Admin client property file").ofType(String.class);
            this.describeOpt = this.parser.accepts("describe", "Describe the specified log directories on the specified brokers.");
            this.topicListOpt = this.parser.accepts("topic-list", "The list of topics to be queried in the form \"topic1,topic2,topic3\". All topics will be queried if no topic list is specified").withRequiredArg().describedAs("Topic list").defaultsTo((Object)"", (Object[])new String[0]).ofType(String.class);
            this.brokerListOpt = this.parser.accepts("broker-list", "The list of brokers to be queried in the form \"0,1,2\". All brokers in the cluster will be queried if no broker list is specified").withRequiredArg().describedAs("Broker list").ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
            this.options = this.parser.parse(args);
            CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool helps to query log directory usage on the specified brokers.");
            CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.bootstrapServerOpt, this.describeOpt});
        }

        private Stream<String> splitAtCommasAndFilterOutEmpty(OptionSpec<String> option) {
            return Arrays.stream(((String)this.options.valueOf(option)).split(",")).filter(x -> !x.isEmpty());
        }

        private String bootstrapServers() {
            return (String)this.options.valueOf(this.bootstrapServerOpt);
        }

        private boolean hasCommandConfig() {
            return this.options.has(this.commandConfigOpt);
        }

        private String commandConfig() {
            return (String)this.options.valueOf(this.commandConfigOpt);
        }

        private Set<String> topics() {
            return this.splitAtCommasAndFilterOutEmpty(this.topicListOpt).collect(Collectors.toSet());
        }

        private Set<Integer> brokers() {
            return this.splitAtCommasAndFilterOutEmpty(this.brokerListOpt).map(Integer::valueOf).collect(Collectors.toSet());
        }
    }
}

