/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.juife.ComponentList;
import net.sf.juife.ComponentListModel;
import net.sf.juife.DefaultComponentListModel;
import org.jsampler.CC;
import org.jsampler.SamplerChannelModel;
import org.jsampler.view.JSChannel;
import org.jsampler.view.JSChannelsPane;
import org.jsampler.view.std.StdA4n;
import org.jsampler.view.std.StdMainFrame;

public abstract class StdChannelsPane
extends JSChannelsPane
implements ListSelectionListener {
    protected final ChannelList chnList = this.createChannelList();
    protected final ChannelListModel listModel = this.createChannelListModel();
    protected final JScrollPane scrollPane;
    private final Vector<ListSelectionListener> selListeners = new Vector();

    public StdChannelsPane(String string) {
        super(string);
        this.setLayout(new BorderLayout());
        this.chnList.setOpaque(false);
        this.chnList.setModel(this.listModel);
        this.chnList.setSelectionMode(2);
        this.scrollPane = new JScrollPane(this.chnList);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.scrollPane);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.installListeners();
    }

    protected void installListeners() {
        this.chnList.addListSelectionListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 9);
        this.getInputMap(1).put(keyStroke, "a4n.moveChannelsOnTop");
        this.getActionMap().put("a4n.moveChannelsOnTop", this.getA4n().moveChannelsOnTop);
        keyStroke = KeyStroke.getKeyStroke(38, 8);
        this.getInputMap(1).put(keyStroke, "a4n.moveChannelsUp");
        this.getActionMap().put("a4n.moveChannelsUp", this.getA4n().moveChannelsUp);
        keyStroke = KeyStroke.getKeyStroke(40, 8);
        this.getInputMap(1).put(keyStroke, "a4n.moveChannelsDown");
        this.getActionMap().put("a4n.moveChannelsDown", this.getA4n().moveChannelsDown);
        keyStroke = KeyStroke.getKeyStroke(40, 9);
        this.getInputMap(1).put(keyStroke, "a4n.moveChannelsAtBottom");
        this.getActionMap().put("a4n.moveChannelsAtBottom", this.getA4n().moveChannelsAtBottom);
    }

    public StdA4n getA4n() {
        return ((StdMainFrame)CC.getMainFrame()).getA4n();
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selListeners.add(listSelectionListener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selListeners.remove(listSelectionListener);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionEvent listSelectionEvent2 = null;
        for (ListSelectionListener listSelectionListener : this.selListeners) {
            if (listSelectionEvent2 == null) {
                listSelectionEvent2 = new ListSelectionEvent(this, listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting());
            }
            listSelectionListener.valueChanged(listSelectionEvent2);
        }
    }

    protected ChannelList createChannelList() {
        return new ChannelList();
    }

    protected ChannelListModel createChannelListModel() {
        return new ChannelListModel();
    }

    @Override
    public void setSelectedChannel(JSChannel jSChannel) {
        this.chnList.setSelectedComponent(jSChannel, true);
    }

    @Override
    public void addChannel(SamplerChannelModel samplerChannelModel) {
        JSChannel jSChannel = this.createChannel(samplerChannelModel);
        this.listModel.add(jSChannel);
        this.chnList.setSelectedComponent(jSChannel, true);
        this.scrollToBottom();
    }

    protected abstract JSChannel createChannel(SamplerChannelModel var1);

    @Override
    public void addChannels(JSChannel[] jSChannelArray) {
        if (jSChannelArray == null || jSChannelArray.length == 0) {
            return;
        }
        for (JSChannel jSChannel : jSChannelArray) {
            this.listModel.add(jSChannel);
        }
        this.chnList.setSelectionInterval(this.listModel.getSize() - jSChannelArray.length, this.listModel.getSize() - 1);
        this.chnList.ensureIndexIsVisible(this.listModel.getSize() - 1);
    }

    @Override
    public void removeChannel(JSChannel jSChannel) {
        this.listModel.remove(jSChannel);
    }

    @Override
    public JSChannel getFirstChannel() {
        return this.listModel.size() == 0 ? null : (JSChannel)this.listModel.get(0);
    }

    @Override
    public JSChannel getLastChannel() {
        return this.listModel.size() == 0 ? null : (JSChannel)this.listModel.get(this.listModel.size() - 1);
    }

    @Override
    public JSChannel getChannel(int n) {
        return (JSChannel)this.listModel.get(n);
    }

    @Override
    public JSChannel[] getChannels() {
        JSChannel[] jSChannelArray = new JSChannel[this.listModel.size()];
        for (int i = 0; i < this.listModel.size(); ++i) {
            jSChannelArray[i] = (JSChannel)this.listModel.get(i);
        }
        return jSChannelArray;
    }

    @Override
    public int getChannelCount() {
        return this.listModel.size();
    }

    @Override
    public boolean hasSelectedChannel() {
        return !this.chnList.isSelectionEmpty();
    }

    @Override
    public int getSelectedChannelCount() {
        return this.chnList.getSelectedIndices().length;
    }

    @Override
    public JSChannel[] getSelectedChannels() {
        Component[] componentArray = this.chnList.getSelectedComponents();
        JSChannel[] jSChannelArray = new JSChannel[componentArray.length];
        for (int i = 0; i < componentArray.length; ++i) {
            jSChannelArray[i] = (JSChannel)componentArray[i];
        }
        return jSChannelArray;
    }

    @Override
    public int removeSelectedChannels() {
        int n;
        int[] nArray = this.chnList.getSelectedIndices();
        ComponentListModel componentListModel = this.chnList.getModel();
        while ((n = this.chnList.getMinSelectionIndex()) != -1) {
            componentListModel.remove(n);
        }
        return nArray.length;
    }

    @Override
    public void selectAll() {
        this.chnList.selectAll();
    }

    @Override
    public void clearSelection() {
        this.chnList.clearSelection();
    }

    @Override
    public boolean getAutoUpdate() {
        return this.chnList.getAutoUpdate();
    }

    @Override
    public void setAutoUpdate(boolean bl) {
        this.chnList.setAutoUpdate(bl);
    }

    @Override
    public void updateChannelListUI() {
        this.chnList.updateList();
    }

    @Override
    public void moveSelectedChannelsOnTop() {
        JSChannel[] jSChannelArray = this.getSelectedChannels();
        if (jSChannelArray.length == 0) {
            CC.getLogger().info("Can't move channel(s) at the beginning");
            return;
        }
        for (int i = jSChannelArray.length - 1; i >= 0; --i) {
            this.listModel.remove(jSChannelArray[i]);
            this.listModel.insert(jSChannelArray[i], 0);
        }
        this.chnList.setSelectionInterval(0, jSChannelArray.length - 1);
        this.chnList.ensureIndexIsVisible(0);
    }

    @Override
    public void moveSelectedChannelsUp() {
        JSChannel[] jSChannelArray = this.getSelectedChannels();
        if (jSChannelArray.length == 0 || jSChannelArray[0] == this.getFirstChannel()) {
            CC.getLogger().info("Can't move channel(s) up");
            return;
        }
        for (int i = 0; i < jSChannelArray.length; ++i) {
            this.listModel.moveUp(jSChannelArray[i]);
        }
        int[] nArray = this.chnList.getSelectedIndices();
        int n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] - 1;
        }
        this.chnList.setSelectedIndices(nArray);
        this.chnList.ensureIndexIsVisible(nArray[0]);
    }

    @Override
    public void moveSelectedChannelsDown() {
        JSChannel[] jSChannelArray = this.getSelectedChannels();
        if (jSChannelArray.length == 0 || jSChannelArray[jSChannelArray.length - 1] == this.getLastChannel()) {
            CC.getLogger().info("Can't move channel(s) down");
            return;
        }
        for (int i = jSChannelArray.length - 1; i >= 0; --i) {
            this.listModel.moveDown(jSChannelArray[i]);
        }
        int[] nArray = this.chnList.getSelectedIndices();
        int n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] + 1;
        }
        this.chnList.setSelectedIndices(nArray);
        this.chnList.ensureIndexIsVisible(nArray[nArray.length - 1]);
    }

    @Override
    public void moveSelectedChannelsAtBottom() {
        JSChannel[] jSChannelArray = this.getSelectedChannels();
        if (jSChannelArray.length == 0) {
            CC.getLogger().info("Can't move channel(s) at the end");
            return;
        }
        for (int i = 0; i < jSChannelArray.length; ++i) {
            this.listModel.remove(jSChannelArray[i]);
            this.listModel.add(jSChannelArray[i]);
        }
        this.chnList.setSelectionInterval(this.listModel.getSize() - jSChannelArray.length, this.listModel.getSize() - 1);
        this.chnList.ensureIndexIsVisible(this.listModel.getSize() - 1);
    }

    @Override
    public void processChannelSelection(JSChannel jSChannel, boolean bl, boolean bl2) {
        if (jSChannel.isSelected() && !bl && !bl2) {
            return;
        }
        this.chnList.getUI().processSelectionEvent(jSChannel, bl, bl2);
    }

    private void scrollToBottom() {
        int n = this.scrollPane.getViewport().getView().getHeight();
        this.scrollPane.getViewport().scrollRectToVisible(new Rectangle(0, n - 2, 1, 1));
    }

    protected static class ChannelListModel
    extends DefaultComponentListModel<JSChannel> {
        protected ChannelListModel() {
        }
    }

    protected static class ChannelList
    extends ComponentList {
        protected ChannelList() {
        }
    }
}

