/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SubjectName;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509SubjectNameResolver
extends KeyResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(X509SubjectNameResolver.class);

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineLookupResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        LOG.debug("Can I resolve {}?", element.getTagName());
        Element[] elementArray = null;
        XMLX509SubjectName[] xMLX509SubjectNameArray = null;
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            LOG.debug("I can't");
            return null;
        }
        elementArray = XMLUtils.selectDsNodes(element.getFirstChild(), "X509SubjectName");
        if (elementArray == null || elementArray.length <= 0) {
            LOG.debug("I can't");
            return null;
        }
        try {
            if (storageResolver == null) {
                Object[] objectArray = new Object[]{"X509SubjectName"};
                KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
                LOG.debug("", keyResolverException);
                throw keyResolverException;
            }
            xMLX509SubjectNameArray = new XMLX509SubjectName[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                xMLX509SubjectNameArray[i] = new XMLX509SubjectName(elementArray[i], string);
            }
            Iterator<Certificate> iterator = storageResolver.getIterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                XMLX509SubjectName xMLX509SubjectName = new XMLX509SubjectName(element.getOwnerDocument(), x509Certificate);
                LOG.debug("Found Certificate SN: {}", xMLX509SubjectName.getSubjectName());
                for (int i = 0; i < xMLX509SubjectNameArray.length; ++i) {
                    LOG.debug("Found Element SN:     {}", xMLX509SubjectNameArray[i].getSubjectName());
                    if (xMLX509SubjectName.equals(xMLX509SubjectNameArray[i])) {
                        LOG.debug("match !!! ");
                        return x509Certificate;
                    }
                    LOG.debug("no match...");
                }
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.debug("XMLSecurityException", xMLSecurityException);
            throw new KeyResolverException(xMLSecurityException);
        }
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }
}

