/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javajs.api.GenericColor;
import javajs.util.CU;
import javajs.util.Lst;
import jspecview.api.JSVPanel;
import jspecview.common.PanelData;
import jspecview.common.Parameters;
import jspecview.common.ScriptToken;

public abstract class ColorParameters
extends Parameters {
    public String titleFontName;
    public String displayFontName;
    public Map<ScriptToken, GenericColor> elementColors;
    public GenericColor[] plotColors;
    public boolean isDefault;
    public static GenericColor BLACK;
    public static GenericColor RED;
    public static GenericColor LIGHT_GRAY;
    public static GenericColor DARK_GRAY;
    public static GenericColor BLUE;
    public static GenericColor WHITE;
    public static final GenericColor[] defaultPlotColors;
    public static final String[] defaultPlotColorNames;

    static {
        defaultPlotColors = new GenericColor[8];
        defaultPlotColorNames = new String[]{"black", "darkGreen", "darkred", "orange", "magenta", "cyan", "maroon", "darkGray"};
    }

    protected abstract GenericColor getColor3(int var1, int var2, int var3);

    protected abstract GenericColor getColor1(int var1);

    protected abstract boolean isValidFontName(String var1);

    public ColorParameters() {
        BLACK = this.getColor3(0, 0, 0);
        RED = this.getColor3(255, 0, 0);
        LIGHT_GRAY = this.getColor3(200, 200, 200);
        DARK_GRAY = this.getColor3(80, 80, 80);
        BLUE = this.getColor3(0, 0, 255);
        WHITE = this.getColor3(255, 255, 255);
        this.elementColors = new Hashtable<ScriptToken, GenericColor>();
        this.setColor(ScriptToken.TITLECOLOR, BLACK);
        this.setColor(ScriptToken.UNITSCOLOR, RED);
        this.setColor(ScriptToken.SCALECOLOR, BLACK);
        this.setColor(ScriptToken.COORDINATESCOLOR, RED);
        this.setColor(ScriptToken.GRIDCOLOR, LIGHT_GRAY);
        this.setColor(ScriptToken.PLOTCOLOR, BLUE);
        this.setColor(ScriptToken.PLOTAREACOLOR, WHITE);
        this.setColor(ScriptToken.BACKGROUNDCOLOR, this.getColor3(192, 192, 192));
        this.setColor(ScriptToken.INTEGRALPLOTCOLOR, RED);
        this.setColor(ScriptToken.PEAKTABCOLOR, RED);
        this.setColor(ScriptToken.PEAKOVERCOLOR, RED);
        this.setColor(ScriptToken.HIGHLIGHTCOLOR, DARK_GRAY);
        int n = 0;
        while (n < 8) {
            ColorParameters.defaultPlotColors[n] = this.getColorFromString(defaultPlotColorNames[n]);
            ++n;
        }
        this.plotColors = new GenericColor[8];
        System.arraycopy(defaultPlotColors, 0, this.plotColors, 0, 8);
    }

    public void setFor(JSVPanel jSVPanel, ColorParameters colorParameters, boolean bl) {
        PanelData panelData;
        if (colorParameters == null) {
            colorParameters = this;
        }
        if (bl) {
            jSVPanel.getPanelData().setBooleans(colorParameters, null);
        }
        if ((panelData = jSVPanel.getPanelData()).getCurrentPlotColor(1) != null) {
            panelData.setPlotColors(this.plotColors);
        }
        panelData.setColorOrFont(colorParameters, null);
    }

    public void set(PanelData panelData, ScriptToken scriptToken, String string) {
        Object object = null;
        switch (scriptToken) {
            default: {
                this.setP(panelData, scriptToken, string);
                return;
            }
            case PLOTCOLORS: {
                if (panelData == null) {
                    this.getPlotColors(string);
                } else {
                    panelData.setPlotColors(this.getPlotColors(string));
                }
                return;
            }
            case BACKGROUNDCOLOR: 
            case COORDINATESCOLOR: 
            case GRIDCOLOR: 
            case HIGHLIGHTCOLOR: 
            case INTEGRALPLOTCOLOR: 
            case PEAKOVERCOLOR: 
            case PEAKTABCOLOR: 
            case PLOTAREACOLOR: 
            case PLOTCOLOR: 
            case SCALECOLOR: 
            case TITLECOLOR: 
            case UNITSCOLOR: {
                object = this.setColorFromString(scriptToken, string);
                break;
            }
            case DISPLAYFONTNAME: 
            case TITLEFONTNAME: {
                object = this.getFontName(scriptToken, string);
            }
        }
        if (panelData == null) {
            return;
        }
        if (object != null) {
            panelData.setColorOrFont(this, scriptToken);
        }
    }

    public GenericColor getElementColor(ScriptToken scriptToken) {
        return this.elementColors.get((Object)scriptToken);
    }

    public GenericColor setColor(ScriptToken scriptToken, GenericColor genericColor) {
        if (genericColor != null) {
            this.elementColors.put(scriptToken, genericColor);
        }
        return genericColor;
    }

    public abstract ColorParameters copy(String var1);

    public ColorParameters copy() {
        return this.copy(this.name);
    }

    public ColorParameters setElementColors(ColorParameters colorParameters) {
        this.displayFontName = colorParameters.displayFontName;
        for (Map.Entry<ScriptToken, GenericColor> entry : colorParameters.elementColors.entrySet()) {
            this.setColor(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public GenericColor getColorFromString(String string) {
        return this.getColor1(CU.getArgbFromString(string));
    }

    protected GenericColor[] getPlotColors(String string) {
        if (string == null) {
            this.plotColors[0] = this.getElementColor(ScriptToken.PLOTCOLOR);
            return this.plotColors;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;.- ");
        Lst<GenericColor> lst = new Lst<GenericColor>();
        try {
            while (stringTokenizer.hasMoreTokens()) {
                lst.addLast(this.getColorFromString(stringTokenizer.nextToken()));
            }
        }
        catch (Exception exception) {
            return null;
        }
        return lst.toArray(new GenericColor[lst.size()]);
    }

    protected GenericColor setColorFromString(ScriptToken scriptToken, String string) {
        return this.setColor(scriptToken, this.getColorFromString(string));
    }

    public String getFontName(ScriptToken scriptToken, String string) {
        boolean bl = this.isValidFontName(string);
        switch (scriptToken) {
            case TITLEFONTNAME: {
                return bl ? (this.titleFontName = string) : this.titleFontName;
            }
            case DISPLAYFONTNAME: {
                return bl ? (this.displayFontName = string) : this.displayFontName;
            }
        }
        return null;
    }
}

