/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.common.utils;

public class Converter {
    public static byte[] intToByteArray(int intBits) {
        byte[] ret = new byte[]{(byte)((intBits & 0xFF000000) >> 24), (byte)((intBits & 0xFF0000) >> 16), (byte)((intBits & 0xFF00) >> 8), (byte)((intBits & 0xFF) >> 0)};
        return ret;
    }

    public static void intToByteArray(byte[] data, int i, int idata) {
        data[i++] = (byte)((idata & 0xFF000000) >> 24);
        data[i++] = (byte)((idata & 0xFF0000) >> 16);
        data[i++] = (byte)((idata & 0xFF00) >> 8);
        data[i] = (byte)((idata & 0xFF) >> 0);
    }

    public static int byteArrayToInt(byte[] b) {
        return b[0] << 24 & 0xFF000000 | b[1] << 16 & 0xFF0000 | b[2] << 8 & 0xFF00 | b[3] & 0xFF;
    }

    public static int byteArrayToInt(byte[] b, int i) {
        return b[i++] << 24 & 0xFF000000 | b[i++] << 16 & 0xFF0000 | b[i++] << 8 & 0xFF00 | b[i] & 0xFF;
    }

    public static void floatToByteArray(byte[] data, int i, float fdata) {
        Converter.intToByteArray(data, i, Float.floatToIntBits(fdata));
    }

    public static float byteArrayToFloat(byte[] data, int i) {
        return Float.intBitsToFloat(Converter.byteArrayToInt(data, i));
    }

    public static void longToByteArray(byte[] data, int i, long ldata) {
        Converter.intToByteArray(data, i, (int)(ldata >> 32));
        Converter.intToByteArray(data, i + 4, (int)(ldata & 0xFFFFFFFFFFFFFFFFL));
    }

    public static long byteArrayToLong(byte[] data, int i) {
        return (long)Converter.byteArrayToInt(data, i) << 32 | (long)Converter.byteArrayToInt(data, i + 4) & 0xFFFFFFFFL;
    }

    public static String byteArrayToString(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)bytes[i];
        }
        return new String(chars);
    }

    public static byte[] stringToByteArray(String s) {
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[s.length()];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }
}

