#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 turtle
version:              1.6.2
visibility:           public
id:                   turtle-1.6.2-KG47YR7OLwJ9qrxoVNknp8
key:                  turtle-1.6.2-KG47YR7OLwJ9qrxoVNknp8
license:              BSD-3-Clause
copyright:            2015 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             Shell programming, Haskell-style
description:
    @turtle@ is a reimplementation of the Unix command line environment
    in Haskell so that you can use Haskell as both a shell and a scripting
    language.

    Features include:

    * Batteries included: Command an extended suite of predefined utilities

    * Interoperability: You can still run external shell commands

    * Portability: Works on Windows, OS X, and Linux

    * Exception safety: Safely acquire and release resources

    * Streaming: Transform or fold command output in constant space

    * Patterns: Use typed regular expressions that can parse structured values

    * Formatting: Type-safe @printf@-style text formatting

    * Modern: Supports @text@

    Read "Turtle.Tutorial" for a detailed tutorial or "Turtle.Prelude" for a
    quick-start guide

    @turtle@ is designed to be beginner-friendly, but as a result lacks certain
    features, like tracing commands.  If you feel comfortable using @turtle@
    then you should also check out the @Shelly@ library which provides similar
    functionality.

category:             System
abi:                  c3edeb4ecebe61b885cc8801f8014c1c
exposed:              True
exposed-modules:
    Turtle Turtle.Bytes Turtle.Format Turtle.Line Turtle.Options
    Turtle.Pattern Turtle.Prelude Turtle.Shell Turtle.Tutorial

hidden-modules:       Turtle.Internal
import-dirs:          /usr/lib/ghc-9.6.6/site-local/turtle-1.6.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/turtle-1.6.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/turtle-1.6.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-turtle
hs-libraries:         HSturtle-1.6.2-KG47YR7OLwJ9qrxoVNknp8
depends:
    ansi-wl-pprint-1.0.2-DTFkkr6LOud89Oh0XZBo7
    async-2.2.5-Dr6zhmAeBY8Cjr8itA5Fpz base-4.18.2.1
    bytestring-0.11.5.3 clock-0.8.4-oevERM2EIX4JegqXXRdhr
    containers-0.6.7 directory-1.3.8.5 exceptions-0.10.7
    filepath-1.4.300.1 foldl-1.4.18-CE94uBtURj91v7TyGtwGtD
    hostname-1.0-EOhxbdAArOFEFh3i6bjNP6
    managed-1.0.11-2Pnugu46RECJRycwImdLZr
    optional-args-1.0.2-F0xejbU8T85GOpMOmS9nLh
    optparse-applicative-0.18.1.0-LPpsyWWBTB8DZOwBIqw3J0
    process-1.6.19.0 stm-2.5.1.0
    streaming-commons-0.2.3.1-8yhGLkSaB883l0CzfMtPoA
    temporary-1.3-BelDM7zTWCg7tBff187Pbn text-2.0.2 time-1.12.2
    transformers-0.6.1.0 unix-2.8.4.0
    unix-compat-0.7.4.1-7Zyia4XRlOQIIQMyLxI1QD

haddock-interfaces:   /usr/share/doc/haskell-turtle/html/turtle.haddock
haddock-html:         /usr/share/doc/haskell-turtle/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

