/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save.xml;

import java.util.ArrayList;
import java.util.HashSet;
import tim.prune.data.ExtensionInfo;
import tim.prune.data.FileType;
import tim.prune.data.SourceInfo;
import tim.prune.save.xml.GpxVersion;

public class HeaderCombiner {
    private final GpxVersion _targetVersion;
    private final GpxVersion _ignoreVersion;
    private boolean _foundLocations = false;
    private final ArrayList<String> _namespaces = new ArrayList();
    private final HashSet<String> _namespaceKeys = new HashSet();
    private final ArrayList<String> _locationPairs = new ArrayList();

    HeaderCombiner(GpxVersion gpxVersion) {
        this._targetVersion = gpxVersion;
        this._ignoreVersion = gpxVersion == GpxVersion.GPX_1_0 ? GpxVersion.GPX_1_1 : GpxVersion.GPX_1_0;
    }

    void addSourceInfo(SourceInfo sourceInfo) {
        if (sourceInfo == null || sourceInfo.getFileType() != FileType.GPX) {
            return;
        }
        ExtensionInfo extensionInfo = sourceInfo.getExtensionInfo();
        if (extensionInfo == null) {
            return;
        }
        for (String stringArray2 : extensionInfo.getExtraNamespaces()) {
            this.addNamespace(stringArray2);
        }
        String[] stringArray = extensionInfo.getSchemaLocations().split(" ");
        int n = stringArray.length / 2;
        int n2 = 0;
        while (n2 < n) {
            this.addLocationPair(stringArray[n2 * 2], stringArray[n2 * 2 + 1]);
            ++n2;
        }
    }

    private void addNamespace(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        String string2 = HeaderCombiner.getAttributeKey(string).toLowerCase();
        if (this._namespaceKeys.contains(string2)) {
            return;
        }
        this._namespaceKeys.add(string2);
        this._namespaces.add(string);
    }

    private static String getAttributeKey(String string) {
        int n = string.indexOf(61);
        if (n <= 0) {
            return string;
        }
        return string.substring(0, n).trim();
    }

    private void addLocationPair(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        if (this._ignoreVersion.matches(string) && this._ignoreVersion.matches(string2)) {
            return;
        }
        if (this._targetVersion.matches(string) && this._targetVersion.matches(string2)) {
            if (this._foundLocations) {
                return;
            }
            this._foundLocations = true;
        }
        String string3 = String.valueOf(string) + " " + string2;
        for (String string4 : this._locationPairs) {
            if (!string4.equalsIgnoreCase(string3)) continue;
            return;
        }
        this._locationPairs.add(string3);
    }

    String getAllLocations(String string) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = bl = !this._foundLocations;
        if (!this._foundLocations) {
            stringBuilder.append(string);
        }
        for (String string2 : this._locationPairs) {
            if (bl) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string2);
            bl = true;
        }
        return stringBuilder.toString();
    }

    String getNamespaces() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this._namespaces) {
            stringBuilder.append(' ').append(string).append('\n');
        }
        return stringBuilder.toString();
    }
}

