/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ExtensionInfo {
    private String _namespace = null;
    private String _xsi = null;
    private final ArrayList<Extension> _extensions = new ArrayList();
    private final HashMap<String, String> _xsdLinks = new HashMap();
    private String _identifier = null;

    public void setNamespace(String string) {
        this._namespace = string;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public void setXsi(String string) {
        this._xsi = string;
    }

    public String getXsi() {
        return this._xsi;
    }

    public void addNamespace(String string, String string2) {
        this._extensions.add(new Extension(string, string2));
    }

    public void addXsiAttribute(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (this._identifier == null) {
            this._identifier = string;
        } else {
            this._xsdLinks.put(this._identifier, string);
            this._identifier = null;
        }
    }

    public List<String> getExtensions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Extension extension : this._extensions) {
            arrayList.add(extension._identifier);
        }
        return arrayList;
    }

    public List<String> getExtraNamespaces() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Extension extension : this._extensions) {
            arrayList.add("xmlns:" + extension._prefix + "=\"" + extension._identifier + "\"");
        }
        return arrayList;
    }

    public String getSchemaLocations() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._namespace).append(' ').append(this._xsdLinks.getOrDefault(this._namespace, ""));
        for (Extension extension : this._extensions) {
            stringBuilder.append(' ').append(extension._identifier).append(' ').append(this._xsdLinks.getOrDefault(extension._identifier, ""));
        }
        return stringBuilder.toString();
    }

    public String getNamespaceName(String string) {
        for (Extension extension : this._extensions) {
            int n;
            int n2;
            if (!extension._prefix.equals(string) || (n2 = extension._identifier.lastIndexOf(47)) <= 0 || "Vv".indexOf(extension._identifier.charAt(n2 + 1)) < 0 || (n = extension._identifier.lastIndexOf(47, n2 - 1)) <= 0) continue;
            return extension._identifier.substring(n + 1, n2);
        }
        return null;
    }

    private static class Extension {
        private final String _prefix;
        private final String _identifier;

        private Extension(String string, String string2) {
            this._prefix = string;
            this._identifier = string2;
        }
    }
}

