// Copyright 2024 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package mlkem

import (
	"bytes"
	"crypto/internal/fips140"
	_ "crypto/internal/fips140/check"
	"errors"
	"sync"
)

var fipsSelfTest = sync.OnceFunc(func() {
	fips140.CAST("ML-KEM-768", func() error {
		var d = &[32]byte{
			0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
			0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10,
			0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,
			0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20,
		}
		var z = &[32]byte{
			0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
			0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30,
			0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
			0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
		}
		var m = &[32]byte{
			0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
			0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
			0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
			0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60,
		}
		var K = []byte{
			0x55, 0x01, 0xfc, 0x52, 0x3b, 0x74, 0x5f, 0x41,
			0x76, 0x2a, 0x18, 0x8d, 0xe4, 0x4a, 0x59, 0xb9,
			0x20, 0xf4, 0x30, 0x14, 0x62, 0x04, 0xee, 0x4e,
			0x79, 0x37, 0x32, 0x39, 0x6d, 0xf7, 0xaa, 0x48,
		}
		dk := &DecapsulationKey768{}
		kemKeyGen(dk, d, z)
		ek := dk.EncapsulationKey()
		var cc [CiphertextSize768]byte
		Ke, _ := kemEncaps(&cc, ek, m)
		Kd := kemDecaps(dk, &cc)
		if !bytes.Equal(Ke, K) || !bytes.Equal(Kd, K) {
			return errors.New("unexpected result")
		}
		return nil
	})
})
