#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-4YJR2wOJ94KHmyIzNTY8fK
key:                  gitit-0.15.1.2-4YJR2wOJ94KHmyIzNTY8fK
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  fb36193ae866fcb14318641f636b81bd
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-4YJR2wOJ94KHmyIzNTY8fK
depends:
    HStringTemplate-0.8.8-9behxpkZXn8LFPjoDdtPnz
    HTTP-4000.4.1-B6UtN3UzBeCKl7E8Anf8ev
    SHA-1.6.4.4-KRZJCS52poaHfqPlW5b8Sg
    aeson-2.2.0.0-A8FqDK4tVym6hhqwC7qXFC base-4.18.2.1
    base64-bytestring-1.2.1.0-4EosDDg3uRjHJpFgdqYthW
    blaze-html-0.9.2.0-ewkcMpB7hX5zM6Snyh7uM bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.8.5
    doctemplates-0.11.0.1-2Fim94YnLAFLLALdK4lyc5
    feed-1.3.2.1-53B9CTGy2QG7WnbB5Tz7b9 filepath-1.4.300.1
    filestore-0.6.5.1-A5QAzUFPn9KcHjhzFt3Qz ghc-9.6.6
    ghc-paths-0.1.0.12-JSGGj7CcxjZ2Iy0LlOG5cZ
    happstack-server-7.9.3-Jd1XzGjtuUH1TVXzxwX5e0
    hoauth2-2.14.0-JgAR73NIhlNEQuizV7mZed
    hslogger-1.3.2.0-FPaqfjIzB5mGOypIyafcGO
    http-client-tls-0.3.6.4-4YjTfjzKPdw6FEP2jTEQj6
    http-conduit-2.3.9.1-57yzL8oP4Ah4AluL2Fro4B
    json-0.10-CVmt8wAUbKLCRDBxbUg8QP mtl-2.3.1
    network-3.1.4.0-6jdgASXXSsi4c1a8fEUR94
    network-bsd-2.8.1.0-92IUEbACI247pUkdiS71U6
    network-uri-2.6.4.2-EsX0tHV5l49AhOs5hDRDmc
    old-locale-1.0.0.7-Gunit3UBy5P9OGDVFY5MhC
    old-time-1.1.0.4-3lD0LwNFkdkGhWCMuxpBlx
    pandoc-3.5-fzlJehhWcJ6qiK70cbsZP
    pandoc-types-1.23.1-LHR17fUml6w2xW8t1HX0Mt parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.19.0
    random-1.2.1.3-AWgDTzXDap9FswiKSbxZwj
    recaptcha-0.1.0.4-Cf6Aesp5wfz4cTW7EubVlK
    safe-0.3.21-Jx1j9PonLpAIXmir4WvZhd
    skylighting-0.14.3-5yw6nITdiTV2alziaFZxxq
    split-0.2.5-3RnrRTIeHLc8NBcVaUtFqR syb-0.7.3-MvqtDDcT2PHyhdKWhEKAp
    tagsoup-0.14.8-2NXsb3LWG4Z81LVImxuUXv
    temporary-1.3-BelDM7zTWCg7tBff187Pbn text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-AHOKB1FBy7T1YX0aVKrKP9
    url-2.1.3-7Kl4E3eXP9D927NfHGnLmQ
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1
    uuid-1.3.16-HGMDGw8FyFAETCFhwRGpW9 xhtml-3000.2.2.1
    xml-1.3.14-3CsuYrgQlhu1X5fBOwcswt
    xml-conduit-1.9.1.4-BVaGJKEwQXR8LvQ5Iu3Yxe
    xml-types-0.3.8-ISf6rjkeTjSFXsXdIGBwau
    xss-sanitize-0.3.7.2-7MlUtBtRnOgE6Fa5P0uUaK
    zlib-0.7.0.0-CUQPV7mqGBqDSb96O4x8X5

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

