# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_git_smash_global_optspecs
	string join \n list select format= n/max-count= a/all l/local rebase no-rebase i/interactive blame no-blame files no-files recent= range= amend reword h/help V/version
end

function __fish_git_smash_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_git_smash_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_git_smash_using_subcommand
	set -l cmd (__fish_git_smash_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c git-smash -n "__fish_git_smash_needs_command" -l format -d 'Git log format to pretty print the targets' -r
complete -c git-smash -n "__fish_git_smash_needs_command" -s n -l max-count -d 'Limit number of listed commits (0 for unlimited stream)' -r
complete -c git-smash -n "__fish_git_smash_needs_command" -l recent -d 'List commits acquired from recent history (default 0)' -r
complete -c git-smash -n "__fish_git_smash_needs_command" -l range -d 'Limit the listed commits to the given range' -r
complete -c git-smash -n "__fish_git_smash_needs_command" -l list -d 'List mode to print all potential targets to stdout'
complete -c git-smash -n "__fish_git_smash_needs_command" -l select -d 'Select mode to print final target to stdout'
complete -c git-smash -n "__fish_git_smash_needs_command" -s a -l all -d 'List all revs including already published commits'
complete -c git-smash -n "__fish_git_smash_needs_command" -s l -l local -d 'Limit the listed revs to local commits'
complete -c git-smash -n "__fish_git_smash_needs_command" -l rebase -d 'Rebase the fixup commit into the target'
complete -c git-smash -n "__fish_git_smash_needs_command" -l no-rebase -d 'Do not rebase the fixup commit into the target'
complete -c git-smash -n "__fish_git_smash_needs_command" -s i -l interactive -d 'Let the user edit the list of commits before rebasing'
complete -c git-smash -n "__fish_git_smash_needs_command" -l blame -d 'List commits acquired from blame chunks'
complete -c git-smash -n "__fish_git_smash_needs_command" -l no-blame -d 'Do not list commits acquired from blame chunks'
complete -c git-smash -n "__fish_git_smash_needs_command" -l files -d 'List commits acquired from history of changed files'
complete -c git-smash -n "__fish_git_smash_needs_command" -l no-files -d 'Do not list commits acquired from history of changed files'
complete -c git-smash -n "__fish_git_smash_needs_command" -l amend -d 'Smash staged changes and refine the log message'
complete -c git-smash -n "__fish_git_smash_needs_command" -l reword -d 'Refine the log message ignoring all staged changes'
complete -c git-smash -n "__fish_git_smash_needs_command" -s h -l help -d 'Print help'
complete -c git-smash -n "__fish_git_smash_needs_command" -s V -l version -d 'Print version'
complete -c git-smash -n "__fish_git_smash_needs_command" -a "completions" -d 'Generate shell completions'
complete -c git-smash -n "__fish_git_smash_needs_command" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c git-smash -n "__fish_git_smash_using_subcommand completions" -s h -l help -d 'Print help'
complete -c git-smash -n "__fish_git_smash_using_subcommand completions" -s V -l version -d 'Print version'
complete -c git-smash -n "__fish_git_smash_using_subcommand help; and not __fish_seen_subcommand_from completions help" -f -a "completions" -d 'Generate shell completions'
complete -c git-smash -n "__fish_git_smash_using_subcommand help; and not __fish_seen_subcommand_from completions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
