/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import javax.swing.JScrollPane;
import org.freeplane.view.swing.map.outline.BreadcrumbMode;
import org.freeplane.view.swing.map.outline.OutlineActionTarget;
import org.freeplane.view.swing.map.outline.ScrollableTreePanel;
import org.freeplane.view.swing.map.outline.TreeNode;

class OutlineController
implements OutlineActionTarget {
    private final ScrollableTreePanel treePanel;
    private final JScrollPane scrollPane;

    OutlineController(ScrollableTreePanel treePanel, JScrollPane scrollPane) {
        this.treePanel = treePanel;
        this.scrollPane = scrollPane;
    }

    int getRowHeight() {
        return this.treePanel.getRowHeight();
    }

    int getViewportWidth() {
        return this.treePanel.getViewportWidth();
    }

    int calcTextButtonX(int level) {
        return this.treePanel.calcTextButtonX(level);
    }

    BreadcrumbMode getBreadcrumbMode() {
        return this.treePanel.getBreadcrumbMode();
    }

    void toggleBreadcrumbNodeExpansion(TreeNode node) {
        this.treePanel.toggleBreadcrumbNodeExpansion(node, true);
    }

    @Override
    public void toggleExpandSelected() {
        this.treePanel.toggleExpandSelected();
    }

    @Override
    public void selectSelectedInMap() {
        this.treePanel.selectSelectedInMap();
    }

    void selectNode(TreeNode node, boolean requestFocus) {
        if (node == null) {
            return;
        }
        this.treePanel.setSelectedNode(node, requestFocus);
    }

    @Override
    public void navigateUp() {
        this.treePanel.navigateUp();
    }

    @Override
    public void navigateDown() {
        this.treePanel.navigateDown();
    }

    @Override
    public void navigatePageUp() {
        this.treePanel.navigatePageUp();
    }

    @Override
    public void navigatePageDown() {
        this.treePanel.navigatePageDown();
    }

    @Override
    public void collapseOrGoToParent() {
        this.treePanel.collapseOrGoToParent();
    }

    @Override
    public void expandOrGoToChild() {
        this.treePanel.expandOrGoToChild();
    }

    @Override
    public void expandSelectedMore() {
        this.treePanel.expandSelectedMore();
    }

    @Override
    public void reduceSelectedExpansion() {
        this.treePanel.reduceSelectedExpansion();
    }

    void showNavigationButtonsForBreadcrumb(TreeNode node, int rowIndex) {
        this.treePanel.showNavigationButtonsForBreadcrumb(node, rowIndex);
    }

    void setBreadcrumbHeight(int height) {
        this.treePanel.setBreadcrumbHeight(height);
    }

    TreeNode getHoveredNode() {
        return this.treePanel.getVisibleNodes().getHoveredNode();
    }

    void resetHoveredNode() {
        this.treePanel.getVisibleNodes().setHoveredNode(null);
    }

    boolean isHoveredNodeContainedInBreadcrumb() {
        return this.treePanel.getVisibleNodes().isHoveredNodeContainedInBreadcrumb();
    }
}

