/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.net.URI;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.fop.pdf.PDFAMode;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.pdf.PDFSignParams;
import org.apache.fop.pdf.PDFUAMode;
import org.apache.fop.pdf.PDFVTMode;
import org.apache.fop.pdf.PDFXMode;
import org.apache.fop.pdf.Version;
import org.apache.fop.render.pdf.PDFRendererOption;

public final class PDFRendererOptionsConfig {
    static final PDFRendererOptionsConfig DEFAULT;
    private final Map<PDFRendererOption, Object> properties = new EnumMap<PDFRendererOption, Object>(PDFRendererOption.class);
    private final PDFEncryptionParams encryptionConfig;

    PDFRendererOptionsConfig(Map<PDFRendererOption, Object> props, PDFEncryptionParams encryptionParams) {
        this.properties.putAll(props);
        this.encryptionConfig = PDFRendererOptionsConfig.copyPDFEncryptionParams(encryptionParams);
    }

    private static PDFEncryptionParams copyPDFEncryptionParams(PDFEncryptionParams source) {
        return source == null ? null : new PDFEncryptionParams(source);
    }

    PDFRendererOptionsConfig merge(PDFRendererOptionsConfig config) {
        if (config == null) {
            return this;
        }
        return new PDFRendererOptionsConfig(PDFRendererOptionsConfig.merge(this.properties, config.properties), config.getEncryptionParameters() == null ? PDFRendererOptionsConfig.copyPDFEncryptionParams(this.encryptionConfig) : PDFRendererOptionsConfig.copyPDFEncryptionParams(config.getEncryptionParameters()));
    }

    private static Map<PDFRendererOption, Object> merge(Map<PDFRendererOption, Object> first, Map<PDFRendererOption, Object> second) {
        EnumMap<PDFRendererOption, Object> merged = new EnumMap<PDFRendererOption, Object>(PDFRendererOption.class);
        for (PDFRendererOption option : PDFRendererOption.values()) {
            Object value = second.get(option);
            if (value != null) {
                merged.put(option, value);
                continue;
            }
            merged.put(option, first.get(option));
        }
        return merged;
    }

    public Map<String, List<String>> getFilterMap() {
        return (Map)this.properties.get(PDFRendererOption.FILTER_LIST);
    }

    public PDFAMode getPDFAMode() {
        return (PDFAMode)((Object)this.properties.get(PDFRendererOption.PDF_A_MODE));
    }

    public PDFUAMode getPDFUAMode() {
        return (PDFUAMode)((Object)this.properties.get(PDFRendererOption.PDF_UA_MODE));
    }

    public PDFXMode getPDFXMode() {
        return (PDFXMode)((Object)this.properties.get(PDFRendererOption.PDF_X_MODE));
    }

    public PDFVTMode getPDFVTMode() {
        return (PDFVTMode)((Object)this.properties.get(PDFRendererOption.PDF_VT_MODE));
    }

    public PDFEncryptionParams getEncryptionParameters() {
        return this.encryptionConfig;
    }

    public PDFSignParams getSignParams() {
        return (PDFSignParams)this.properties.get(PDFRendererOption.SIGN_PARAMS);
    }

    public URI getOutputProfileURI() {
        return (URI)this.properties.get(PDFRendererOption.OUTPUT_PROFILE);
    }

    public Boolean getDisableSRGBColorSpace() {
        return (Boolean)this.properties.get(PDFRendererOption.DISABLE_SRGB_COLORSPACE);
    }

    public Version getPDFVersion() {
        return (Version)((Object)this.properties.get(PDFRendererOption.VERSION));
    }

    public Boolean getMergeFontsEnabled() {
        return (Boolean)this.properties.get(PDFRendererOption.MERGE_FONTS);
    }

    public Boolean getMergeFormFieldsEnabled() {
        return (Boolean)this.properties.get(PDFRendererOption.MERGE_FORM_FIELDS);
    }

    public Boolean getLinearizationEnabled() {
        return (Boolean)this.properties.get(PDFRendererOption.LINEARIZATION);
    }

    public Boolean getFormXObjectEnabled() {
        return (Boolean)this.properties.get(PDFRendererOption.FORM_XOBJECT);
    }

    public Boolean getObjectStreamsEnabled() {
        return (Boolean)this.properties.get(PDFRendererOption.OBJECT_STREAMS);
    }

    static {
        EnumMap<PDFRendererOption, Object> props = new EnumMap<PDFRendererOption, Object>(PDFRendererOption.class);
        for (PDFRendererOption option : PDFRendererOption.values()) {
            props.put(option, option.getDefaultValue());
        }
        DEFAULT = new PDFRendererOptionsConfig(props, null);
    }
}

