/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.util.LogBuilder;

public class ServerRegion
extends Region {
    public static final int PACIFIC_SCORE_VALUE = 100;
    private int size = 0;
    private Rectangle bounds = new Rectangle();

    public ServerRegion(Game game, String id) {
        super(game, id);
    }

    public ServerRegion(Game game, Region region) {
        super(game);
        this.name = region.getName();
        this.key = region.getKey();
        this.type = region.getType();
        this.parent = null;
        this.claimable = region.getClaimable();
        this.discoverable = region.getDiscoverable();
        this.discoveredIn = region.getDiscoveredIn();
        this.discoveredBy = region.getDiscoveredBy();
        this.scoreValue = region.getScoreValue();
    }

    public ServerRegion(Game game, Region.RegionType type) {
        this(game, null, type, null);
        this.setClaimable(type.getClaimable());
        this.setDiscoverable(true);
    }

    private ServerRegion(Map map, String key, Region.RegionType type, Region parent) {
        this(map.getGame(), key, type, parent);
        map.addRegion(this);
    }

    private ServerRegion(Game game, String key, Region.RegionType type, Region parent) {
        super(game);
        this.key = key;
        this.name = null;
        this.type = type;
        this.parent = parent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.claimable = false;
        this.discoverable = false;
        this.discoveredIn = null;
        this.discoveredBy = null;
        this.scoreValue = 0;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int size) {
        this.size = size;
    }

    public final Rectangle getBounds() {
        return this.bounds;
    }

    public final boolean isGeographic() {
        return this.key != null && this.type == Region.RegionType.LAND;
    }

    public int[] getCenter() {
        return new int[]{this.bounds.x + this.bounds.width / 2, this.bounds.y + this.bounds.height / 2};
    }

    public boolean containsCenter(ServerRegion other) {
        int[] xy = other.getCenter();
        return this.bounds.contains(xy[0], xy[1]);
    }

    public void addTile(Tile tile) {
        tile.setRegion(this);
        ++this.size;
        if (this.bounds.x == 0 && this.bounds.width == 0 || this.bounds.y == 0 && this.bounds.height == 0) {
            this.bounds.setBounds(tile.getX(), tile.getY(), 0, 0);
        } else {
            this.bounds.add(tile.getX(), tile.getY());
        }
    }

    public void csDiscover(Player player, Unit unit, Turn turn, String newName, ChangeSet cs) {
        int score;
        if (!this.getDiscoverable()) {
            return;
        }
        int n = score = this.getSpecification().getBoolean("model.option.explorationPoints") ? this.scoreValue : 0;
        if (!this.hasName()) {
            this.name = newName;
        }
        for (Region r : this.discover(player, unit, turn)) {
            cs.add(ChangeSet.See.all(), r);
        }
        HistoryEvent h = (HistoryEvent)((StringTemplate)new HistoryEvent(turn, HistoryEvent.HistoryEventType.DISCOVER_REGION, player).addStringTemplate("%nation%", player.getNationLabel())).addName("%region%", newName);
        h.setScore(score);
        cs.addGlobalHistory(this.getGame(), h);
    }

    private static int[] findYForThirdsOfLand(Map map) {
        int[] landTiles = new int[map.getHeight() - 1];
        long sum = 0L;
        for (Tile t : map) {
            if (!t.isLand() || t.isPolar()) continue;
            int n = t.getY();
            landTiles[n] = landTiles[n] + 1;
            ++sum;
        }
        return ServerRegion.findThirdsOfValues(landTiles, sum);
    }

    private static int[] findXForThirdsOfLand(Map map, int startY, int endY) {
        List<Tile> subMap = map.subMap(0, startY, map.getWidth() - 1, endY - startY + 1);
        int[] landTiles = new int[map.getWidth() - 1];
        long sum = 0L;
        for (Tile t : subMap) {
            if (!t.isLand() || t.isPolar()) continue;
            int n = t.getX();
            landTiles[n] = landTiles[n] + 1;
            ++sum;
        }
        return ServerRegion.findThirdsOfValues(landTiles, sum);
    }

    private static int[] findThirdsOfValues(int[] timesTheValue, long sum) {
        int[] result = new int[2];
        int accumulatedSum = 0;
        boolean needFirst = true;
        for (int i = 0; i < timesTheValue.length; ++i) {
            if (needFirst && (long)(accumulatedSum += timesTheValue[i]) >= sum / 3L) {
                result[0] = i;
                needFirst = false;
            }
            if ((long)accumulatedSum < 2L * sum / 3L) continue;
            result[1] = i;
            break;
        }
        return result;
    }

    private static Rectangle ensureWithinMap(Map map, Rectangle bounds) {
        int capX = Math.max(0, bounds.x);
        int capY = Math.max(0, bounds.y);
        int capWidth = Math.min(map.getWidth() - 1, bounds.x + Math.min(map.getWidth() - 1, bounds.width)) - capX;
        int capHeight = Math.min(map.getHeight() - 1, bounds.y + Math.min(map.getHeight() - 1, bounds.height)) - capY;
        return new Rectangle(capX, capY, capWidth, capHeight);
    }

    public static List<ServerRegion> requireFixedRegions(Map map, LogBuilder lb) {
        java.util.Map<String, Region> fixed = map.getFixedRegions();
        ArrayList<ServerRegion> result = new ArrayList<ServerRegion>(16);
        lb.add("Add regions ");
        int arcticHeight = 2;
        ServerRegion arctic = (ServerRegion)fixed.get("model.region.arctic");
        if (arctic == null) {
            arctic = new ServerRegion(map, "model.region.arctic", Region.RegionType.LAND, null);
            for (int x = 0; x < map.getWidth(); ++x) {
                for (int y = 0; y < 2; ++y) {
                    Tile tile;
                    if (!map.isValid(x, y) || !(tile = map.getTile(x, y)).isLand()) continue;
                    arctic.addTile(tile);
                }
            }
            lb.add("+arctic");
        }
        result.add(arctic);
        int antarcticHeight = map.getHeight() - 2 - 1;
        ServerRegion antarctic = (ServerRegion)fixed.get("model.region.antarctic");
        if (antarctic == null) {
            antarctic = new ServerRegion(map, "model.region.antarctic", Region.RegionType.LAND, null);
            for (int x = 0; x < map.getWidth(); ++x) {
                for (int y = antarcticHeight; y < map.getHeight(); ++y) {
                    Tile tile;
                    if (!map.isValid(x, y) || !(tile = map.getTile(x, y)).isLand()) continue;
                    antarctic.addTile(tile);
                }
            }
            lb.add("+antarctic");
        }
        result.add(antarctic);
        int[] yDelimiterThirds = ServerRegion.findYForThirdsOfLand(map);
        int[] xDelimiterThirds = ServerRegion.findXForThirdsOfLand(map, 0, yDelimiterThirds[0]);
        map.removeRegionsByKey("model.region.northWest");
        ServerRegion northWest = new ServerRegion(map, "model.region.northWest", Region.RegionType.LAND, null);
        northWest.bounds.setBounds(ServerRegion.ensureWithinMap(map, new Rectangle(0, 0, xDelimiterThirds[0], yDelimiterThirds[0])));
        map.addRegion(northWest);
        map.removeRegionsByKey("model.region.north");
        ServerRegion north = new ServerRegion(map, "model.region.north", Region.RegionType.LAND, null);
        north.bounds.setBounds(ServerRegion.ensureWithinMap(map, new Rectangle(xDelimiterThirds[0], 0, xDelimiterThirds[1] - xDelimiterThirds[0], yDelimiterThirds[0])));
        map.addRegion(north);
        map.removeRegionsByKey("model.region.northEast");
        ServerRegion northEast = new ServerRegion(map, "model.region.northEast", Region.RegionType.LAND, null);
        northEast.bounds.setBounds(ServerRegion.ensureWithinMap(map, new Rectangle(xDelimiterThirds[1], 0, Integer.MAX_VALUE, yDelimiterThirds[0])));
        map.addRegion(northEast);
        xDelimiterThirds = ServerRegion.findXForThirdsOfLand(map, yDelimiterThirds[0], yDelimiterThirds[1]);
        map.removeRegionsByKey("model.region.west");
        ServerRegion west = new ServerRegion(map, "model.region.west", Region.RegionType.LAND, null);
        west.bounds.setBounds(ServerRegion.ensureWithinMap(map, new Rectangle(0, yDelimiterThirds[0], xDelimiterThirds[0], yDelimiterThirds[1] - yDelimiterThirds[0])));
        map.addRegion(west);
        map.removeRegionsByKey("model.region.center");
        ServerRegion center = new ServerRegion(map, "model.region.center", Region.RegionType.LAND, null);
        center.bounds.setBounds(ServerRegion.ensureWithinMap(map, new Rectangle(xDelimiterThirds[0], yDelimiterThirds[0], xDelimiterThirds[1] - xDelimiterThirds[0], yDelimiterThirds[1] - yDelimiterThirds[0])));
        map.addRegion(center);
        map.removeRegionsByKey("model.region.east");
        ServerRegion east = new ServerRegion(map, "model.region.east", Region.RegionType.LAND, null);
        east.bounds.setBounds(ServerRegion.ensureWithinMap(map, new Rectangle(xDelimiterThirds[1], yDelimiterThirds[0], Integer.MAX_VALUE, yDelimiterThirds[1] - yDelimiterThirds[0])));
        map.addRegion(east);
        xDelimiterThirds = ServerRegion.findXForThirdsOfLand(map, yDelimiterThirds[1], map.getHeight() - 1);
        map.removeRegionsByKey("model.region.southWest");
        ServerRegion southWest = new ServerRegion(map, "model.region.southWest", Region.RegionType.LAND, null);
        southWest.bounds.setBounds(ServerRegion.ensureWithinMap(map, new Rectangle(0, yDelimiterThirds[1], xDelimiterThirds[0], Integer.MAX_VALUE)));
        map.addRegion(southWest);
        map.removeRegionsByKey("model.region.south");
        ServerRegion south = new ServerRegion(map, "model.region.south", Region.RegionType.LAND, null);
        south.bounds.setBounds(ServerRegion.ensureWithinMap(map, new Rectangle(xDelimiterThirds[0], yDelimiterThirds[1], xDelimiterThirds[1] - xDelimiterThirds[0], Integer.MAX_VALUE)));
        map.addRegion(south);
        map.removeRegionsByKey("model.region.southEast");
        ServerRegion southEast = new ServerRegion(map, "model.region.southEast", Region.RegionType.LAND, null);
        southEast.bounds.setBounds(ServerRegion.ensureWithinMap(map, new Rectangle(xDelimiterThirds[1], yDelimiterThirds[1], Integer.MAX_VALUE, Integer.MAX_VALUE)));
        map.addRegion(southEast);
        boolean allOceans = true;
        ServerRegion pacific = (ServerRegion)fixed.get("model.region.pacific");
        if (pacific == null) {
            pacific = new ServerRegion(map, "model.region.pacific", Region.RegionType.OCEAN, null);
            pacific.setDiscoverable(true);
            pacific.setScoreValue(100);
            allOceans = false;
            lb.add("+pacific");
        }
        result.add(pacific);
        ServerRegion northPacific = (ServerRegion)fixed.get("model.region.northPacific");
        if (northPacific == null) {
            northPacific = new ServerRegion(map, "model.region.northPacific", Region.RegionType.OCEAN, (Region)pacific);
            northPacific.setDiscoverable(false);
            allOceans = false;
            lb.add("+northPacific");
        }
        result.add(northPacific);
        ServerRegion southPacific = (ServerRegion)fixed.get("model.region.southPacific");
        if (southPacific == null) {
            southPacific = new ServerRegion(map, "model.region.southPacific", Region.RegionType.OCEAN, (Region)pacific);
            southPacific.setDiscoverable(false);
            allOceans = false;
            lb.add("+southPacific");
        }
        result.add(southPacific);
        ServerRegion atlantic = (ServerRegion)fixed.get("model.region.atlantic");
        if (atlantic == null) {
            atlantic = new ServerRegion(map, "model.region.atlantic", Region.RegionType.OCEAN, null);
            atlantic.setDiscoverable(false);
            allOceans = false;
            lb.add("+atlantic");
        }
        result.add(atlantic);
        ServerRegion northAtlantic = (ServerRegion)fixed.get("model.region.northAtlantic");
        if (northAtlantic == null) {
            northAtlantic = new ServerRegion(map, "model.region.northAtlantic", Region.RegionType.OCEAN, (Region)atlantic);
            northAtlantic.setDiscoverable(false);
            allOceans = false;
            lb.add("+northAtlantic");
        }
        result.add(northAtlantic);
        ServerRegion southAtlantic = (ServerRegion)fixed.get("model.region.southAtlantic");
        if (southAtlantic == null) {
            southAtlantic = new ServerRegion(map, "model.region.southAtlantic", Region.RegionType.OCEAN, (Region)atlantic);
            southAtlantic.setDiscoverable(false);
            allOceans = false;
            lb.add("+southAtlantic");
        }
        result.add(southAtlantic);
        if (!allOceans) {
            Tile t;
            int y;
            int maxx = map.getWidth();
            int midx = maxx / 2;
            int maxy = map.getHeight();
            int midy = maxy / 2;
            Tile tNP = null;
            Tile tSP = null;
            Tile tNA = null;
            Tile tSA = null;
            for (y = midy - 1; y >= 0; --y) {
                if (tNP == null && !(t = map.getTile(0, y)).isLand()) {
                    tNP = t;
                }
                if (tNA == null && !(t = map.getTile(maxx - 1, y)).isLand()) {
                    tNA = t;
                }
                if (tNP != null && tNA != null) break;
            }
            for (y = midy; y < maxy; ++y) {
                if (tSP == null && !(t = map.getTile(0, y)).isLand()) {
                    tSP = t;
                }
                if (tSA == null && !(t = map.getTile(maxx - 1, y)).isLand()) {
                    tSA = t;
                }
                if (tSP != null && tSA != null) break;
            }
            int nNP = 0;
            int nSP = 0;
            int nNA = 0;
            int nSA = 0;
            Rectangle rNP = new Rectangle(0, 0, midx, midy);
            Rectangle rSP = new Rectangle(0, midy, midx, maxy - midy);
            Rectangle rNA = new Rectangle(midx, 0, maxx - midx, midy);
            Rectangle rSA = new Rectangle(midx, midy, maxx - midx, maxy - midy);
            if (tNP != null) {
                nNP += ServerRegion.fillOcean(map, tNP, northPacific, rNP);
            }
            if (tSP != null) {
                nSP += ServerRegion.fillOcean(map, tSP, southPacific, rSP);
            }
            if (tNA != null) {
                nNA += ServerRegion.fillOcean(map, tNA, northAtlantic, rNA);
            }
            if (tSA != null) {
                nSA += ServerRegion.fillOcean(map, tSA, southAtlantic, rSA);
            }
            Rectangle rN = new Rectangle(0, 0, maxx, midy);
            Rectangle rS = new Rectangle(0, midy, maxx, maxy - midy);
            if (tNP != null) {
                nNP += ServerRegion.fillOcean(map, tNP, northPacific, rN);
            }
            if (tSP != null) {
                nSP += ServerRegion.fillOcean(map, tSP, southPacific, rS);
            }
            if (tNA != null) {
                nNA += ServerRegion.fillOcean(map, tNA, northAtlantic, rN);
            }
            if (tSA != null) {
                nSA += ServerRegion.fillOcean(map, tSA, southAtlantic, rS);
            }
            Rectangle rAll = new Rectangle(0, 0, maxx, maxy);
            if (tNP != null) {
                nNP += ServerRegion.fillOcean(map, tNP, northPacific, rAll);
            }
            if (tSP != null) {
                nSP += ServerRegion.fillOcean(map, tSP, southPacific, rAll);
            }
            if (tNA != null) {
                nNA += ServerRegion.fillOcean(map, tNA, northAtlantic, rAll);
            }
            if (tSA != null) {
                nSA += ServerRegion.fillOcean(map, tSA, southAtlantic, rAll);
            }
            lb.add(" filled ocean regions ", nNP, " North Pacific, ", nSP, " South Pacific, ", nNA, " North Atlantic, ", nSA, " South Atlantic.\n");
        }
        return result;
    }

    private static int fillOcean(Map map, Tile tile, ServerRegion region, Rectangle bounds) {
        LinkedList<Tile> q = new LinkedList<Tile>();
        int n = 0;
        boolean[][] visited = new boolean[map.getWidth()][map.getHeight()];
        visited[tile.getX()][tile.getY()] = true;
        q.add(tile);
        while ((tile = (Tile)q.poll()) != null) {
            region.addTile(tile);
            ++n;
            for (Direction direction : Direction.values()) {
                Tile t = map.getAdjacentTile(tile, direction);
                if (t == null || visited[t.getX()][t.getY()] || !bounds.contains(t.getX(), t.getY())) continue;
                visited[t.getX()][t.getY()] = true;
                if (t.getRegion() != null && t.getRegion() != region || t.isLand()) continue;
                q.add(t);
            }
        }
        return n;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(super.toString());
        sb.setLength(sb.length() - 1);
        sb.append(' ').append(this.size).append(' ').append(this.bounds).append(']');
        return sb.toString();
    }
}

