/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.engine.openai;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.AIModelFeature;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIBaseProperties;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIEngine;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIModels;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIProperties;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.internal.AIUIMessages;
import org.jkiss.dbeaver.ui.ai.model.CachedValue;
import org.jkiss.dbeaver.ui.ai.model.ContextWindowSizeField;
import org.jkiss.dbeaver.ui.ai.model.ModelSelectorField;
import org.jkiss.dbeaver.ui.ai.preferences.AIIObjectPropertyConfigurator;
import org.jkiss.utils.CommonUtils;

public class OpenAiConfigurator<ENGINE extends AIEngineDescriptor, PROPERTIES extends OpenAIProperties>
implements AIIObjectPropertyConfigurator<ENGINE, PROPERTIES> {
    private static final String API_KEY_URL = "https://platform.openai.com/account/api-keys";
    protected String baseUrl;
    protected volatile String token = "";
    private String temperature = "0.0";
    private boolean useLegacyApi;
    private boolean logQuery = false;
    @Nullable
    private Text baseUrlText;
    @Nullable
    protected Text tokenText;
    private Text temperatureText;
    private ModelSelectorField modelSelectorField;
    private ContextWindowSizeField contextWindowSizeField;
    private Button legacyApiCheck;
    private Button logQueryCheck;
    protected final CachedValue<List<AIModel>> modelsCache = new CachedValue(this::fetchOpenAiModels);

    public void createControl(@NotNull Composite parent, AIEngineDescriptor object, @NotNull Runnable propertyChangeListener) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)3);
        composite.setLayoutData((Object)new GridData(768));
        this.createConnectionParameters(composite);
        this.createModelParameters(composite);
        this.createBaseUrlParameter(composite);
        this.createAdditionalSettings(composite);
    }

    public void loadSettings(@NotNull PROPERTIES configuration) {
        this.baseUrl = CommonUtils.toString((Object)configuration.getBaseUrl());
        if (this.baseUrl.isEmpty()) {
            this.baseUrl = "https://api.openai.com/v1/";
        }
        this.token = CommonUtils.toString((Object)configuration.getToken());
        this.modelSelectorField.setSelectedModel(CommonUtils.toString((Object)configuration.getModel(), (String)"gpt-4o"));
        this.temperature = CommonUtils.toString((Object)configuration.getTemperature(), (String)"0.0");
        this.useLegacyApi = configuration.isLegacyApi();
        this.logQuery = CommonUtils.toBoolean((Object)configuration.isLoggingEnabled());
        this.applySettings();
        this.contextWindowSizeField.setValue(configuration.getContextWindowSize());
        this.modelSelectorField.refreshModelListSilently(false);
    }

    public void saveSettings(@NotNull PROPERTIES configuration) {
        configuration.setBaseUrl(this.baseUrl);
        configuration.setToken(this.token);
        configuration.setModel(this.modelSelectorField.getSelectedModel());
        configuration.setContextWindowSize(this.contextWindowSizeField.getValue());
        configuration.setTemperature(CommonUtils.toDouble((Object)this.temperature));
        configuration.setLegacyApi(this.useLegacyApi);
        configuration.setLoggingEnabled(this.logQuery);
    }

    public void resetSettings(@NotNull PROPERTIES openAIPropertiesLegacyAISettings) {
    }

    protected void createAdditionalSettings(@NotNull Composite parent) {
        this.legacyApiCheck = UIUtils.createCheckbox((Composite)parent, (String)"Use legacy API", (String)"Use legacy OpenAI API (chat). May be useful if you use OpenAI compatible engine which doesn't support 'responses' API.", (boolean)false, (int)2);
        this.legacyApiCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.useLegacyApi = this.legacyApiCheck.getSelection();
        }));
        this.logQueryCheck = UIUtils.createCheckbox((Composite)parent, (String)"Write AI queries to debug log", (String)"Write AI queries with metadata info in debug logs", (boolean)false, (int)2);
        this.logQueryCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.logQuery = this.logQueryCheck.getSelection();
        }));
    }

    protected void createModelParameters(@NotNull Composite parent) {
        this.modelSelectorField = ModelSelectorField.builder().withParent(parent).withGridData(new GridData(768)).withModelListSupplier((monitor, forceRefresh) -> this.modelsCache.get(monitor, forceRefresh).stream().filter(it -> it.features().contains(AIModelFeature.CHAT)).map(AIModel::name).toList()).withModifyListener(() -> OpenAIModels.getModelByName((String)this.modelSelectorField.getSelectedModel()).ifPresentOrElse(model -> {
            this.contextWindowSizeField.setValue(model.contextWindowSize());
            this.temperatureText.setText(String.valueOf(model.defaultTemperature()));
            this.temperatureText.setEnabled(OpenAIModels.isTemperatureEditable((AIModel)model));
        }, () -> {
            this.contextWindowSizeField.setValue(null);
            this.temperatureText.setText("0.0");
            this.temperatureText.setEnabled(true);
        })).build();
        this.contextWindowSizeField = ContextWindowSizeField.builder().withParent(parent).withGridData(GridDataFactory.fillDefaults().span(2, 1).create()).build();
        this.temperatureText = UIUtils.createLabelText((Composite)parent, (String)AIUIMessages.gpt_preference_page_text_temperature, (String)"0.0");
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        this.temperatureText.setToolTipText("Lower temperatures give more precise results");
        this.temperatureText.addModifyListener(e -> {
            this.temperature = this.temperatureText.getText();
        });
    }

    private List<AIModel> fetchOpenAiModels(DBRProgressMonitor monitor) throws DBException {
        if (this.token == null || this.token.isEmpty()) {
            throw new DBException("Token is not set");
        }
        OpenAIProperties properties = new OpenAIProperties();
        properties.setToken(this.token);
        properties.setBaseUrl(this.baseUrl);
        try (OpenAIEngine engine = new OpenAIEngine((OpenAIBaseProperties)properties);){
            List list = engine.getModels(monitor);
            return list;
        }
    }

    protected void createConnectionParameters(@NotNull Composite parent) {
        this.tokenText = UIUtils.createLabelText((Composite)parent, (String)AIUIMessages.gpt_preference_page_selector_token, (String)"", (int)0x400800);
        GridData gd = new GridData(768);
        gd.widthHint = 150;
        this.tokenText.setLayoutData((Object)gd);
        this.tokenText.addModifyListener(e -> {
            this.token = this.tokenText.getText();
        });
        this.tokenText.setMessage("API access token");
        this.createURLInfoLink(parent);
    }

    protected void createBaseUrlParameter(@NotNull Composite parent) {
        this.baseUrlText = UIUtils.createLabelText((Composite)parent, (String)AIUIMessages.gpt_preference_page_selector_base_url, (String)"");
        this.baseUrlText.addModifyListener(e -> {
            this.baseUrl = this.baseUrlText.getText();
        });
        GridData gd = new GridData(768);
        gd.widthHint = 150;
        this.baseUrlText.setLayoutData((Object)gd);
    }

    protected void createURLInfoLink(@NotNull Composite parent) {
        Link link = UIUtils.createLink((Composite)parent, (String)NLS.bind((String)AIUIMessages.gpt_preference_page_token_info, (Object)this.getApiKeyURL()), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.openWebBrowser((String)OpenAiConfigurator.this.getApiKeyURL());
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        link.setLayoutData((Object)gd);
    }

    protected String getApiKeyURL() {
        return API_KEY_URL;
    }

    protected void applySettings() {
        if (this.baseUrlText != null) {
            this.baseUrlText.setText(this.baseUrl);
        }
        if (this.tokenText != null) {
            this.tokenText.setText(this.token);
        }
        this.temperatureText.setText(this.temperature);
        this.legacyApiCheck.setSelection(this.useLegacyApi);
        this.logQueryCheck.setSelection(this.logQuery);
    }

    public boolean isComplete() {
        return this.tokenText != null && !this.tokenText.getText().isEmpty() && this.contextWindowSizeField.isComplete();
    }

    @Override
    public Optional<AIEngineProperties> getCurrentProperties() {
        OpenAIProperties propertiesCopy = new OpenAIProperties();
        propertiesCopy.setBaseUrl(this.baseUrl);
        propertiesCopy.setToken(this.token);
        propertiesCopy.setModel(this.modelSelectorField.getSelectedModel());
        propertiesCopy.setContextWindowSize(this.contextWindowSizeField.getValue());
        propertiesCopy.setTemperature(CommonUtils.toDouble((Object)this.temperature));
        propertiesCopy.setLegacyApi(this.useLegacyApi);
        propertiesCopy.setLoggingEnabled(this.logQuery);
        return Optional.of(propertiesCopy);
    }
}

