/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.tools.registry.ToolDescriptor;
import org.jkiss.dbeaver.tools.registry.ToolGroupDescriptor;

public class ToolsRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.tools";
    static final String TAG_TOOLS = "tools";
    static final String TAG_TOOL = "tool";
    static final String TAG_TOOL_GROUP = "toolGroup";
    private static ToolsRegistry instance = null;
    private final Map<String, ToolGroupDescriptor> toolGroups = new LinkedHashMap<String, ToolGroupDescriptor>();
    private final List<ToolDescriptor> tools = new ArrayList<ToolDescriptor>();

    public static synchronized ToolsRegistry getInstance() {
        if (instance == null) {
            instance = new ToolsRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ToolsRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        for (IConfigurationElement toolsElement : extConfigs = registry.getConfigurationElementsFor(EXTENSION_ID)) {
            for (IConfigurationElement toolElement : toolsElement.getChildren(TAG_TOOL_GROUP)) {
                ToolGroupDescriptor group = new ToolGroupDescriptor(toolElement);
                this.toolGroups.put(group.getId(), group);
            }
            for (IConfigurationElement toolElement : toolsElement.getChildren(TAG_TOOL)) {
                this.tools.add(new ToolDescriptor(toolElement));
            }
        }
    }

    public void dispose() {
        this.tools.clear();
        this.toolGroups.clear();
    }

    ToolGroupDescriptor getToolGroup(String id) {
        return this.toolGroups.get(id);
    }

    public List<ToolDescriptor> getTools() {
        return this.tools;
    }
}

