/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.commands;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLControlCommandHandler;
import org.jkiss.dbeaver.model.sql.SQLControlResult;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryListener;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SqlJobResult;
import org.jkiss.dbeaver.model.sql.eval.ScriptVariablesResolver;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.IncludedScriptFileEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SQLCommandInclude
implements SQLControlCommandHandler {
    private static final Log log = Log.getLog(SQLCommandInclude.class);

    @NotNull
    public SQLControlResult handleCommand(@NotNull DBRProgressMonitor monitor, @NotNull SQLControlCommand command, @NotNull SQLScriptContext scriptContext) throws DBException {
        String fileName = command.getParameter();
        Path includedFile = this.identifyIncludedScriptFile(fileName, scriptContext);
        this.verifyNoRecursiveInclusionIsPresent(scriptContext, includedFile, fileName);
        return this.getSqlControlResult(scriptContext, includedFile);
    }

    @NotNull
    private Path identifyIncludedScriptFile(@NotNull String fileName, @NotNull SQLScriptContext scriptContext) throws DBException {
        Path incFile;
        if (CommonUtils.isEmpty((String)fileName)) {
            throw new DBException("Empty input file");
        }
        fileName = GeneralUtils.replaceVariables((String)fileName, (IVariableResolver)new ScriptVariablesResolver(scriptContext), (boolean)true).trim();
        fileName = DBUtils.getUnQuotedIdentifier((DBPDataSource)scriptContext.getExecutionContext().getDataSource(), (String)fileName);
        Path curFile = scriptContext.getSourceFile();
        Path path = incFile = curFile == null ? Path.of(fileName, new String[0]) : curFile.getParent().resolve(fileName);
        if (!Files.exists(incFile, new LinkOption[0])) {
            incFile = Path.of(fileName, new String[0]);
        }
        if (!Files.exists(incFile, new LinkOption[0])) {
            throw new DBException("File '" + fileName + "' not found");
        }
        return incFile;
    }

    private void verifyNoRecursiveInclusionIsPresent(@NotNull SQLScriptContext scriptContext, @NotNull Path includedFile, @NotNull String fileName) throws DBException {
        SQLScriptContext sc = scriptContext;
        while (sc != null) {
            if (sc.getSourceFile() != null && sc.getSourceFile().equals(includedFile)) {
                throw new DBException("File '" + fileName + "' recursive inclusion");
            }
            sc = sc.getParentContext();
        }
    }

    @NotNull
    private SQLControlResult getSqlControlResult(@NotNull SQLScriptContext scriptContext, @NotNull Path includedScriptFile) throws DBException {
        IncludedScriptFileEditorInput editorInput = this.getInputForEditor(includedScriptFile);
        try {
            CompletableFuture<SQLControlResult> result = this.getSqlControlResultCompletableFuture(scriptContext, editorInput);
            return result.get();
        }
        catch (InterruptedException interruptedException) {
            return SQLControlResult.failure();
        }
        catch (ExecutionException e) {
            throw new DBException("Exception while included script execution", e.getCause());
        }
    }

    @NotNull
    private IncludedScriptFileEditorInput getInputForEditor(@NotNull Path pathToFile) {
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(pathToFile.toUri());
        IncludedScriptFileEditorInput input = new IncludedScriptFileEditorInput(fileStore, pathToFile);
        return input;
    }

    @NotNull
    private CompletableFuture<SQLControlResult> getSqlControlResultCompletableFuture(@NotNull SQLScriptContext scriptContext, @NotNull IncludedScriptFileEditorInput input) {
        CompletableFuture<SQLControlResult> result = new CompletableFuture<SQLControlResult>();
        UIUtils.syncExec(() -> {
            try {
                IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
                this.closeDuplicatedEditors(input.getIncludedScriptFile());
                SQLEditor sqlEditor = this.getSqlEditor(scriptContext, input, workbenchWindow);
                IncludeScriptListener scriptListener = new IncludeScriptListener(workbenchWindow, sqlEditor, result);
                boolean execResult = sqlEditor.processSQL(false, true, null, scriptListener);
                if (!execResult) {
                    result.complete(SQLControlResult.failure());
                }
            }
            catch (Throwable e) {
                log.error((Object)e);
                result.complete(SQLControlResult.failure());
            }
        });
        return result;
    }

    @NotNull
    private SQLEditor getSqlEditor(@NotNull SQLScriptContext scriptContext, @NotNull IncludedScriptFileEditorInput input, @NotNull IWorkbenchWindow workbenchWindow) {
        SQLEditor sqlEditor = SQLEditorHandlerOpenEditor.openNewSQLConsole(workbenchWindow, new SQLNavigatorContext(scriptContext, true), (IEditorInput)input);
        sqlEditor.reloadSyntaxRules();
        return sqlEditor;
    }

    private void closeDuplicatedEditors(@NotNull Path includedScriptFile) throws PartInitException {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorReference = iEditorReferenceArray[n6];
                    if (this.isEditorForSameIncludedScript(editorReference, includedScriptFile)) {
                        UIUtils.syncExec(() -> {
                            boolean bl = page.closeEditor(editorReference.getEditor(false), false);
                        });
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private boolean isEditorForSameIncludedScript(@NotNull IEditorReference editorReference, @NotNull Path includedScriptFile) throws PartInitException {
        IncludedScriptFileEditorInput includeInput;
        IEditorInput iEditorInput = editorReference.getEditorInput();
        return iEditorInput instanceof IncludedScriptFileEditorInput && (includeInput = (IncludedScriptFileEditorInput)iEditorInput).getIncludedScriptFile().toAbsolutePath().toString().equals(includedScriptFile.toAbsolutePath().toString());
    }

    private static class IncludeScriptListener
    implements SQLQueryListener {
        private final IWorkbenchWindow workbenchWindow;
        private final SQLEditor editor;
        private final CompletableFuture<SQLControlResult> result;

        IncludeScriptListener(@NotNull IWorkbenchWindow workbenchWindow, @NotNull SQLEditor editor, @NotNull CompletableFuture<SQLControlResult> result) {
            this.workbenchWindow = workbenchWindow;
            this.editor = editor;
            this.result = result;
        }

        public void onStartScript() {
        }

        public void onStartQuery(DBCSession session, SQLQuery query) {
        }

        public void onEndQuery(DBCSession session, SQLQueryResult result, DBCStatistics statistics) {
        }

        public void onEndScript(DBCStatistics statistics, boolean hasErrors) {
            if (this.isShouldCloseIncludedScript(hasErrors)) {
                UIUtils.syncExec(() -> {
                    boolean bl = this.workbenchWindow.getActivePage().closeEditor((IEditorPart)this.editor, false);
                });
            }
        }

        public void onEndSqlJob(DBCSession session, SqlJobResult result) {
            this.result.complete(result == SqlJobResult.SUCCESS ? SQLControlResult.success() : SQLControlResult.failure());
        }

        private boolean isShouldCloseIncludedScript(boolean hasErrors) {
            return !hasErrors && this.editor.getActivePreferenceStore().getBoolean("SQLEditor.closeIncludedScriptAfterExecution");
        }
    }
}

