/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        define([], factory);
    } else if (typeof exports === 'object' && typeof module !== 'undefined') {
        module.exports = factory();
    } else {
        root.TasClient = factory();
    }
}(typeof self !== 'undefined' ? self : typeof global !== 'undefined' ? global : this, function () {
"use strict";var __TasClientExports=(()=>{var w=Object.create;var m=Object.defineProperty;var S=Object.getOwnPropertyDescriptor;var D=Object.getOwnPropertyNames;var R=Object.getPrototypeOf,k=Object.prototype.hasOwnProperty;var T=(s=>typeof require<"u"?require:typeof Proxy<"u"?new Proxy(s,{get:(e,t)=>(typeof require<"u"?require:e)[t]}):s)(function(s){if(typeof require<"u")return require.apply(this,arguments);throw Error('Dynamic require of "'+s+'" is not supported')});var V=(s,e)=>{for(var t in e)m(s,t,{get:e[t],enumerable:!0})},I=(s,e,t,r)=>{if(e&&typeof e=="object"||typeof e=="function")for(let i of D(e))!k.call(s,i)&&i!==t&&m(s,i,{get:()=>e[i],enumerable:!(r=S(e,i))||r.enumerable});return s};var b=(s,e,t)=>(t=s!=null?w(R(s)):{},I(e||!s||!s.__esModule?m(t,"default",{value:s,enumerable:!0}):t,s)),A=s=>I(m({},"__esModule",{value:!0}),s);var N={};V(N,{ExperimentationService:()=>E});var p=class{constructor(e){this.telemetry=e}fetchPromise;isFetching=!1;async getFeatures(){if(this.isFetching&&this.fetchPromise)return this.fetchPromise;this.fetchPromise=this.fetch();let e=await this.fetchPromise;return this.isFetching=!1,this.fetchPromise=void 0,e}};var d=class extends p{constructor(t,r){super(t);this.telemetry=t;this.filterProviders=r}cachedTelemetryEvents=[];getFilters(){let t=new Map;for(let r of this.filterProviders){let i=r.getFilters();for(let o of i.keys()){let a=i.get(o);t.set(o,a)}}return t}PostEventToTelemetry(t){if(this.cachedTelemetryEvents.includes(t))return;let r=JSON.stringify(t);this.telemetry.postEvent("report-headers",new Map([["ABExp.headers",r]])),this.cachedTelemetryEvents.push(t)}};var C="call-tas-error",x="ErrorType",h=class extends d{constructor(t,r,i){super(r,i);this.httpClient=t;this.telemetry=r;this.filterProviders=i}async fetch(){let t=this.getFilters(),r={};for(let u of t.keys()){let n=t.get(u);r[u]=n}let i;try{i=await this.httpClient.get({headers:r})}catch(u){let n=u,c=new Map;n.responseReceived&&!n.responseOk?c.set(x,"ServerError"):n.responseReceived===!1?c.set(x,"NoResponse"):c.set(x,"GenericError"),this.telemetry.postEvent(C,c)}if(!i)throw Error(C);t.keys.length>0&&this.PostEventToTelemetry(r);let o=i.data,a=o.Configs,l=[];for(let u of a)if(u.Parameters)for(let n of Object.keys(u.Parameters)){let c=n+(u.Parameters[n]?"":"cf");l.includes(c)||l.push(c)}return{features:l,assignmentContext:o.AssignmentContext,configs:a}}};var f=class extends Error{constructor(t,r,i){super(t);this.responseReceived=r;this.responseOk=i}},g=class{constructor(e,t=typeof process<"u"&&!!process.versions.node){this.endpoint=e;this.useNodeModules=t}async get(e){return this.useNodeModules?this.nodeGet(e):this.webGet(e)}async nodeGet(e){let t=await import("http"),r=await import("https");return new Promise((i,o)=>{let a=(this.endpoint.startsWith("http:")?t:r).get(this.endpoint,e||{},l=>{if(l.statusCode<200||l.statusCode>299)o(new f("Response not ok",!0,!1));else{l.on("error",o);let u=[];l.on("data",n=>u.push(n)),l.on("end",()=>{try{let n=JSON.parse(Buffer.concat(u).toString());n?i({data:n}):o(new f("No data received",!1))}catch(n){o(n)}})}});a.on("error",o),a.end()})}async webGet(e){let t=await fetch(this.endpoint,{method:"GET",headers:e?.headers});if(!t)throw new f("No response received",!1);if(!t.ok)throw new f("Response not ok",!0,!1);let r=await t.json();if(!r)throw new f("No data received",!1);return{data:r}}};var v=class{storage=new Map;async getValue(e,t){return this.storage.has(e)?await Promise.resolve(this.storage.get(e)):await Promise.resolve(t||void 0)}setValue(e,t){this.storage.set(e,t)}};var y=class{constructor(e,t,r,i,o){this.telemetry=e;this.assignmentContextTelemetryPropertyName=t;this.telemetryEventName=r;this.storageKey=i;this.storage=o;this.storageKey||(this.storageKey="ABExp.Features"),this.storage||(o=new v),this.loadCachePromise=this.loadCachedFeatureData(),this.initializePromise=this.loadCachePromise,this.initialFetch=new Promise((a,l)=>{this.resolveInitialFetchPromise=a})}featureProviders;fetchPromise;featuresConsumed=!1;loadCachePromise;initializePromise;resolveInitialFetchPromise;initialFetch;cachedTelemetryEvents=[];_features={features:[],assignmentContext:"",configs:[]};get features(){return this._features}set features(e){this._features=e,this.telemetry&&this.telemetry.setSharedProperty(this.assignmentContextTelemetryPropertyName,this.features.assignmentContext)}async getFeaturesAsync(e=!1){if(this.fetchPromise!=null){try{await this.fetchPromise}catch{}return this.features}if(!this.featureProviders||this.featureProviders.length===0)return Promise.resolve({features:[],assignmentContext:"",configs:[]});try{this.fetchPromise=Promise.all(this.featureProviders.map(async r=>await r.getFeatures()));let t=await this.fetchPromise;this.updateFeatures(t,e)}catch{}return this.fetchPromise=void 0,this.resolveInitialFetchPromise&&(this.resolveInitialFetchPromise(),this.resolveInitialFetchPromise=void 0),this.features}updateFeatures(e,t=!1){let r={features:[],assignmentContext:"",configs:[]};for(let i of e){for(let o of i.features)r.features.includes(o)||r.features.push(o);for(let o of i.configs){let a=r.configs.find(l=>l.Id===o.Id);a?a.Parameters={...a.Parameters,...o.Parameters}:r.configs.push(o)}r.assignmentContext+=i.assignmentContext}(t||!this.featuresConsumed)&&(this.features=r),this.storage&&this.storage.setValue(this.storageKey,r)}async loadCachedFeatureData(){let e;this.storage&&(e=await this.storage.getValue(this.storageKey),e!==void 0&&e.configs===void 0&&(e.configs=[])),this.features.features.length===0&&(this.features=e||{features:[],assignmentContext:"",configs:[]})}isFlightEnabled(e){return this.featuresConsumed=!0,this.PostEventToTelemetry(e),this.features.features.includes(e)}async isCachedFlightEnabled(e){return await this.loadCachePromise,this.featuresConsumed=!0,this.PostEventToTelemetry(e),this.features.features.includes(e)}async isFlightEnabledAsync(e){let t=await this.getFeaturesAsync(!0);return this.featuresConsumed=!0,this.PostEventToTelemetry(e),t.features.includes(e)}getTreatmentVariable(e,t){return this.featuresConsumed=!0,this.PostEventToTelemetry(`${e}.${t}`),this.features.configs.find(i=>i.Id===e)?.Parameters[t]}async getTreatmentVariableAsync(e,t,r){if(r){let i=this.featuresConsumed,o=this.getTreatmentVariable(e,t);if(o===void 0)this.featuresConsumed=i;else return o}return await this.getFeaturesAsync(!0),this.getTreatmentVariable(e,t)}PostEventToTelemetry(e){this.cachedTelemetryEvents.includes(e)||(this.telemetry.postEvent(this.telemetryEventName,new Map([["ABExp.queriedFeature",e]])),this.cachedTelemetryEvents.push(e))}invokeInit(){this.init()}addFeatureProvider(...e){if(!(e==null||this.featureProviders==null))for(let t of e)this.featureProviders.push(t)}};var P=class{constructor(e){this.fetchInterval=e}intervalHandle;onTick;StopPolling(){clearInterval(this.intervalHandle),this.intervalHandle=void 0}OnPollTick(e){this.onTick=e}StartPolling(e=!1){this.intervalHandle&&this.StopPolling(),this.onTick!=null&&(e&&this.onTick().then(()=>{}).catch(()=>{}),this.intervalHandle=setInterval(async()=>{await this.onTick()},this.fetchInterval),this.intervalHandle.unref&&this.intervalHandle.unref())}};var F=class extends y{constructor(t,r,i,o,a,l,u){super(t,o,a,l,u);this.telemetry=t;this.filterProviders=r;this.refreshRateMs=i;this.assignmentContextTelemetryPropertyName=o;this.telemetryEventName=a;this.storageKey=l;this.storage=u;if(i<1e3&&i!==0)throw new Error("The minimum refresh rate for polling is 1000 ms (1 second). If you wish to deactivate this auto-polling use value of 0.");i>0&&(this.pollingService=new P(i),this.pollingService.OnPollTick(async()=>{await super.getFeaturesAsync()}))}pollingService;init(){this.pollingService?this.pollingService.StartPolling(!0):super.getFeaturesAsync()}async getFeaturesAsync(t=!1){if(this.pollingService){this.pollingService.StopPolling();let r=await super.getFeaturesAsync(t);return this.pollingService.StartPolling(),r}else return await super.getFeaturesAsync(t)}};var E=class extends F{constructor(t){super(t.telemetry,t.filterProviders||[],t.refetchInterval!=null?t.refetchInterval:0,t.assignmentContextTelemetryPropertyName,t.telemetryEventName,t.storageKey,t.keyValueStorage);this.options=t;this.invokeInit()}static REFRESH_RATE_IN_MINUTES=30;init(){this.featureProviders=[],this.addFeatureProvider(new h(new g(this.options.endpoint),this.telemetry,this.filterProviders)),super.init()}};return A(N);})();
return __TasClientExports;
}));//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c3a26841a84f20dfe0850d0a5a9bd01da4f003ea/node_modules/tas-client/dist/tas-client.min.js.map
