"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BrokenCircuitError = void 0;
class BrokenCircuitError extends Error {
    /**
     * Exception thrown from {@link CircuitBreakerPolicy.execute} when the
     * circuit breaker is open.
     */
    constructor(message = 'Execution prevented because the circuit breaker is open') {
        super(message);
        this.isBrokenCircuitError = true;
    }
}
exports.BrokenCircuitError = BrokenCircuitError;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/bdd88df003631aaa0bcbe057cb0a940b80a476fa/node_modules/cockatiel/dist/errors/BrokenCircuitError.js.map