﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/cost-optimization-hub/CostOptimizationHub_EXPORTS.h>
#include <aws/cost-optimization-hub/model/AccountEnrollmentStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CostOptimizationHub {
namespace Model {
class ListEnrollmentStatusesResult {
 public:
  AWS_COSTOPTIMIZATIONHUB_API ListEnrollmentStatusesResult() = default;
  AWS_COSTOPTIMIZATIONHUB_API ListEnrollmentStatusesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_COSTOPTIMIZATIONHUB_API ListEnrollmentStatusesResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The enrollment status of a specific account ID, including creation and last
   * updated timestamps.</p>
   */
  inline const Aws::Vector<AccountEnrollmentStatus>& GetItems() const { return m_items; }
  template <typename ItemsT = Aws::Vector<AccountEnrollmentStatus>>
  void SetItems(ItemsT&& value) {
    m_itemsHasBeenSet = true;
    m_items = std::forward<ItemsT>(value);
  }
  template <typename ItemsT = Aws::Vector<AccountEnrollmentStatus>>
  ListEnrollmentStatusesResult& WithItems(ItemsT&& value) {
    SetItems(std::forward<ItemsT>(value));
    return *this;
  }
  template <typename ItemsT = AccountEnrollmentStatus>
  ListEnrollmentStatusesResult& AddItems(ItemsT&& value) {
    m_itemsHasBeenSet = true;
    m_items.emplace_back(std::forward<ItemsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The enrollment status of all member accounts in the organization if the
   * account is the management account or delegated administrator.</p>
   */
  inline bool GetIncludeMemberAccounts() const { return m_includeMemberAccounts; }
  inline void SetIncludeMemberAccounts(bool value) {
    m_includeMemberAccountsHasBeenSet = true;
    m_includeMemberAccounts = value;
  }
  inline ListEnrollmentStatusesResult& WithIncludeMemberAccounts(bool value) {
    SetIncludeMemberAccounts(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to retrieve the next set of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListEnrollmentStatusesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListEnrollmentStatusesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<AccountEnrollmentStatus> m_items;

  bool m_includeMemberAccounts{false};

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_itemsHasBeenSet = false;
  bool m_includeMemberAccountsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CostOptimizationHub
}  // namespace Aws
