﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/storagegateway/StorageGateway_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace StorageGateway {
namespace Model {
/**
 * <p>A JSON object containing the following fields:</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateStorediSCSIVolumeOutput">AWS
 * API Reference</a></p>
 */
class CreateStorediSCSIVolumeResult {
 public:
  AWS_STORAGEGATEWAY_API CreateStorediSCSIVolumeResult() = default;
  AWS_STORAGEGATEWAY_API CreateStorediSCSIVolumeResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_STORAGEGATEWAY_API CreateStorediSCSIVolumeResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the configured volume.</p>
   */
  inline const Aws::String& GetVolumeARN() const { return m_volumeARN; }
  template <typename VolumeARNT = Aws::String>
  void SetVolumeARN(VolumeARNT&& value) {
    m_volumeARNHasBeenSet = true;
    m_volumeARN = std::forward<VolumeARNT>(value);
  }
  template <typename VolumeARNT = Aws::String>
  CreateStorediSCSIVolumeResult& WithVolumeARN(VolumeARNT&& value) {
    SetVolumeARN(std::forward<VolumeARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The size of the volume in bytes.</p>
   */
  inline long long GetVolumeSizeInBytes() const { return m_volumeSizeInBytes; }
  inline void SetVolumeSizeInBytes(long long value) {
    m_volumeSizeInBytesHasBeenSet = true;
    m_volumeSizeInBytes = value;
  }
  inline CreateStorediSCSIVolumeResult& WithVolumeSizeInBytes(long long value) {
    SetVolumeSizeInBytes(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI
   * name that initiators can use to connect to the target.</p>
   */
  inline const Aws::String& GetTargetARN() const { return m_targetARN; }
  template <typename TargetARNT = Aws::String>
  void SetTargetARN(TargetARNT&& value) {
    m_targetARNHasBeenSet = true;
    m_targetARN = std::forward<TargetARNT>(value);
  }
  template <typename TargetARNT = Aws::String>
  CreateStorediSCSIVolumeResult& WithTargetARN(TargetARNT&& value) {
    SetTargetARN(std::forward<TargetARNT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateStorediSCSIVolumeResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_volumeARN;

  long long m_volumeSizeInBytes{0};

  Aws::String m_targetARN;

  Aws::String m_requestId;
  bool m_volumeARNHasBeenSet = false;
  bool m_volumeSizeInBytesHasBeenSet = false;
  bool m_targetARNHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace StorageGateway
}  // namespace Aws
