/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.lang.reflect.Executable;
import java.time.DateTimeException;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Map;
import java.util.logging.Logger;

public final class OracleTemporalField {
    public static final TemporalField SIGNED_YEAR_OF_ERA;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;

    private OracleTemporalField() {
        throw new AssertionError((Object)"Not instantiable");
    }

    static {
        try {
            $$$methodRef$$$0 = OracleTemporalField.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        SIGNED_YEAR_OF_ERA = Field.SIGNED_YEAR_OF_ERA;
    }

    private static abstract class Field
    extends Enum<Field>
    implements TemporalField {
        public static final /* enum */ Field SIGNED_YEAR_OF_ERA;
        private static final /* synthetic */ Field[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;

        public static Field[] values() {
            return (Field[])$VALUES.clone();
        }

        public static Field valueOf(String name) {
            return Enum.valueOf(Field.class, name);
        }

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            return this.range();
        }

        private static boolean isIso(TemporalAccessor temporal) {
            return Chronology.from(temporal).equals(IsoChronology.INSTANCE);
        }

        static {
            try {
                $$$methodRef$$$8 = Field.class.getDeclaredConstructor(String.class, Integer.TYPE, oracle.jdbc.OracleTemporalField$1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = Field.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = Field.class.getDeclaredMethod("access$100", TemporalAccessor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = Field.class.getDeclaredMethod("isIso", TemporalAccessor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = Field.class.getDeclaredMethod("rangeRefinedBy", TemporalAccessor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = Field.class.getDeclaredMethod("isTimeBased", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = Field.class.getDeclaredMethod("isDateBased", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Field.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Field.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            SIGNED_YEAR_OF_ERA = new Field(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;
                private static Executable $$$methodRef$$$3;
                private static Logger $$$loggerRef$$$3;
                private static Executable $$$methodRef$$$4;
                private static Logger $$$loggerRef$$$4;
                private static Executable $$$methodRef$$$5;
                private static Logger $$$loggerRef$$$5;
                private static Executable $$$methodRef$$$6;
                private static Logger $$$loggerRef$$$6;
                private static Executable $$$methodRef$$$7;
                private static Logger $$$loggerRef$$$7;
                private static Executable $$$methodRef$$$8;
                private static Logger $$$loggerRef$$$8;
                private static Executable $$$methodRef$$$9;
                private static Logger $$$loggerRef$$$9;
                private static Executable $$$methodRef$$$10;
                private static Logger $$$loggerRef$$$10;

                @Override
                public TemporalUnit getBaseUnit() {
                    return ChronoUnit.YEARS;
                }

                @Override
                public TemporalUnit getRangeUnit() {
                    return ChronoUnit.FOREVER;
                }

                @Override
                public ValueRange range() {
                    return ValueRange.of(-9223372036854775807L, Long.MAX_VALUE);
                }

                @Override
                public boolean isSupportedBy(TemporalAccessor temporal) {
                    return temporal.isSupported(ChronoField.YEAR) && Field.isIso(temporal);
                }

                @Override
                public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
                    if (!this.isSupportedBy(temporal)) {
                        throw new UnsupportedTemporalTypeException("Unsupported field: SignedYearOfEra");
                    }
                    return this.range();
                }

                @Override
                public long getFrom(TemporalAccessor temporal) {
                    if (!this.isSupportedBy(temporal)) {
                        throw new UnsupportedTemporalTypeException("Unsupported field: SignedYearOfEra");
                    }
                    long year = temporal.getLong(ChronoField.YEAR);
                    return year < 1L ? year - 1L : year;
                }

                @Override
                public <R extends Temporal> R adjustInto(R temporal, long newValue) {
                    long curValue = this.getFrom(temporal);
                    if (newValue == 0L) {
                        throw new DateTimeException("0 is not a valid SignedYearOfEra");
                    }
                    return (R)temporal.with(ChronoField.YEAR, newValue < 1L ? newValue + 1L : newValue);
                }

                @Override
                public ChronoLocalDate resolve(Map<TemporalField, Long> fieldValues, TemporalAccessor partialTemporal, ResolverStyle resolverStyle) {
                    Long signedYear = fieldValues.get(this);
                    if (signedYear != null) {
                        if (signedYear == 0L) {
                            new DateTimeException("0 is not a valid SignedYearOfEra");
                        }
                        if (!Field.isIso(partialTemporal)) {
                            throw new DateTimeException("Resolve requires IsoChronology");
                        }
                        fieldValues.remove(this);
                        fieldValues.put(ChronoField.YEAR, signedYear < 1L ? signedYear + 1L : signedYear);
                    }
                    return null;
                }

                @Override
                public String toString() {
                    return "SignedYearOfEra";
                }

                static {
                    try {
                        $$$methodRef$$$10 = 1.class.getDeclaredConstructor(String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$9 = 1.class.getDeclaredMethod("resolve", Map.class, TemporalAccessor.class, ResolverStyle.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$8 = 1.class.getDeclaredMethod("toString", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$7 = 1.class.getDeclaredMethod("resolve", Map.class, TemporalAccessor.class, ResolverStyle.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$6 = 1.class.getDeclaredMethod("adjustInto", Temporal.class, Long.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$5 = 1.class.getDeclaredMethod("getFrom", TemporalAccessor.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$4 = 1.class.getDeclaredMethod("rangeRefinedBy", TemporalAccessor.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$3 = 1.class.getDeclaredMethod("isSupportedBy", TemporalAccessor.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$2 = 1.class.getDeclaredMethod("range", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredMethod("getRangeUnit", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("getBaseUnit", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            $VALUES = new Field[]{SIGNED_YEAR_OF_ERA};
        }
    }
}

