/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.firebirdsql.gds.JaybirdSystemProperties;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.jaybird.props.def.ConnectionProperty;
import org.firebirdsql.jaybird.props.internal.ConnectionPropertyRegistry;

public abstract class AbstractAttachProperties<T extends IAttachProperties<T>>
implements IAttachProperties<T> {
    private static final PropertyUpdateListener NULL_LISTENER = new PropertyUpdateListener(){

        @Override
        public void beforeUpdate(ConnectionProperty connectionProperty, Object newValue) {
        }

        @Override
        public void afterUpdate(ConnectionProperty connectionProperty, Object newValue) {
        }
    };
    private static final Pattern GMT_WITH_OFFSET = Pattern.compile("^GMT([+-]\\d{2}:\\d{2})$");
    private final Map<ConnectionProperty, Object> propertyValues;
    private PropertyUpdateListener propertyUpdateListener = NULL_LISTENER;

    protected AbstractAttachProperties(IAttachProperties<T> src) {
        this.propertyValues = src != null ? new HashMap<ConnectionProperty, Object>(src.connectionPropertyValues()) : new HashMap();
    }

    protected AbstractAttachProperties() {
        this.propertyValues = new HashMap<ConnectionProperty, Object>();
        this.setEnableProtocol(JaybirdSystemProperties.getDefaultEnableProtocol());
    }

    AbstractAttachProperties(HashMap<ConnectionProperty, Object> propertyValues) {
        this.propertyValues = propertyValues;
    }

    @Override
    public final void setProperty(String name, String value) {
        ConnectionProperty property = this.property(name);
        this.setProperty(property, property.type().toType(value));
    }

    @Override
    public final String getProperty(String name) {
        ConnectionProperty property = this.property(name);
        return property.type().asString(this.propertyValues.get(property));
    }

    @Override
    public final void setIntProperty(String name, Integer value) {
        ConnectionProperty property = this.property(name);
        this.setProperty(property, property.type().toType(value));
    }

    @Override
    public final Integer getIntProperty(String name) {
        ConnectionProperty property = this.property(name);
        return property.type().asInteger(this.propertyValues.get(property));
    }

    @Override
    public final void setBooleanProperty(String name, Boolean value) {
        ConnectionProperty property = this.property(name);
        this.setProperty(property, property.type().toType(value));
    }

    @Override
    public final Boolean getBooleanProperty(String name) {
        ConnectionProperty property = this.property(name);
        return property.type().asBoolean(this.propertyValues.get(property));
    }

    private void setProperty(ConnectionProperty property, Object value) {
        if (value == null) {
            value = this.resolveStoredDefaultValue(property);
        }
        if ("sessionTimeZone".equals(property.name())) {
            value = AbstractAttachProperties.normalizeTimezone(String.valueOf(value));
        }
        this.propertyUpdateListener.beforeUpdate(property, value);
        if (value != null) {
            this.propertyValues.put(property, property.validate(value));
        } else {
            this.propertyValues.remove(property);
        }
        this.dirtied();
        try {
            this.propertyUpdateListener.afterUpdate(property, value);
        }
        catch (Exception e) {
            System.getLogger(this.getClass().getName()).log(System.Logger.Level.WARNING, "Ignored exception calling propertyUpdateListener.afterUpdate", (Throwable)e);
        }
    }

    private static String normalizeTimezone(String timezone) {
        if (timezone == null) {
            return null;
        }
        Matcher matcher = GMT_WITH_OFFSET.matcher(timezone);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return timezone;
    }

    protected Object resolveStoredDefaultValue(ConnectionProperty property) {
        return null;
    }

    protected final ConnectionProperty property(String name) {
        return ConnectionPropertyRegistry.getInstance().getOrUnknown(name);
    }

    @Override
    public final Map<ConnectionProperty, Object> connectionPropertyValues() {
        return Collections.unmodifiableMap(this.propertyValues);
    }

    @Override
    public final boolean isImmutable() {
        return false;
    }

    public void registerPropertyUpdateListener(PropertyUpdateListener listener) {
        if (listener == null) {
            this.propertyUpdateListener = NULL_LISTENER;
        } else if (this.propertyUpdateListener == NULL_LISTENER) {
            this.propertyUpdateListener = listener;
        } else {
            throw new IllegalStateException("A listener is already registered");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractAttachProperties)) {
            return false;
        }
        AbstractAttachProperties that = (AbstractAttachProperties)o;
        return this.propertyValues.equals(that.propertyValues);
    }

    public int hashCode() {
        return this.propertyValues.hashCode();
    }

    protected abstract void dirtied();

    public static interface PropertyUpdateListener {
        public void beforeUpdate(ConnectionProperty var1, Object var2);

        public void afterUpdate(ConnectionProperty var1, Object var2);
    }
}

