\name{ValuedRegionalMaximaImageFilter}
\alias{ValuedRegionalMaximaImageFilter}
\title{ValuedRegionalMaximaImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Transforms the image so that any pixel that is not a regional maxima
is set to the minimum value for the pixel type. Pixels that are
regional maxima retain their value.
ValuedRegionalMaximaImageFilter}
\details{
Regional maxima are flat zones surrounded by pixels of lower value. A
completely flat image will be marked as a regional maxima by this
filter.
This code was contributed in the Insight Journal paper: "Finding
regional extrema - methods and performance" by Beare R., Lehmann G. https://www.insight-journal.org/browse/publication/65
Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.
See:
ValuedRegionalMinimaImageFilter
ValuedRegionalExtremaImageFilter
HMinimaImageFilter
ValuedRegionalMaxima for the procedural interface
itk::ValuedRegionalMaximaImageFilter for the Doxygen on the original ITK class.
ValuedRegionalMaximaImageFilter}
%C++ includes: sitkValuedRegionalMaximaImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFlat() const:}{
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{bool GetFullyConnected() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self SetFullyConnected(bool FullyConnected):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ValuedRegionalMaximaImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~ValuedRegionalMaximaImageFilter():}{
Destructor
}
}
}
