/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.find;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.ui.util.AugmentedJTextField;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.find.OWLEntityFinderPreferences;
import org.protege.editor.owl.ui.find.EntityFoundHandler;
import org.protege.editor.owl.ui.find.SearchStartedHandler;
import org.protege.editor.owl.ui.search.SearchPanel;
import org.semanticweb.owlapi.model.OWLEntity;

public class EntityFinderField
extends AugmentedJTextField {
    public static final int WINDOW_WIDTH = 800;
    private JWindow window;
    private JComponent parent;
    private SearchPanel searchPanel;
    private OWLEditorKit editorKit;
    private EntityFoundHandler entityFoundHandler = this::invokeDefaultEntityChosenHander;
    private SearchStartedHandler searchStartedHandler = () -> {};
    private boolean settingText = false;
    private final AbstractAction selectEntityAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            EntityFinderField.this.selectEntity();
        }
    };
    private Timer timer = new Timer(400, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            EntityFinderField.this.executeFind();
            EntityFinderField.this.timer.stop();
        }
    });

    public EntityFinderField(JComponent parent, OWLEditorKit editorKit) {
        super(20, "Search for entity");
        this.editorKit = editorKit;
        this.parent = parent;
        this.searchPanel = new SearchPanel(editorKit);
        this.getInputMap(0).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.getActionMap().put("ESC", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityFinderField.this.closeResults();
            }
        });
        this.selectEntityAction.setEnabled(false);
        this.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        this.getActionMap().put("ENTER", this.selectEntityAction);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    EntityFinderField.this.decrementListSelection();
                }
                if (e.getKeyCode() == 40) {
                    EntityFinderField.this.incrementListSelection();
                }
                if (e.getKeyCode() == 8) {
                    EntityFinderField.this.handleBackSpaceDown();
                }
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EntityFinderField.this.performFind();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EntityFinderField.this.performFind();
            }
        });
        this.searchPanel.setSearchResultClickedListener((searchResult, e) -> {
            if (e.getClickCount() == 2) {
                this.selectEntity();
            }
        });
    }

    public void setText(String t) {
        this.settingText = true;
        try {
            super.setText(t);
        }
        finally {
            this.settingText = false;
        }
    }

    public void setEntityFoundHandler(@Nonnull EntityFoundHandler handler) {
        this.entityFoundHandler = (EntityFoundHandler)Preconditions.checkNotNull((Object)handler);
    }

    public void setSearchStartedHandler(@Nonnull SearchStartedHandler searchStartedHandler) {
        this.searchStartedHandler = (SearchStartedHandler)Preconditions.checkNotNull((Object)searchStartedHandler);
    }

    private void selectEntity() {
        Optional<OWLEntity> selectedEntity = this.searchPanel.getSelectedEntity();
        if (selectedEntity.isPresent()) {
            this.entityFoundHandler.handleChosenEntity((OWLEntity)selectedEntity.get());
        }
        this.closeResults();
    }

    private void invokeDefaultEntityChosenHander(@Nonnull OWLEntity entity) {
        Optional<OWLEntity> selectedEntity = this.searchPanel.getSelectedEntity();
        if (selectedEntity.isPresent()) {
            this.editorKit.getWorkspace().getOWLSelectionModel().setSelectedEntity((OWLEntity)selectedEntity.get());
            this.editorKit.getWorkspace().displayOWLEntity((OWLEntity)selectedEntity.get());
        }
        this.closeResults();
    }

    private void handleBackSpaceDown() {
        if (this.getText().isEmpty()) {
            this.closeResults();
        }
    }

    private void incrementListSelection() {
        this.searchPanel.moveSelectionDown();
    }

    private void decrementListSelection() {
        this.searchPanel.moveSelectionUp();
    }

    private void closeResults() {
        this.getWindow().setVisible(false);
        this.selectEntityAction.setEnabled(false);
    }

    private void executeFind() {
        this.showResults();
    }

    private void performFind() {
        if (this.settingText) {
            return;
        }
        this.searchStartedHandler.handleSearchStarted();
        this.timer.setDelay((int)OWLEntityFinderPreferences.getInstance().getSearchDelay());
        this.timer.restart();
    }

    private JWindow getWindow() {
        if (this.window == null) {
            Window w = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.parent);
            this.window = new JWindow(w);
            this.window.setFocusableWindowState(false);
            JPanel popupContent = new JPanel(new BorderLayout(3, 3));
            popupContent.add(this.searchPanel);
            this.window.setContentPane(popupContent);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    EntityFinderField.this.window.setVisible(false);
                }
            });
            SwingUtilities.getRoot((Component)((Object)this)).addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    EntityFinderField.this.closeResults();
                }
            });
        }
        return this.window;
    }

    private void showResults() {
        int parentHeight;
        this.selectEntityAction.setEnabled(true);
        JWindow window = this.getWindow();
        Point pt = new Point(0, 0);
        SwingUtilities.convertPointToScreen(pt, (Component)((Object)this));
        window.setLocation(pt.x + (this.getWidth() - 800) / 2, pt.y + this.getHeight() + 2);
        Container parent = window.getParent();
        int height = 400;
        if (parent != null && (parentHeight = parent.getHeight()) > 400) {
            height = parentHeight * 3 / 4;
        }
        window.setSize(800, height);
        this.searchPanel.setSearchString(this.getText().trim());
        window.setVisible(true);
        window.validate();
    }
}

