"""
# Collections package

The Collections package provides a variety of collection classes, 
including map, set, range, heap, ring buffer, list, and flags.

`Map` - Hashmap by strutural equality (use `MapIs` for identity equality).

`Set` - A set built on top of `Map` using structural equility (use `SetIs` for identity equality).

`Range` - Iterate over a range of numbers with optional step size.

`BinaryHeap` - A priority queue implemented as a binary heap -- use a `BinaryHeapPriority` parameter to determine priority.

`RingBuffer` - A ring buffer with fixed size.

`List` - A doubly linked list.

`Flags` - A set of single bit flags (size determined upon creation).
"""
