import { $ as KeywordSpacingRuleOptions, A as NoWhitespaceBeforePropertyRuleOptions, At as EolLastRuleOptions, B as NoConfusingArrowRuleOptions, Bt as ArrowParensRuleOptions, C as PaddedBlocksRuleOptions, Ct as IndentRuleOptions, D as ObjectCurlySpacingRuleOptions, Dt as FunctionParenNewlineRuleOptions, E as ObjectPropertyNewlineRuleOptions, Et as GeneratorStarSpacingRuleOptions, F as NoMixedSpacesAndTabsRuleOptions, Ft as CommaSpacingRuleOptions, G as MemberDelimiterStyleRuleOptions, H as NewParensRuleOptions, Ht as ArrayBracketSpacingRuleOptions, I as NoMixedOperatorsRuleOptions, It as CommaDangleRuleOptions, J as ListStyleRuleOptions, K as MaxStatementsPerLineRuleOptions, L as NoFloatingDecimalRuleOptions, Lt as BraceStyleRuleOptions, M as NoTabsRuleOptions, Mt as CurlyNewlineRuleOptions, N as NoMultipleEmptyLinesRuleOptions, Nt as ComputedPropertySpacingRuleOptions, O as ObjectCurlyNewlineRuleOptions, Ot as FunctionCallSpacingRuleOptions, P as NoMultiSpacesRuleOptions, Pt as CommaStyleRuleOptions, Q as LineCommentPositionRuleOptions, R as NoExtraSemiRuleOptions, Rt as BlockSpacingRuleOptions, S as PaddingLineBetweenStatementsRuleOptions, St as JsxChildElementSpacingRuleOptions, T as OneVarDeclarationPerLineRuleOptions, Tt as ImplicitArrowLinebreakRuleOptions, U as MultilineTernaryRuleOptions, Ut as ArrayBracketNewlineRuleOptions, V as NewlinePerChainedCallRuleOptions, Vt as ArrayElementNewlineRuleOptions, W as MultilineCommentStyleRuleOptions, X as LinesAroundCommentRuleOptions, Y as LinesBetweenClassMembersRuleOptions, Z as LinebreakStyleRuleOptions, _ as SemiStyleRuleOptions, _t as JsxCurlySpacingRuleOptions, a as TypeGenericSpacingRuleOptions, at as JsxQuotesRuleOptions, b as QuotesRuleOptions, bt as JsxClosingTagLocationRuleOptions, c as TemplateCurlySpacingRuleOptions, ct as JsxPascalCaseRuleOptions, d as SpaceUnaryOpsRuleOptions, dt as JsxMaxPropsPerLineRuleOptions, et as KeySpacingRuleOptions, f as SpaceInfixOpsRuleOptions, ft as JsxIndentRuleOptions, g as SemiRuleOptions, gt as JsxEqualsSpacingRuleOptions, h as SpaceBeforeBlocksRuleOptions, ht as JsxFirstPropNewLineRuleOptions, i as TypeNamedTupleSpacingRuleOptions, it as JsxSelfClosingCompRuleOptions, j as NoTrailingSpacesRuleOptions, jt as DotLocationRuleOptions, k as NonblockStatementBodyPositionRuleOptions, kt as FunctionCallArgumentNewlineRuleOptions, l as SwitchColonSpacingRuleOptions, lt as JsxOneExpressionPerLineRuleOptions, m as SpaceBeforeFunctionParenRuleOptions, mt as JsxFunctionCallNewlineRuleOptions, n as WrapRegexRuleOptions, nt as JsxTagSpacingRuleOptions, o as TypeAnnotationSpacingRuleOptions, ot as JsxPropsStyleRuleOptions, p as SpaceInParensRuleOptions, pt as JsxIndentPropsRuleOptions, q as MaxLenRuleOptions, r as WrapIifeRuleOptions, rt as JsxSortPropsRuleOptions, s as TemplateTagSpacingRuleOptions, st as JsxPropsNoMultiSpacesRuleOptions, t as YieldStarSpacingRuleOptions, tt as JsxWrapMultilinesRuleOptions, u as SpacedCommentRuleOptions, ut as JsxNewlineRuleOptions, v as SemiSpacingRuleOptions, vt as JsxCurlyNewlineRuleOptions, w as OperatorLinebreakRuleOptions, wt as IndentBinaryOpsRuleOptions, x as QuotePropsRuleOptions, xt as JsxClosingBracketLocationRuleOptions, y as RestSpreadSpacingRuleOptions, yt as JsxCurlyBracePresenceRuleOptions, z as NoExtraParensRuleOptions, zt as ArrowSpacingRuleOptions } from "./types.mjs";

//#region dts/rule-options.d.ts
interface RuleOptions {
  /**
   * Enforce linebreaks after opening and before closing array brackets
   * @see https://eslint.style/rules/array-bracket-newline
   */
  '@stylistic/array-bracket-newline': ArrayBracketNewlineRuleOptions;
  /**
   * Enforce consistent spacing inside array brackets
   * @see https://eslint.style/rules/array-bracket-spacing
   */
  '@stylistic/array-bracket-spacing': ArrayBracketSpacingRuleOptions;
  /**
   * Enforce line breaks after each array element
   * @see https://eslint.style/rules/array-element-newline
   */
  '@stylistic/array-element-newline': ArrayElementNewlineRuleOptions;
  /**
   * Require parentheses around arrow function arguments
   * @see https://eslint.style/rules/arrow-parens
   */
  '@stylistic/arrow-parens': ArrowParensRuleOptions;
  /**
   * Enforce consistent spacing before and after the arrow in arrow functions
   * @see https://eslint.style/rules/arrow-spacing
   */
  '@stylistic/arrow-spacing': ArrowSpacingRuleOptions;
  /**
   * Disallow or enforce spaces inside of blocks after opening block and before closing block
   * @see https://eslint.style/rules/block-spacing
   */
  '@stylistic/block-spacing': BlockSpacingRuleOptions;
  /**
   * Enforce consistent brace style for blocks
   * @see https://eslint.style/rules/brace-style
   */
  '@stylistic/brace-style': BraceStyleRuleOptions;
  /**
   * Require or disallow trailing commas
   * @see https://eslint.style/rules/comma-dangle
   */
  '@stylistic/comma-dangle': CommaDangleRuleOptions;
  /**
   * Enforce consistent spacing before and after commas
   * @see https://eslint.style/rules/comma-spacing
   */
  '@stylistic/comma-spacing': CommaSpacingRuleOptions;
  /**
   * Enforce consistent comma style
   * @see https://eslint.style/rules/comma-style
   */
  '@stylistic/comma-style': CommaStyleRuleOptions;
  /**
   * Enforce consistent spacing inside computed property brackets
   * @see https://eslint.style/rules/computed-property-spacing
   */
  '@stylistic/computed-property-spacing': ComputedPropertySpacingRuleOptions;
  /**
   * Enforce consistent line breaks after opening and before closing braces
   * @see https://eslint.style/rules/curly-newline
   */
  '@stylistic/curly-newline': CurlyNewlineRuleOptions;
  /**
   * Enforce consistent newlines before and after dots
   * @see https://eslint.style/rules/dot-location
   */
  '@stylistic/dot-location': DotLocationRuleOptions;
  /**
   * Require or disallow newline at the end of files
   * @see https://eslint.style/rules/eol-last
   */
  '@stylistic/eol-last': EolLastRuleOptions;
  /**
   * Enforce line breaks between arguments of a function call
   * @see https://eslint.style/rules/function-call-argument-newline
   */
  '@stylistic/function-call-argument-newline': FunctionCallArgumentNewlineRuleOptions;
  /**
   * Require or disallow spacing between function identifiers and their invocations
   * @see https://eslint.style/rules/function-call-spacing
   */
  '@stylistic/function-call-spacing': FunctionCallSpacingRuleOptions;
  /**
   * Enforce consistent line breaks inside function parentheses
   * @see https://eslint.style/rules/function-paren-newline
   */
  '@stylistic/function-paren-newline': FunctionParenNewlineRuleOptions;
  /**
   * Enforce consistent spacing around `*` operators in generator functions
   * @see https://eslint.style/rules/generator-star-spacing
   */
  '@stylistic/generator-star-spacing': GeneratorStarSpacingRuleOptions;
  /**
   * Enforce the location of arrow function bodies
   * @see https://eslint.style/rules/implicit-arrow-linebreak
   */
  '@stylistic/implicit-arrow-linebreak': ImplicitArrowLinebreakRuleOptions;
  /**
   * Enforce consistent indentation
   * @see https://eslint.style/rules/indent
   */
  '@stylistic/indent': IndentRuleOptions;
  /**
   * Indentation for binary operators
   * @see https://eslint.style/rules/indent-binary-ops
   */
  '@stylistic/indent-binary-ops': IndentBinaryOpsRuleOptions;
  /**
   * Enforce or disallow spaces inside of curly braces in JSX attributes and expressions
   * @see https://eslint.style/rules/jsx-child-element-spacing
   */
  '@stylistic/jsx-child-element-spacing': JsxChildElementSpacingRuleOptions;
  /**
   * Enforce closing bracket location in JSX
   * @see https://eslint.style/rules/jsx-closing-bracket-location
   */
  '@stylistic/jsx-closing-bracket-location': JsxClosingBracketLocationRuleOptions;
  /**
   * Enforce closing tag location for multiline JSX
   * @see https://eslint.style/rules/jsx-closing-tag-location
   */
  '@stylistic/jsx-closing-tag-location': JsxClosingTagLocationRuleOptions;
  /**
   * Disallow unnecessary JSX expressions when literals alone are sufficient or enforce JSX expressions on literals in JSX children or attributes
   * @see https://eslint.style/rules/jsx-curly-brace-presence
   */
  '@stylistic/jsx-curly-brace-presence': JsxCurlyBracePresenceRuleOptions;
  /**
   * Enforce consistent linebreaks in curly braces in JSX attributes and expressions
   * @see https://eslint.style/rules/jsx-curly-newline
   */
  '@stylistic/jsx-curly-newline': JsxCurlyNewlineRuleOptions;
  /**
   * Enforce or disallow spaces inside of curly braces in JSX attributes and expressions
   * @see https://eslint.style/rules/jsx-curly-spacing
   */
  '@stylistic/jsx-curly-spacing': JsxCurlySpacingRuleOptions;
  /**
   * Enforce or disallow spaces around equal signs in JSX attributes
   * @see https://eslint.style/rules/jsx-equals-spacing
   */
  '@stylistic/jsx-equals-spacing': JsxEqualsSpacingRuleOptions;
  /**
   * Enforce proper position of the first property in JSX
   * @see https://eslint.style/rules/jsx-first-prop-new-line
   */
  '@stylistic/jsx-first-prop-new-line': JsxFirstPropNewLineRuleOptions;
  /**
   * Enforce line breaks before and after JSX elements when they are used as arguments to a function.
   * @see https://eslint.style/rules/jsx-function-call-newline
   */
  '@stylistic/jsx-function-call-newline': JsxFunctionCallNewlineRuleOptions;
  /**
   * Enforce JSX indentation. Deprecated, use `indent` rule instead.
   * @see https://eslint.style/rules/jsx-indent
   */
  '@stylistic/jsx-indent': JsxIndentRuleOptions;
  /**
   * Enforce props indentation in JSX
   * @see https://eslint.style/rules/jsx-indent-props
   */
  '@stylistic/jsx-indent-props': JsxIndentPropsRuleOptions;
  /**
   * Enforce maximum of props on a single line in JSX
   * @see https://eslint.style/rules/jsx-max-props-per-line
   */
  '@stylistic/jsx-max-props-per-line': JsxMaxPropsPerLineRuleOptions;
  /**
   * Require or prevent a new line after jsx elements and expressions.
   * @see https://eslint.style/rules/jsx-newline
   */
  '@stylistic/jsx-newline': JsxNewlineRuleOptions;
  /**
   * Require one JSX element per line
   * @see https://eslint.style/rules/jsx-one-expression-per-line
   */
  '@stylistic/jsx-one-expression-per-line': JsxOneExpressionPerLineRuleOptions;
  /**
   * Enforce PascalCase for user-defined JSX components
   * @see https://eslint.style/rules/jsx-pascal-case
   */
  '@stylistic/jsx-pascal-case': JsxPascalCaseRuleOptions;
  /**
   * Disallow multiple spaces between inline JSX props. Deprecated, use `no-multi-spaces` rule instead.
   * @see https://eslint.style/rules/jsx-props-no-multi-spaces
   */
  '@stylistic/jsx-props-no-multi-spaces': JsxPropsNoMultiSpacesRuleOptions;
  /**
   * Enforce consistent line break styles for JSX props
   * @see https://eslint.style/rules/jsx-props-style
   */
  '@stylistic/exp-jsx-props-style': JsxPropsStyleRuleOptions;
  /**
   * Enforce the consistent use of either double or single quotes in JSX attributes
   * @see https://eslint.style/rules/jsx-quotes
   */
  '@stylistic/jsx-quotes': JsxQuotesRuleOptions;
  /**
   * Disallow extra closing tags for components without children
   * @see https://eslint.style/rules/jsx-self-closing-comp
   */
  '@stylistic/jsx-self-closing-comp': JsxSelfClosingCompRuleOptions;
  /**
   * Enforce props alphabetical sorting
   * @see https://eslint.style/rules/jsx-sort-props
   */
  '@stylistic/jsx-sort-props': JsxSortPropsRuleOptions;
  /**
   * Enforce whitespace in and around the JSX opening and closing brackets
   * @see https://eslint.style/rules/jsx-tag-spacing
   */
  '@stylistic/jsx-tag-spacing': JsxTagSpacingRuleOptions;
  /**
   * Disallow missing parentheses around multiline JSX
   * @see https://eslint.style/rules/jsx-wrap-multilines
   */
  '@stylistic/jsx-wrap-multilines': JsxWrapMultilinesRuleOptions;
  /**
   * Enforce consistent spacing between property names and type annotations in types and interfaces
   * @see https://eslint.style/rules/key-spacing
   */
  '@stylistic/key-spacing': KeySpacingRuleOptions;
  /**
   * Enforce consistent spacing before and after keywords
   * @see https://eslint.style/rules/keyword-spacing
   */
  '@stylistic/keyword-spacing': KeywordSpacingRuleOptions;
  /**
   * Enforce position of line comments
   * @see https://eslint.style/rules/line-comment-position
   */
  '@stylistic/line-comment-position': LineCommentPositionRuleOptions;
  /**
   * Enforce consistent linebreak style
   * @see https://eslint.style/rules/linebreak-style
   */
  '@stylistic/linebreak-style': LinebreakStyleRuleOptions;
  /**
   * Require empty lines around comments
   * @see https://eslint.style/rules/lines-around-comment
   */
  '@stylistic/lines-around-comment': LinesAroundCommentRuleOptions;
  /**
   * Require or disallow an empty line between class members
   * @see https://eslint.style/rules/lines-between-class-members
   */
  '@stylistic/lines-between-class-members': LinesBetweenClassMembersRuleOptions;
  /**
   * Enforce consistent spacing and line break styles inside brackets.
   * @see https://eslint.style/rules/list-style
   */
  '@stylistic/exp-list-style': ListStyleRuleOptions;
  /**
   * Enforce a maximum line length
   * @see https://eslint.style/rules/max-len
   */
  '@stylistic/max-len': MaxLenRuleOptions;
  /**
   * Enforce a maximum number of statements allowed per line
   * @see https://eslint.style/rules/max-statements-per-line
   */
  '@stylistic/max-statements-per-line': MaxStatementsPerLineRuleOptions;
  /**
   * Require a specific member delimiter style for interfaces and type literals
   * @see https://eslint.style/rules/member-delimiter-style
   */
  '@stylistic/member-delimiter-style': MemberDelimiterStyleRuleOptions;
  /**
   * Enforce a particular style for multiline comments
   * @see https://eslint.style/rules/multiline-comment-style
   */
  '@stylistic/multiline-comment-style': MultilineCommentStyleRuleOptions;
  /**
   * Enforce newlines between operands of ternary expressions
   * @see https://eslint.style/rules/multiline-ternary
   */
  '@stylistic/multiline-ternary': MultilineTernaryRuleOptions;
  /**
   * Enforce or disallow parentheses when invoking a constructor with no arguments
   * @see https://eslint.style/rules/new-parens
   */
  '@stylistic/new-parens': NewParensRuleOptions;
  /**
   * Require a newline after each call in a method chain
   * @see https://eslint.style/rules/newline-per-chained-call
   */
  '@stylistic/newline-per-chained-call': NewlinePerChainedCallRuleOptions;
  /**
   * Disallow arrow functions where they could be confused with comparisons
   * @see https://eslint.style/rules/no-confusing-arrow
   */
  '@stylistic/no-confusing-arrow': NoConfusingArrowRuleOptions;
  /**
   * Disallow unnecessary parentheses
   * @see https://eslint.style/rules/no-extra-parens
   */
  '@stylistic/no-extra-parens': NoExtraParensRuleOptions;
  /**
   * Disallow unnecessary semicolons
   * @see https://eslint.style/rules/no-extra-semi
   */
  '@stylistic/no-extra-semi': NoExtraSemiRuleOptions;
  /**
   * Disallow leading or trailing decimal points in numeric literals
   * @see https://eslint.style/rules/no-floating-decimal
   */
  '@stylistic/no-floating-decimal': NoFloatingDecimalRuleOptions;
  /**
   * Disallow mixed binary operators
   * @see https://eslint.style/rules/no-mixed-operators
   */
  '@stylistic/no-mixed-operators': NoMixedOperatorsRuleOptions;
  /**
   * Disallow mixed spaces and tabs for indentation
   * @see https://eslint.style/rules/no-mixed-spaces-and-tabs
   */
  '@stylistic/no-mixed-spaces-and-tabs': NoMixedSpacesAndTabsRuleOptions;
  /**
   * Disallow multiple spaces
   * @see https://eslint.style/rules/no-multi-spaces
   */
  '@stylistic/no-multi-spaces': NoMultiSpacesRuleOptions;
  /**
   * Disallow multiple empty lines
   * @see https://eslint.style/rules/no-multiple-empty-lines
   */
  '@stylistic/no-multiple-empty-lines': NoMultipleEmptyLinesRuleOptions;
  /**
   * Disallow all tabs
   * @see https://eslint.style/rules/no-tabs
   */
  '@stylistic/no-tabs': NoTabsRuleOptions;
  /**
   * Disallow trailing whitespace at the end of lines
   * @see https://eslint.style/rules/no-trailing-spaces
   */
  '@stylistic/no-trailing-spaces': NoTrailingSpacesRuleOptions;
  /**
   * Disallow whitespace before properties
   * @see https://eslint.style/rules/no-whitespace-before-property
   */
  '@stylistic/no-whitespace-before-property': NoWhitespaceBeforePropertyRuleOptions;
  /**
   * Enforce the location of single-line statements
   * @see https://eslint.style/rules/nonblock-statement-body-position
   */
  '@stylistic/nonblock-statement-body-position': NonblockStatementBodyPositionRuleOptions;
  /**
   * Enforce consistent line breaks after opening and before closing braces
   * @see https://eslint.style/rules/object-curly-newline
   */
  '@stylistic/object-curly-newline': ObjectCurlyNewlineRuleOptions;
  /**
   * Enforce consistent spacing inside braces
   * @see https://eslint.style/rules/object-curly-spacing
   */
  '@stylistic/object-curly-spacing': ObjectCurlySpacingRuleOptions;
  /**
   * Enforce placing object properties on separate lines
   * @see https://eslint.style/rules/object-property-newline
   */
  '@stylistic/object-property-newline': ObjectPropertyNewlineRuleOptions;
  /**
   * Require or disallow newlines around variable declarations
   * @see https://eslint.style/rules/one-var-declaration-per-line
   */
  '@stylistic/one-var-declaration-per-line': OneVarDeclarationPerLineRuleOptions;
  /**
   * Enforce consistent linebreak style for operators
   * @see https://eslint.style/rules/operator-linebreak
   */
  '@stylistic/operator-linebreak': OperatorLinebreakRuleOptions;
  /**
   * Require or disallow padding within blocks
   * @see https://eslint.style/rules/padded-blocks
   */
  '@stylistic/padded-blocks': PaddedBlocksRuleOptions;
  /**
   * Require or disallow padding lines between statements
   * @see https://eslint.style/rules/padding-line-between-statements
   */
  '@stylistic/padding-line-between-statements': PaddingLineBetweenStatementsRuleOptions;
  /**
   * Require quotes around object literal, type literal, interfaces and enums property names
   * @see https://eslint.style/rules/quote-props
   */
  '@stylistic/quote-props': QuotePropsRuleOptions;
  /**
   * Enforce the consistent use of either backticks, double, or single quotes
   * @see https://eslint.style/rules/quotes
   */
  '@stylistic/quotes': QuotesRuleOptions;
  /**
   * Enforce spacing between rest and spread operators and their expressions
   * @see https://eslint.style/rules/rest-spread-spacing
   */
  '@stylistic/rest-spread-spacing': RestSpreadSpacingRuleOptions;
  /**
   * Require or disallow semicolons instead of ASI
   * @see https://eslint.style/rules/semi
   */
  '@stylistic/semi': SemiRuleOptions;
  /**
   * Enforce consistent spacing before and after semicolons
   * @see https://eslint.style/rules/semi-spacing
   */
  '@stylistic/semi-spacing': SemiSpacingRuleOptions;
  /**
   * Enforce location of semicolons
   * @see https://eslint.style/rules/semi-style
   */
  '@stylistic/semi-style': SemiStyleRuleOptions;
  /**
   * Enforce consistent spacing before blocks
   * @see https://eslint.style/rules/space-before-blocks
   */
  '@stylistic/space-before-blocks': SpaceBeforeBlocksRuleOptions;
  /**
   * Enforce consistent spacing before function parenthesis
   * @see https://eslint.style/rules/space-before-function-paren
   */
  '@stylistic/space-before-function-paren': SpaceBeforeFunctionParenRuleOptions;
  /**
   * Enforce consistent spacing inside parentheses
   * @see https://eslint.style/rules/space-in-parens
   */
  '@stylistic/space-in-parens': SpaceInParensRuleOptions;
  /**
   * Require spacing around infix operators
   * @see https://eslint.style/rules/space-infix-ops
   */
  '@stylistic/space-infix-ops': SpaceInfixOpsRuleOptions;
  /**
   * Enforce consistent spacing before or after unary operators
   * @see https://eslint.style/rules/space-unary-ops
   */
  '@stylistic/space-unary-ops': SpaceUnaryOpsRuleOptions;
  /**
   * Enforce consistent spacing after the `//` or `/*` in a comment
   * @see https://eslint.style/rules/spaced-comment
   */
  '@stylistic/spaced-comment': SpacedCommentRuleOptions;
  /**
   * Enforce spacing around colons of switch statements
   * @see https://eslint.style/rules/switch-colon-spacing
   */
  '@stylistic/switch-colon-spacing': SwitchColonSpacingRuleOptions;
  /**
   * Require or disallow spacing around embedded expressions of template strings
   * @see https://eslint.style/rules/template-curly-spacing
   */
  '@stylistic/template-curly-spacing': TemplateCurlySpacingRuleOptions;
  /**
   * Require or disallow spacing between template tags and their literals
   * @see https://eslint.style/rules/template-tag-spacing
   */
  '@stylistic/template-tag-spacing': TemplateTagSpacingRuleOptions;
  /**
   * Require consistent spacing around type annotations
   * @see https://eslint.style/rules/type-annotation-spacing
   */
  '@stylistic/type-annotation-spacing': TypeAnnotationSpacingRuleOptions;
  /**
   * Enforces consistent spacing inside TypeScript type generics
   * @see https://eslint.style/rules/type-generic-spacing
   */
  '@stylistic/type-generic-spacing': TypeGenericSpacingRuleOptions;
  /**
   * Expect space before the type declaration in the named tuple
   * @see https://eslint.style/rules/type-named-tuple-spacing
   */
  '@stylistic/type-named-tuple-spacing': TypeNamedTupleSpacingRuleOptions;
  /**
   * Require parentheses around immediate `function` invocations
   * @see https://eslint.style/rules/wrap-iife
   */
  '@stylistic/wrap-iife': WrapIifeRuleOptions;
  /**
   * Require parenthesis around regex literals
   * @see https://eslint.style/rules/wrap-regex
   */
  '@stylistic/wrap-regex': WrapRegexRuleOptions;
  /**
   * Require or disallow spacing around the `*` in `yield*` expressions
   * @see https://eslint.style/rules/yield-star-spacing
   */
  '@stylistic/yield-star-spacing': YieldStarSpacingRuleOptions;
}
interface UnprefixedRuleOptions {
  /**
   * Enforce linebreaks after opening and before closing array brackets
   * @see https://eslint.style/rules/array-bracket-newline
   */
  'array-bracket-newline': ArrayBracketNewlineRuleOptions;
  /**
   * Enforce consistent spacing inside array brackets
   * @see https://eslint.style/rules/array-bracket-spacing
   */
  'array-bracket-spacing': ArrayBracketSpacingRuleOptions;
  /**
   * Enforce line breaks after each array element
   * @see https://eslint.style/rules/array-element-newline
   */
  'array-element-newline': ArrayElementNewlineRuleOptions;
  /**
   * Require parentheses around arrow function arguments
   * @see https://eslint.style/rules/arrow-parens
   */
  'arrow-parens': ArrowParensRuleOptions;
  /**
   * Enforce consistent spacing before and after the arrow in arrow functions
   * @see https://eslint.style/rules/arrow-spacing
   */
  'arrow-spacing': ArrowSpacingRuleOptions;
  /**
   * Disallow or enforce spaces inside of blocks after opening block and before closing block
   * @see https://eslint.style/rules/block-spacing
   */
  'block-spacing': BlockSpacingRuleOptions;
  /**
   * Enforce consistent brace style for blocks
   * @see https://eslint.style/rules/brace-style
   */
  'brace-style': BraceStyleRuleOptions;
  /**
   * Require or disallow trailing commas
   * @see https://eslint.style/rules/comma-dangle
   */
  'comma-dangle': CommaDangleRuleOptions;
  /**
   * Enforce consistent spacing before and after commas
   * @see https://eslint.style/rules/comma-spacing
   */
  'comma-spacing': CommaSpacingRuleOptions;
  /**
   * Enforce consistent comma style
   * @see https://eslint.style/rules/comma-style
   */
  'comma-style': CommaStyleRuleOptions;
  /**
   * Enforce consistent spacing inside computed property brackets
   * @see https://eslint.style/rules/computed-property-spacing
   */
  'computed-property-spacing': ComputedPropertySpacingRuleOptions;
  /**
   * Enforce consistent line breaks after opening and before closing braces
   * @see https://eslint.style/rules/curly-newline
   */
  'curly-newline': CurlyNewlineRuleOptions;
  /**
   * Enforce consistent newlines before and after dots
   * @see https://eslint.style/rules/dot-location
   */
  'dot-location': DotLocationRuleOptions;
  /**
   * Require or disallow newline at the end of files
   * @see https://eslint.style/rules/eol-last
   */
  'eol-last': EolLastRuleOptions;
  /**
   * Enforce line breaks between arguments of a function call
   * @see https://eslint.style/rules/function-call-argument-newline
   */
  'function-call-argument-newline': FunctionCallArgumentNewlineRuleOptions;
  /**
   * Require or disallow spacing between function identifiers and their invocations
   * @see https://eslint.style/rules/function-call-spacing
   */
  'function-call-spacing': FunctionCallSpacingRuleOptions;
  /**
   * Enforce consistent line breaks inside function parentheses
   * @see https://eslint.style/rules/function-paren-newline
   */
  'function-paren-newline': FunctionParenNewlineRuleOptions;
  /**
   * Enforce consistent spacing around `*` operators in generator functions
   * @see https://eslint.style/rules/generator-star-spacing
   */
  'generator-star-spacing': GeneratorStarSpacingRuleOptions;
  /**
   * Enforce the location of arrow function bodies
   * @see https://eslint.style/rules/implicit-arrow-linebreak
   */
  'implicit-arrow-linebreak': ImplicitArrowLinebreakRuleOptions;
  /**
   * Enforce consistent indentation
   * @see https://eslint.style/rules/indent
   */
  'indent': IndentRuleOptions;
  /**
   * Indentation for binary operators
   * @see https://eslint.style/rules/indent-binary-ops
   */
  'indent-binary-ops': IndentBinaryOpsRuleOptions;
  /**
   * Enforce or disallow spaces inside of curly braces in JSX attributes and expressions
   * @see https://eslint.style/rules/jsx-child-element-spacing
   */
  'jsx-child-element-spacing': JsxChildElementSpacingRuleOptions;
  /**
   * Enforce closing bracket location in JSX
   * @see https://eslint.style/rules/jsx-closing-bracket-location
   */
  'jsx-closing-bracket-location': JsxClosingBracketLocationRuleOptions;
  /**
   * Enforce closing tag location for multiline JSX
   * @see https://eslint.style/rules/jsx-closing-tag-location
   */
  'jsx-closing-tag-location': JsxClosingTagLocationRuleOptions;
  /**
   * Disallow unnecessary JSX expressions when literals alone are sufficient or enforce JSX expressions on literals in JSX children or attributes
   * @see https://eslint.style/rules/jsx-curly-brace-presence
   */
  'jsx-curly-brace-presence': JsxCurlyBracePresenceRuleOptions;
  /**
   * Enforce consistent linebreaks in curly braces in JSX attributes and expressions
   * @see https://eslint.style/rules/jsx-curly-newline
   */
  'jsx-curly-newline': JsxCurlyNewlineRuleOptions;
  /**
   * Enforce or disallow spaces inside of curly braces in JSX attributes and expressions
   * @see https://eslint.style/rules/jsx-curly-spacing
   */
  'jsx-curly-spacing': JsxCurlySpacingRuleOptions;
  /**
   * Enforce or disallow spaces around equal signs in JSX attributes
   * @see https://eslint.style/rules/jsx-equals-spacing
   */
  'jsx-equals-spacing': JsxEqualsSpacingRuleOptions;
  /**
   * Enforce proper position of the first property in JSX
   * @see https://eslint.style/rules/jsx-first-prop-new-line
   */
  'jsx-first-prop-new-line': JsxFirstPropNewLineRuleOptions;
  /**
   * Enforce line breaks before and after JSX elements when they are used as arguments to a function.
   * @see https://eslint.style/rules/jsx-function-call-newline
   */
  'jsx-function-call-newline': JsxFunctionCallNewlineRuleOptions;
  /**
   * Enforce JSX indentation. Deprecated, use `indent` rule instead.
   * @see https://eslint.style/rules/jsx-indent
   */
  'jsx-indent': JsxIndentRuleOptions;
  /**
   * Enforce props indentation in JSX
   * @see https://eslint.style/rules/jsx-indent-props
   */
  'jsx-indent-props': JsxIndentPropsRuleOptions;
  /**
   * Enforce maximum of props on a single line in JSX
   * @see https://eslint.style/rules/jsx-max-props-per-line
   */
  'jsx-max-props-per-line': JsxMaxPropsPerLineRuleOptions;
  /**
   * Require or prevent a new line after jsx elements and expressions.
   * @see https://eslint.style/rules/jsx-newline
   */
  'jsx-newline': JsxNewlineRuleOptions;
  /**
   * Require one JSX element per line
   * @see https://eslint.style/rules/jsx-one-expression-per-line
   */
  'jsx-one-expression-per-line': JsxOneExpressionPerLineRuleOptions;
  /**
   * Enforce PascalCase for user-defined JSX components
   * @see https://eslint.style/rules/jsx-pascal-case
   */
  'jsx-pascal-case': JsxPascalCaseRuleOptions;
  /**
   * Disallow multiple spaces between inline JSX props. Deprecated, use `no-multi-spaces` rule instead.
   * @see https://eslint.style/rules/jsx-props-no-multi-spaces
   */
  'jsx-props-no-multi-spaces': JsxPropsNoMultiSpacesRuleOptions;
  /**
   * Enforce consistent line break styles for JSX props
   * @see https://eslint.style/rules/jsx-props-style
   */
  'exp-jsx-props-style': JsxPropsStyleRuleOptions;
  /**
   * Enforce the consistent use of either double or single quotes in JSX attributes
   * @see https://eslint.style/rules/jsx-quotes
   */
  'jsx-quotes': JsxQuotesRuleOptions;
  /**
   * Disallow extra closing tags for components without children
   * @see https://eslint.style/rules/jsx-self-closing-comp
   */
  'jsx-self-closing-comp': JsxSelfClosingCompRuleOptions;
  /**
   * Enforce props alphabetical sorting
   * @see https://eslint.style/rules/jsx-sort-props
   */
  'jsx-sort-props': JsxSortPropsRuleOptions;
  /**
   * Enforce whitespace in and around the JSX opening and closing brackets
   * @see https://eslint.style/rules/jsx-tag-spacing
   */
  'jsx-tag-spacing': JsxTagSpacingRuleOptions;
  /**
   * Disallow missing parentheses around multiline JSX
   * @see https://eslint.style/rules/jsx-wrap-multilines
   */
  'jsx-wrap-multilines': JsxWrapMultilinesRuleOptions;
  /**
   * Enforce consistent spacing between property names and type annotations in types and interfaces
   * @see https://eslint.style/rules/key-spacing
   */
  'key-spacing': KeySpacingRuleOptions;
  /**
   * Enforce consistent spacing before and after keywords
   * @see https://eslint.style/rules/keyword-spacing
   */
  'keyword-spacing': KeywordSpacingRuleOptions;
  /**
   * Enforce position of line comments
   * @see https://eslint.style/rules/line-comment-position
   */
  'line-comment-position': LineCommentPositionRuleOptions;
  /**
   * Enforce consistent linebreak style
   * @see https://eslint.style/rules/linebreak-style
   */
  'linebreak-style': LinebreakStyleRuleOptions;
  /**
   * Require empty lines around comments
   * @see https://eslint.style/rules/lines-around-comment
   */
  'lines-around-comment': LinesAroundCommentRuleOptions;
  /**
   * Require or disallow an empty line between class members
   * @see https://eslint.style/rules/lines-between-class-members
   */
  'lines-between-class-members': LinesBetweenClassMembersRuleOptions;
  /**
   * Enforce consistent spacing and line break styles inside brackets.
   * @see https://eslint.style/rules/list-style
   */
  'exp-list-style': ListStyleRuleOptions;
  /**
   * Enforce a maximum line length
   * @see https://eslint.style/rules/max-len
   */
  'max-len': MaxLenRuleOptions;
  /**
   * Enforce a maximum number of statements allowed per line
   * @see https://eslint.style/rules/max-statements-per-line
   */
  'max-statements-per-line': MaxStatementsPerLineRuleOptions;
  /**
   * Require a specific member delimiter style for interfaces and type literals
   * @see https://eslint.style/rules/member-delimiter-style
   */
  'member-delimiter-style': MemberDelimiterStyleRuleOptions;
  /**
   * Enforce a particular style for multiline comments
   * @see https://eslint.style/rules/multiline-comment-style
   */
  'multiline-comment-style': MultilineCommentStyleRuleOptions;
  /**
   * Enforce newlines between operands of ternary expressions
   * @see https://eslint.style/rules/multiline-ternary
   */
  'multiline-ternary': MultilineTernaryRuleOptions;
  /**
   * Enforce or disallow parentheses when invoking a constructor with no arguments
   * @see https://eslint.style/rules/new-parens
   */
  'new-parens': NewParensRuleOptions;
  /**
   * Require a newline after each call in a method chain
   * @see https://eslint.style/rules/newline-per-chained-call
   */
  'newline-per-chained-call': NewlinePerChainedCallRuleOptions;
  /**
   * Disallow arrow functions where they could be confused with comparisons
   * @see https://eslint.style/rules/no-confusing-arrow
   */
  'no-confusing-arrow': NoConfusingArrowRuleOptions;
  /**
   * Disallow unnecessary parentheses
   * @see https://eslint.style/rules/no-extra-parens
   */
  'no-extra-parens': NoExtraParensRuleOptions;
  /**
   * Disallow unnecessary semicolons
   * @see https://eslint.style/rules/no-extra-semi
   */
  'no-extra-semi': NoExtraSemiRuleOptions;
  /**
   * Disallow leading or trailing decimal points in numeric literals
   * @see https://eslint.style/rules/no-floating-decimal
   */
  'no-floating-decimal': NoFloatingDecimalRuleOptions;
  /**
   * Disallow mixed binary operators
   * @see https://eslint.style/rules/no-mixed-operators
   */
  'no-mixed-operators': NoMixedOperatorsRuleOptions;
  /**
   * Disallow mixed spaces and tabs for indentation
   * @see https://eslint.style/rules/no-mixed-spaces-and-tabs
   */
  'no-mixed-spaces-and-tabs': NoMixedSpacesAndTabsRuleOptions;
  /**
   * Disallow multiple spaces
   * @see https://eslint.style/rules/no-multi-spaces
   */
  'no-multi-spaces': NoMultiSpacesRuleOptions;
  /**
   * Disallow multiple empty lines
   * @see https://eslint.style/rules/no-multiple-empty-lines
   */
  'no-multiple-empty-lines': NoMultipleEmptyLinesRuleOptions;
  /**
   * Disallow all tabs
   * @see https://eslint.style/rules/no-tabs
   */
  'no-tabs': NoTabsRuleOptions;
  /**
   * Disallow trailing whitespace at the end of lines
   * @see https://eslint.style/rules/no-trailing-spaces
   */
  'no-trailing-spaces': NoTrailingSpacesRuleOptions;
  /**
   * Disallow whitespace before properties
   * @see https://eslint.style/rules/no-whitespace-before-property
   */
  'no-whitespace-before-property': NoWhitespaceBeforePropertyRuleOptions;
  /**
   * Enforce the location of single-line statements
   * @see https://eslint.style/rules/nonblock-statement-body-position
   */
  'nonblock-statement-body-position': NonblockStatementBodyPositionRuleOptions;
  /**
   * Enforce consistent line breaks after opening and before closing braces
   * @see https://eslint.style/rules/object-curly-newline
   */
  'object-curly-newline': ObjectCurlyNewlineRuleOptions;
  /**
   * Enforce consistent spacing inside braces
   * @see https://eslint.style/rules/object-curly-spacing
   */
  'object-curly-spacing': ObjectCurlySpacingRuleOptions;
  /**
   * Enforce placing object properties on separate lines
   * @see https://eslint.style/rules/object-property-newline
   */
  'object-property-newline': ObjectPropertyNewlineRuleOptions;
  /**
   * Require or disallow newlines around variable declarations
   * @see https://eslint.style/rules/one-var-declaration-per-line
   */
  'one-var-declaration-per-line': OneVarDeclarationPerLineRuleOptions;
  /**
   * Enforce consistent linebreak style for operators
   * @see https://eslint.style/rules/operator-linebreak
   */
  'operator-linebreak': OperatorLinebreakRuleOptions;
  /**
   * Require or disallow padding within blocks
   * @see https://eslint.style/rules/padded-blocks
   */
  'padded-blocks': PaddedBlocksRuleOptions;
  /**
   * Require or disallow padding lines between statements
   * @see https://eslint.style/rules/padding-line-between-statements
   */
  'padding-line-between-statements': PaddingLineBetweenStatementsRuleOptions;
  /**
   * Require quotes around object literal, type literal, interfaces and enums property names
   * @see https://eslint.style/rules/quote-props
   */
  'quote-props': QuotePropsRuleOptions;
  /**
   * Enforce the consistent use of either backticks, double, or single quotes
   * @see https://eslint.style/rules/quotes
   */
  'quotes': QuotesRuleOptions;
  /**
   * Enforce spacing between rest and spread operators and their expressions
   * @see https://eslint.style/rules/rest-spread-spacing
   */
  'rest-spread-spacing': RestSpreadSpacingRuleOptions;
  /**
   * Require or disallow semicolons instead of ASI
   * @see https://eslint.style/rules/semi
   */
  'semi': SemiRuleOptions;
  /**
   * Enforce consistent spacing before and after semicolons
   * @see https://eslint.style/rules/semi-spacing
   */
  'semi-spacing': SemiSpacingRuleOptions;
  /**
   * Enforce location of semicolons
   * @see https://eslint.style/rules/semi-style
   */
  'semi-style': SemiStyleRuleOptions;
  /**
   * Enforce consistent spacing before blocks
   * @see https://eslint.style/rules/space-before-blocks
   */
  'space-before-blocks': SpaceBeforeBlocksRuleOptions;
  /**
   * Enforce consistent spacing before function parenthesis
   * @see https://eslint.style/rules/space-before-function-paren
   */
  'space-before-function-paren': SpaceBeforeFunctionParenRuleOptions;
  /**
   * Enforce consistent spacing inside parentheses
   * @see https://eslint.style/rules/space-in-parens
   */
  'space-in-parens': SpaceInParensRuleOptions;
  /**
   * Require spacing around infix operators
   * @see https://eslint.style/rules/space-infix-ops
   */
  'space-infix-ops': SpaceInfixOpsRuleOptions;
  /**
   * Enforce consistent spacing before or after unary operators
   * @see https://eslint.style/rules/space-unary-ops
   */
  'space-unary-ops': SpaceUnaryOpsRuleOptions;
  /**
   * Enforce consistent spacing after the `//` or `/*` in a comment
   * @see https://eslint.style/rules/spaced-comment
   */
  'spaced-comment': SpacedCommentRuleOptions;
  /**
   * Enforce spacing around colons of switch statements
   * @see https://eslint.style/rules/switch-colon-spacing
   */
  'switch-colon-spacing': SwitchColonSpacingRuleOptions;
  /**
   * Require or disallow spacing around embedded expressions of template strings
   * @see https://eslint.style/rules/template-curly-spacing
   */
  'template-curly-spacing': TemplateCurlySpacingRuleOptions;
  /**
   * Require or disallow spacing between template tags and their literals
   * @see https://eslint.style/rules/template-tag-spacing
   */
  'template-tag-spacing': TemplateTagSpacingRuleOptions;
  /**
   * Require consistent spacing around type annotations
   * @see https://eslint.style/rules/type-annotation-spacing
   */
  'type-annotation-spacing': TypeAnnotationSpacingRuleOptions;
  /**
   * Enforces consistent spacing inside TypeScript type generics
   * @see https://eslint.style/rules/type-generic-spacing
   */
  'type-generic-spacing': TypeGenericSpacingRuleOptions;
  /**
   * Expect space before the type declaration in the named tuple
   * @see https://eslint.style/rules/type-named-tuple-spacing
   */
  'type-named-tuple-spacing': TypeNamedTupleSpacingRuleOptions;
  /**
   * Require parentheses around immediate `function` invocations
   * @see https://eslint.style/rules/wrap-iife
   */
  'wrap-iife': WrapIifeRuleOptions;
  /**
   * Require parenthesis around regex literals
   * @see https://eslint.style/rules/wrap-regex
   */
  'wrap-regex': WrapRegexRuleOptions;
  /**
   * Require or disallow spacing around the `*` in `yield*` expressions
   * @see https://eslint.style/rules/yield-star-spacing
   */
  'yield-star-spacing': YieldStarSpacingRuleOptions;
}
//#endregion
export { RuleOptions, UnprefixedRuleOptions };